# This file was auto-generated by Fern from our API Definition.

from ...core.pydantic_utilities import UniversalBaseModel
from .address import Address
from .age import Age
from .annotation import Annotation
from .attachment import Attachment
from .codeable_concept import CodeableConcept
from .coding import Coding
from .contact_detail import ContactDetail
from .contact_point import ContactPoint
from .contributor import Contributor
from .count import Count
from .data_requirement import DataRequirement
from .data_requirement_code_filter import DataRequirementCodeFilter
from .data_requirement_date_filter import DataRequirementDateFilter
from .data_requirement_sort import DataRequirementSort
from .distance import Distance
from .dosage import Dosage
from .dosage_dose_and_rate import DosageDoseAndRate
from .duration import Duration
from .expression import Expression
from .extension import Extension
from .human_name import HumanName
from .identifier import Identifier
from .meta import Meta
from .money import Money
from .parameter_definition import ParameterDefinition
from .period import Period
from .quantity import Quantity
from .range import Range
from .ratio import Ratio
from .reference import Reference
from .related_artifact import RelatedArtifact
from .sampled_data import SampledData
from .signature import Signature
from .timing import Timing
from .timing_repeat import TimingRepeat
from .trigger_definition import TriggerDefinition
from .usage_context import UsageContext
import typing
import pydantic
import typing_extensions
from ...core.serialization import FieldMetadata
from .plan_definition_target import PlanDefinitionTarget
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class PlanDefinitionGoal(UniversalBaseModel):
    """
    This resource allows for the definition of various types of plans as a sharable, consumable, and executable artifact. The resource is general enough to support the description of a broad range of clinical artifacts such as clinical decision support rules, order sets and protocols.
    """

    id: typing.Optional[str] = pydantic.Field(default=None)
    """
    Unique id for the element within a resource (for internal references). This may be any string value that does not contain spaces.
    """

    extension: typing.Optional[typing.List[Extension]] = pydantic.Field(default=None)
    """
    May be used to represent additional information that is not part of the basic definition of the element. To make the use of extensions safe and manageable, there is a strict set of governance applied to the definition and use of extensions. Though any implementer can define an extension, there is a set of requirements that SHALL be met as part of the definition of the extension.
    """

    modifier_extension: typing_extensions.Annotated[
        typing.Optional[typing.List[Extension]],
        FieldMetadata(alias="modifierExtension"),
    ] = pydantic.Field(default=None)
    """
    May be used to represent additional information that is not part of the basic definition of the element and that modifies the understanding of the element in which it is contained and/or the understanding of the containing element's descendants. Usually modifier elements provide negation or qualification. To make the use of extensions safe and manageable, there is a strict set of governance applied to the definition and use of extensions. Though any implementer can define an extension, there is a set of requirements that SHALL be met as part of the definition of the extension. Applications processing a resource are required to check for modifier extensions. Modifier extensions SHALL NOT change the meaning of any elements on Resource or DomainResource (including cannot change the meaning of modifierExtension itself).
    """

    category: typing.Optional[CodeableConcept] = pydantic.Field(default=None)
    """
    Indicates a category the goal falls within.
    """

    description: CodeableConcept = pydantic.Field()
    """
    Human-readable and/or coded description of a specific desired objective of care, such as "control blood pressure" or "negotiate an obstacle course" or "dance with child at wedding".
    """

    priority: typing.Optional[CodeableConcept] = pydantic.Field(default=None)
    """
    Identifies the expected level of importance associated with reaching/sustaining the defined goal.
    """

    start: typing.Optional[CodeableConcept] = pydantic.Field(default=None)
    """
    The event after which the goal should begin being pursued.
    """

    addresses: typing.Optional[typing.List[CodeableConcept]] = pydantic.Field(
        default=None
    )
    """
    Identifies problems, conditions, issues, or concerns the goal is intended to address.
    """

    documentation: typing.Optional[typing.List[RelatedArtifact]] = pydantic.Field(
        default=None
    )
    """
    Didactic or other informational resources associated with the goal that provide further supporting information about the goal. Information resources can include inline text commentary and links to web resources.
    """

    target: typing.Optional[typing.List[PlanDefinitionTarget]] = pydantic.Field(
        default=None
    )
    """
    Indicates what should be done and within what timeframe.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow", frozen=True
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
