# This file was auto-generated by Fern from our API Definition.

from __future__ import annotations
from ...core.pydantic_utilities import UniversalBaseModel
from .address import Address
from .age import Age
from .annotation import Annotation
from .attachment import Attachment
from .codeable_concept import CodeableConcept
from .coding import Coding
from .contact_detail import ContactDetail
from .contact_point import ContactPoint
from .contributor import Contributor
from .count import Count
from .data_requirement import DataRequirement
from .data_requirement_code_filter import DataRequirementCodeFilter
from .data_requirement_date_filter import DataRequirementDateFilter
from .data_requirement_sort import DataRequirementSort
from .distance import Distance
from .dosage import Dosage
from .dosage_dose_and_rate import DosageDoseAndRate
from .duration import Duration
from .expression import Expression
from .extension import Extension
from .human_name import HumanName
from .identifier import Identifier
from .meta import Meta
from .money import Money
from .parameter_definition import ParameterDefinition
from .period import Period
from .quantity import Quantity
from .range import Range
from .ratio import Ratio
from .reference import Reference
from .related_artifact import RelatedArtifact
from .sampled_data import SampledData
from .signature import Signature
from .timing import Timing
from .timing_repeat import TimingRepeat
from .trigger_definition import TriggerDefinition
from .usage_context import UsageContext
import typing
import pydantic
import typing_extensions
from ...core.serialization import FieldMetadata
from .code import Code
from .id import Id
from .plan_definition_condition import PlanDefinitionCondition
from .plan_definition_related_action import PlanDefinitionRelatedAction
from .plan_definition_participant import PlanDefinitionParticipant
from .plan_definition_action_grouping_behavior import (
    PlanDefinitionActionGroupingBehavior,
)
from .plan_definition_action_selection_behavior import (
    PlanDefinitionActionSelectionBehavior,
)
from .plan_definition_action_required_behavior import (
    PlanDefinitionActionRequiredBehavior,
)
from .plan_definition_action_precheck_behavior import (
    PlanDefinitionActionPrecheckBehavior,
)
from .plan_definition_action_cardinality_behavior import (
    PlanDefinitionActionCardinalityBehavior,
)
from .canonical import Canonical
from .plan_definition_dynamic_value import PlanDefinitionDynamicValue
from ...core.pydantic_utilities import IS_PYDANTIC_V2
from ...core.pydantic_utilities import update_forward_refs


class PlanDefinitionAction(UniversalBaseModel):
    """
    This resource allows for the definition of various types of plans as a sharable, consumable, and executable artifact. The resource is general enough to support the description of a broad range of clinical artifacts such as clinical decision support rules, order sets and protocols.
    """

    id: typing.Optional[str] = pydantic.Field(default=None)
    """
    Unique id for the element within a resource (for internal references). This may be any string value that does not contain spaces.
    """

    extension: typing.Optional[typing.List[Extension]] = pydantic.Field(default=None)
    """
    May be used to represent additional information that is not part of the basic definition of the element. To make the use of extensions safe and manageable, there is a strict set of governance applied to the definition and use of extensions. Though any implementer can define an extension, there is a set of requirements that SHALL be met as part of the definition of the extension.
    """

    modifier_extension: typing_extensions.Annotated[
        typing.Optional[typing.List[Extension]],
        FieldMetadata(alias="modifierExtension"),
    ] = pydantic.Field(default=None)
    """
    May be used to represent additional information that is not part of the basic definition of the element and that modifies the understanding of the element in which it is contained and/or the understanding of the containing element's descendants. Usually modifier elements provide negation or qualification. To make the use of extensions safe and manageable, there is a strict set of governance applied to the definition and use of extensions. Though any implementer can define an extension, there is a set of requirements that SHALL be met as part of the definition of the extension. Applications processing a resource are required to check for modifier extensions. Modifier extensions SHALL NOT change the meaning of any elements on Resource or DomainResource (including cannot change the meaning of modifierExtension itself).
    """

    prefix: typing.Optional[str] = pydantic.Field(default=None)
    """
    A user-visible prefix for the action.
    """

    title: typing.Optional[str] = pydantic.Field(default=None)
    """
    The title of the action displayed to a user.
    """

    description: typing.Optional[str] = pydantic.Field(default=None)
    """
    A brief description of the action used to provide a summary to display to the user.
    """

    text_equivalent: typing_extensions.Annotated[
        typing.Optional[str], FieldMetadata(alias="textEquivalent")
    ] = pydantic.Field(default=None)
    """
    A text equivalent of the action to be performed. This provides a human-interpretable description of the action when the definition is consumed by a system that might not be capable of interpreting it dynamically.
    """

    priority: typing.Optional[Code] = pydantic.Field(default=None)
    """
    Indicates how quickly the action should be addressed with respect to other actions.
    """

    code: typing.Optional[typing.List[CodeableConcept]] = pydantic.Field(default=None)
    """
    A code that provides meaning for the action or action group. For example, a section may have a LOINC code for the section of a documentation template.
    """

    reason: typing.Optional[typing.List[CodeableConcept]] = pydantic.Field(default=None)
    """
    A description of why this action is necessary or appropriate.
    """

    documentation: typing.Optional[typing.List[RelatedArtifact]] = pydantic.Field(
        default=None
    )
    """
    Didactic or other informational resources associated with the action that can be provided to the CDS recipient. Information resources can include inline text commentary and links to web resources.
    """

    goal_id: typing_extensions.Annotated[
        typing.Optional[typing.List[Id]], FieldMetadata(alias="goalId")
    ] = pydantic.Field(default=None)
    """
    Identifies goals that this action supports. The reference must be to a goal element defined within this plan definition.
    """

    subject_codeable_concept: typing_extensions.Annotated[
        typing.Optional[CodeableConcept], FieldMetadata(alias="subjectCodeableConcept")
    ] = pydantic.Field(default=None)
    """
    A code or group definition that describes the intended subject of the action and its children, if any.
    """

    subject_reference: typing_extensions.Annotated[
        typing.Optional[Reference], FieldMetadata(alias="subjectReference")
    ] = pydantic.Field(default=None)
    """
    A code or group definition that describes the intended subject of the action and its children, if any.
    """

    trigger: typing.Optional[typing.List[TriggerDefinition]] = pydantic.Field(
        default=None
    )
    """
    A description of when the action should be triggered.
    """

    condition: typing.Optional[typing.List[PlanDefinitionCondition]] = pydantic.Field(
        default=None
    )
    """
    An expression that describes applicability criteria or start/stop conditions for the action.
    """

    input: typing.Optional[typing.List[DataRequirement]] = pydantic.Field(default=None)
    """
    Defines input data requirements for the action.
    """

    output: typing.Optional[typing.List[DataRequirement]] = pydantic.Field(default=None)
    """
    Defines the outputs of the action, if any.
    """

    related_action: typing_extensions.Annotated[
        typing.Optional[typing.List[PlanDefinitionRelatedAction]],
        FieldMetadata(alias="relatedAction"),
    ] = pydantic.Field(default=None)
    """
    A relationship to another action such as "before" or "30-60 minutes after start of".
    """

    timing_date_time: typing_extensions.Annotated[
        typing.Optional[str], FieldMetadata(alias="timingDateTime")
    ] = pydantic.Field(default=None)
    """
    An optional value describing when the action should be performed.
    """

    timing_age: typing_extensions.Annotated[
        typing.Optional[Age], FieldMetadata(alias="timingAge")
    ] = pydantic.Field(default=None)
    """
    An optional value describing when the action should be performed.
    """

    timing_period: typing_extensions.Annotated[
        typing.Optional[Period], FieldMetadata(alias="timingPeriod")
    ] = pydantic.Field(default=None)
    """
    An optional value describing when the action should be performed.
    """

    timing_duration: typing_extensions.Annotated[
        typing.Optional[Duration], FieldMetadata(alias="timingDuration")
    ] = pydantic.Field(default=None)
    """
    An optional value describing when the action should be performed.
    """

    timing_range: typing_extensions.Annotated[
        typing.Optional[Range], FieldMetadata(alias="timingRange")
    ] = pydantic.Field(default=None)
    """
    An optional value describing when the action should be performed.
    """

    timing_timing: typing_extensions.Annotated[
        typing.Optional[Timing], FieldMetadata(alias="timingTiming")
    ] = pydantic.Field(default=None)
    """
    An optional value describing when the action should be performed.
    """

    participant: typing.Optional[typing.List[PlanDefinitionParticipant]] = (
        pydantic.Field(default=None)
    )
    """
    Indicates who should participate in performing the action described.
    """

    type: typing.Optional[CodeableConcept] = pydantic.Field(default=None)
    """
    The type of action to perform (create, update, remove).
    """

    grouping_behavior: typing_extensions.Annotated[
        typing.Optional[PlanDefinitionActionGroupingBehavior],
        FieldMetadata(alias="groupingBehavior"),
    ] = pydantic.Field(default=None)
    """
    Defines the grouping behavior for the action and its children.
    """

    selection_behavior: typing_extensions.Annotated[
        typing.Optional[PlanDefinitionActionSelectionBehavior],
        FieldMetadata(alias="selectionBehavior"),
    ] = pydantic.Field(default=None)
    """
    Defines the selection behavior for the action and its children.
    """

    required_behavior: typing_extensions.Annotated[
        typing.Optional[PlanDefinitionActionRequiredBehavior],
        FieldMetadata(alias="requiredBehavior"),
    ] = pydantic.Field(default=None)
    """
    Defines the required behavior for the action.
    """

    precheck_behavior: typing_extensions.Annotated[
        typing.Optional[PlanDefinitionActionPrecheckBehavior],
        FieldMetadata(alias="precheckBehavior"),
    ] = pydantic.Field(default=None)
    """
    Defines whether the action should usually be preselected.
    """

    cardinality_behavior: typing_extensions.Annotated[
        typing.Optional[PlanDefinitionActionCardinalityBehavior],
        FieldMetadata(alias="cardinalityBehavior"),
    ] = pydantic.Field(default=None)
    """
    Defines whether the action can be selected multiple times.
    """

    definition_canonical: typing_extensions.Annotated[
        typing.Optional[str], FieldMetadata(alias="definitionCanonical")
    ] = pydantic.Field(default=None)
    """
    A reference to an ActivityDefinition that describes the action to be taken in detail, or a PlanDefinition that describes a series of actions to be taken.
    """

    definition_uri: typing_extensions.Annotated[
        typing.Optional[str], FieldMetadata(alias="definitionUri")
    ] = pydantic.Field(default=None)
    """
    A reference to an ActivityDefinition that describes the action to be taken in detail, or a PlanDefinition that describes a series of actions to be taken.
    """

    transform: typing.Optional[Canonical] = pydantic.Field(default=None)
    """
    A reference to a StructureMap resource that defines a transform that can be executed to produce the intent resource using the ActivityDefinition instance as the input.
    """

    dynamic_value: typing_extensions.Annotated[
        typing.Optional[typing.List[PlanDefinitionDynamicValue]],
        FieldMetadata(alias="dynamicValue"),
    ] = pydantic.Field(default=None)
    """
    Customizations that should be applied to the statically defined resource. For example, if the dosage of a medication must be computed based on the patient's weight, a customization would be used to specify an expression that calculated the weight, and the path on the resource that would contain the result.
    """

    action: typing.Optional[typing.List["PlanDefinitionAction"]] = pydantic.Field(
        default=None
    )
    """
    Sub actions that are contained within the action. The behavior of this action determines the functionality of the sub-actions. For example, a selection behavior of at-most-one indicates that of the sub-actions, at most one may be chosen as part of realizing the action definition.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow", frozen=True
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


update_forward_refs(PlanDefinitionAction)
