# This file was auto-generated by Fern from our API Definition.

from .base_resource import BaseResource
from .address import Address
from .age import Age
from .annotation import Annotation
from .attachment import Attachment
from .codeable_concept import CodeableConcept
from .coding import Coding
from .contact_detail import ContactDetail
from .contact_point import ContactPoint
from .contributor import Contributor
from .count import Count
from .data_requirement import DataRequirement
from .data_requirement_code_filter import DataRequirementCodeFilter
from .data_requirement_date_filter import DataRequirementDateFilter
from .data_requirement_sort import DataRequirementSort
from .distance import Distance
from .dosage import Dosage
from .dosage_dose_and_rate import DosageDoseAndRate
from .duration import Duration
from .expression import Expression
from .extension import Extension
from .human_name import HumanName
from .identifier import Identifier
from .meta import Meta
from .money import Money
from .parameter_definition import ParameterDefinition
from .period import Period
from .quantity import Quantity
from .range import Range
from .ratio import Ratio
from .reference import Reference
from .related_artifact import RelatedArtifact
from .sampled_data import SampledData
from .signature import Signature
from .timing import Timing
from .timing_repeat import TimingRepeat
from .trigger_definition import TriggerDefinition
from .usage_context import UsageContext
import typing_extensions
import typing
from ...core.serialization import FieldMetadata
import pydantic
from .person_gender import PersonGender
import datetime as dt
from .person_link import PersonLink
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class Person(BaseResource):
    """
    Demographics and administrative information about a person independent of a specific health-related context.
    """

    resource_type: typing_extensions.Annotated[
        typing.Literal["Person"], FieldMetadata(alias="resourceType")
    ] = "Person"
    identifier: typing.Optional[typing.List[Identifier]] = pydantic.Field(default=None)
    """
    Identifier for a person within a particular scope.
    """

    name: typing.Optional[typing.List[HumanName]] = pydantic.Field(default=None)
    """
    A name associated with the person.
    """

    telecom: typing.Optional[typing.List[ContactPoint]] = pydantic.Field(default=None)
    """
    A contact detail for the person, e.g. a telephone number or an email address.
    """

    gender: typing.Optional[PersonGender] = pydantic.Field(default=None)
    """
    Administrative Gender.
    """

    birth_date: typing_extensions.Annotated[
        typing.Optional[dt.date], FieldMetadata(alias="birthDate")
    ] = pydantic.Field(default=None)
    """
    The birth date for the person.
    """

    address: typing.Optional[typing.List[Address]] = pydantic.Field(default=None)
    """
    One or more addresses for the person.
    """

    photo: typing.Optional[Attachment] = pydantic.Field(default=None)
    """
    An image that can be displayed as a thumbnail of the person to enhance the identification of the individual.
    """

    managing_organization: typing_extensions.Annotated[
        typing.Optional[Reference], FieldMetadata(alias="managingOrganization")
    ] = pydantic.Field(default=None)
    """
    The organization that is the custodian of the person record.
    """

    active: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Whether this person's record is in active use.
    """

    link: typing.Optional[typing.List[PersonLink]] = pydantic.Field(default=None)
    """
    Link to a resource that concerns the same actual person.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow", frozen=True
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
