# This file was auto-generated by Fern from our API Definition.

from .base_resource import BaseResource
from .address import Address
from .age import Age
from .annotation import Annotation
from .attachment import Attachment
from .codeable_concept import CodeableConcept
from .coding import Coding
from .contact_detail import ContactDetail
from .contact_point import ContactPoint
from .contributor import Contributor
from .count import Count
from .data_requirement import DataRequirement
from .data_requirement_code_filter import DataRequirementCodeFilter
from .data_requirement_date_filter import DataRequirementDateFilter
from .data_requirement_sort import DataRequirementSort
from .distance import Distance
from .dosage import Dosage
from .dosage_dose_and_rate import DosageDoseAndRate
from .duration import Duration
from .expression import Expression
from .extension import Extension
from .human_name import HumanName
from .identifier import Identifier
from .meta import Meta
from .money import Money
from .parameter_definition import ParameterDefinition
from .period import Period
from .quantity import Quantity
from .range import Range
from .ratio import Ratio
from .reference import Reference
from .related_artifact import RelatedArtifact
from .sampled_data import SampledData
from .signature import Signature
from .timing import Timing
from .timing_repeat import TimingRepeat
from .trigger_definition import TriggerDefinition
from .usage_context import UsageContext
import typing_extensions
import typing
from ...core.serialization import FieldMetadata
import pydantic
from .code import Code
from .date_time import DateTime
from .payment_reconciliation_outcome import PaymentReconciliationOutcome
import datetime as dt
from .payment_reconciliation_detail import PaymentReconciliationDetail
from .payment_reconciliation_process_note import PaymentReconciliationProcessNote
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class PaymentReconciliation(BaseResource):
    """
    This resource provides the details including amount of a payment and allocates the payment items being paid.
    """

    resource_type: typing_extensions.Annotated[
        typing.Literal["PaymentReconciliation"], FieldMetadata(alias="resourceType")
    ] = "PaymentReconciliation"
    identifier: typing.Optional[typing.List[Identifier]] = pydantic.Field(default=None)
    """
    A unique identifier assigned to this payment reconciliation.
    """

    status: typing.Optional[Code] = pydantic.Field(default=None)
    """
    The status of the resource instance.
    """

    period: typing.Optional[Period] = pydantic.Field(default=None)
    """
    The period of time for which payments have been gathered into this bulk payment for settlement.
    """

    created: typing.Optional[DateTime] = pydantic.Field(default=None)
    """
    The date when the resource was created.
    """

    payment_issuer: typing_extensions.Annotated[
        typing.Optional[Reference], FieldMetadata(alias="paymentIssuer")
    ] = pydantic.Field(default=None)
    """
    The party who generated the payment.
    """

    request: typing.Optional[Reference] = pydantic.Field(default=None)
    """
    Original request resource reference.
    """

    requestor: typing.Optional[Reference] = pydantic.Field(default=None)
    """
    The practitioner who is responsible for the services rendered to the patient.
    """

    outcome: typing.Optional[PaymentReconciliationOutcome] = pydantic.Field(
        default=None
    )
    """
    The outcome of a request for a reconciliation.
    """

    disposition: typing.Optional[str] = pydantic.Field(default=None)
    """
    A human readable description of the status of the request for the reconciliation.
    """

    payment_date: typing_extensions.Annotated[
        typing.Optional[dt.date], FieldMetadata(alias="paymentDate")
    ] = pydantic.Field(default=None)
    """
    The date of payment as indicated on the financial instrument.
    """

    payment_amount: typing_extensions.Annotated[
        Money, FieldMetadata(alias="paymentAmount")
    ] = pydantic.Field()
    """
    Total payment amount as indicated on the financial instrument.
    """

    payment_identifier: typing_extensions.Annotated[
        typing.Optional[Identifier], FieldMetadata(alias="paymentIdentifier")
    ] = pydantic.Field(default=None)
    """
    Issuer's unique identifier for the payment instrument.
    """

    detail: typing.Optional[typing.List[PaymentReconciliationDetail]] = pydantic.Field(
        default=None
    )
    """
    Distribution of the payment amount for a previously acknowledged payable.
    """

    form_code: typing_extensions.Annotated[
        typing.Optional[CodeableConcept], FieldMetadata(alias="formCode")
    ] = pydantic.Field(default=None)
    """
    A code for the form to be used for printing the content.
    """

    process_note: typing_extensions.Annotated[
        typing.Optional[typing.List[PaymentReconciliationProcessNote]],
        FieldMetadata(alias="processNote"),
    ] = pydantic.Field(default=None)
    """
    A note that describes or explains the processing in a human readable form.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow", frozen=True
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
