# This file was auto-generated by Fern from our API Definition.

from .base_resource import BaseResource
from .address import Address
from .age import Age
from .annotation import Annotation
from .attachment import Attachment
from .codeable_concept import CodeableConcept
from .coding import Coding
from .contact_detail import ContactDetail
from .contact_point import ContactPoint
from .contributor import Contributor
from .count import Count
from .data_requirement import DataRequirement
from .data_requirement_code_filter import DataRequirementCodeFilter
from .data_requirement_date_filter import DataRequirementDateFilter
from .data_requirement_sort import DataRequirementSort
from .distance import Distance
from .dosage import Dosage
from .dosage_dose_and_rate import DosageDoseAndRate
from .duration import Duration
from .expression import Expression
from .extension import Extension
from .human_name import HumanName
from .identifier import Identifier
from .meta import Meta
from .money import Money
from .parameter_definition import ParameterDefinition
from .period import Period
from .quantity import Quantity
from .range import Range
from .ratio import Ratio
from .reference import Reference
from .related_artifact import RelatedArtifact
from .sampled_data import SampledData
from .signature import Signature
from .timing import Timing
from .timing_repeat import TimingRepeat
from .trigger_definition import TriggerDefinition
from .usage_context import UsageContext
import typing_extensions
import typing
from ...core.serialization import FieldMetadata
import pydantic
from .code import Code
from .date_time import DateTime
import datetime as dt
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class PaymentNotice(BaseResource):
    """
    This resource provides the status of the payment for goods and services rendered, and the request and response resource references.
    """

    resource_type: typing_extensions.Annotated[
        typing.Literal["PaymentNotice"], FieldMetadata(alias="resourceType")
    ] = "PaymentNotice"
    identifier: typing.Optional[typing.List[Identifier]] = pydantic.Field(default=None)
    """
    A unique identifier assigned to this payment notice.
    """

    status: typing.Optional[Code] = pydantic.Field(default=None)
    """
    The status of the resource instance.
    """

    request: typing.Optional[Reference] = pydantic.Field(default=None)
    """
    Reference of resource for which payment is being made.
    """

    response: typing.Optional[Reference] = pydantic.Field(default=None)
    """
    Reference of response to resource for which payment is being made.
    """

    created: typing.Optional[DateTime] = pydantic.Field(default=None)
    """
    The date when this resource was created.
    """

    provider: typing.Optional[Reference] = pydantic.Field(default=None)
    """
    The practitioner who is responsible for the services rendered to the patient.
    """

    payment: Reference = pydantic.Field()
    """
    A reference to the payment which is the subject of this notice.
    """

    payment_date: typing_extensions.Annotated[
        typing.Optional[dt.date], FieldMetadata(alias="paymentDate")
    ] = pydantic.Field(default=None)
    """
    The date when the above payment action occurred.
    """

    payee: typing.Optional[Reference] = pydantic.Field(default=None)
    """
    The party who will receive or has received payment that is the subject of this notification.
    """

    recipient: Reference = pydantic.Field()
    """
    The party who is notified of the payment status.
    """

    amount: Money = pydantic.Field()
    """
    The amount sent to the payee.
    """

    payment_status: typing_extensions.Annotated[
        typing.Optional[CodeableConcept], FieldMetadata(alias="paymentStatus")
    ] = pydantic.Field(default=None)
    """
    A code indicating whether payment has been sent or cleared.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow", frozen=True
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
