# This file was auto-generated by Fern from our API Definition.

from .base_resource import BaseResource
from .address import Address
from .age import Age
from .annotation import Annotation
from .attachment import Attachment
from .codeable_concept import CodeableConcept
from .coding import Coding
from .contact_detail import ContactDetail
from .contact_point import ContactPoint
from .contributor import Contributor
from .count import Count
from .data_requirement import DataRequirement
from .data_requirement_code_filter import DataRequirementCodeFilter
from .data_requirement_date_filter import DataRequirementDateFilter
from .data_requirement_sort import DataRequirementSort
from .distance import Distance
from .dosage import Dosage
from .dosage_dose_and_rate import DosageDoseAndRate
from .duration import Duration
from .expression import Expression
from .extension import Extension
from .human_name import HumanName
from .identifier import Identifier
from .meta import Meta
from .money import Money
from .parameter_definition import ParameterDefinition
from .period import Period
from .quantity import Quantity
from .range import Range
from .ratio import Ratio
from .reference import Reference
from .related_artifact import RelatedArtifact
from .sampled_data import SampledData
from .signature import Signature
from .timing import Timing
from .timing_repeat import TimingRepeat
from .trigger_definition import TriggerDefinition
from .usage_context import UsageContext
import typing_extensions
import typing
from ...core.serialization import FieldMetadata
import pydantic
from .patient_gender import PatientGender
import datetime as dt
from .patient_contact import PatientContact
from .patient_communication import PatientCommunication
from .patient_link import PatientLink
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class Patient(BaseResource):
    """
    Demographics and other administrative information about an individual or animal receiving care or other health-related services.
    """

    resource_type: typing_extensions.Annotated[
        typing.Literal["Patient"], FieldMetadata(alias="resourceType")
    ] = "Patient"
    identifier: typing.Optional[typing.List[Identifier]] = pydantic.Field(default=None)
    """
    An identifier for this patient.
    """

    active: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Whether this patient record is in active use. Many systems use this property to mark as non-current patients, such as those that have not been seen for a period of time based on an organization's business rules. It is often used to filter patient lists to exclude inactive patients Deceased patients may also be marked as inactive for the same reasons, but may be active for some time after death.
    """

    name: typing.Optional[typing.List[HumanName]] = pydantic.Field(default=None)
    """
    A name associated with the individual.
    """

    telecom: typing.Optional[typing.List[ContactPoint]] = pydantic.Field(default=None)
    """
    A contact detail (e.g. a telephone number or an email address) by which the individual may be contacted.
    """

    gender: typing.Optional[PatientGender] = pydantic.Field(default=None)
    """
    Administrative Gender - the gender that the patient is considered to have for administration and record keeping purposes.
    """

    birth_date: typing_extensions.Annotated[
        typing.Optional[dt.date], FieldMetadata(alias="birthDate")
    ] = pydantic.Field(default=None)
    """
    The date of birth for the individual.
    """

    deceased_boolean: typing_extensions.Annotated[
        typing.Optional[bool], FieldMetadata(alias="deceasedBoolean")
    ] = pydantic.Field(default=None)
    """
    Indicates if the individual is deceased or not.
    """

    deceased_date_time: typing_extensions.Annotated[
        typing.Optional[str], FieldMetadata(alias="deceasedDateTime")
    ] = pydantic.Field(default=None)
    """
    Indicates if the individual is deceased or not.
    """

    address: typing.Optional[typing.List[Address]] = pydantic.Field(default=None)
    """
    An address for the individual.
    """

    marital_status: typing_extensions.Annotated[
        typing.Optional[CodeableConcept], FieldMetadata(alias="maritalStatus")
    ] = pydantic.Field(default=None)
    """
    This field contains a patient's most recent marital (civil) status.
    """

    multiple_birth_boolean: typing_extensions.Annotated[
        typing.Optional[bool], FieldMetadata(alias="multipleBirthBoolean")
    ] = pydantic.Field(default=None)
    """
    Indicates whether the patient is part of a multiple (boolean) or indicates the actual birth order (integer).
    """

    multiple_birth_integer: typing_extensions.Annotated[
        typing.Optional[float], FieldMetadata(alias="multipleBirthInteger")
    ] = pydantic.Field(default=None)
    """
    Indicates whether the patient is part of a multiple (boolean) or indicates the actual birth order (integer).
    """

    photo: typing.Optional[typing.List[Attachment]] = pydantic.Field(default=None)
    """
    Image of the patient.
    """

    contact: typing.Optional[typing.List[PatientContact]] = pydantic.Field(default=None)
    """
    A contact party (e.g. guardian, partner, friend) for the patient.
    """

    communication: typing.Optional[typing.List[PatientCommunication]] = pydantic.Field(
        default=None
    )
    """
    A language which may be used to communicate with the patient about his or her health.
    """

    general_practitioner: typing_extensions.Annotated[
        typing.Optional[typing.List[Reference]],
        FieldMetadata(alias="generalPractitioner"),
    ] = pydantic.Field(default=None)
    """
    Patient's nominated care provider.
    """

    managing_organization: typing_extensions.Annotated[
        typing.Optional[Reference], FieldMetadata(alias="managingOrganization")
    ] = pydantic.Field(default=None)
    """
    Organization that is the custodian of the patient record.
    """

    link: typing.Optional[typing.List[PatientLink]] = pydantic.Field(default=None)
    """
    Link to another patient resource that concerns the same actual patient.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow", frozen=True
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
