# This file was auto-generated by Fern from our API Definition.

from .base_resource import BaseResource
from .address import Address
from .age import Age
from .annotation import Annotation
from .attachment import Attachment
from .codeable_concept import CodeableConcept
from .coding import Coding
from .contact_detail import ContactDetail
from .contact_point import ContactPoint
from .contributor import Contributor
from .count import Count
from .data_requirement import DataRequirement
from .data_requirement_code_filter import DataRequirementCodeFilter
from .data_requirement_date_filter import DataRequirementDateFilter
from .data_requirement_sort import DataRequirementSort
from .distance import Distance
from .dosage import Dosage
from .dosage_dose_and_rate import DosageDoseAndRate
from .duration import Duration
from .expression import Expression
from .extension import Extension
from .human_name import HumanName
from .identifier import Identifier
from .meta import Meta
from .money import Money
from .parameter_definition import ParameterDefinition
from .period import Period
from .quantity import Quantity
from .range import Range
from .ratio import Ratio
from .reference import Reference
from .related_artifact import RelatedArtifact
from .sampled_data import SampledData
from .signature import Signature
from .timing import Timing
from .timing_repeat import TimingRepeat
from .trigger_definition import TriggerDefinition
from .usage_context import UsageContext
import typing_extensions
import typing
from ...core.serialization import FieldMetadata
import pydantic
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class OrganizationAffiliation(BaseResource):
    """
    Defines an affiliation/assotiation/relationship between 2 distinct oganizations, that is not a part-of relationship/sub-division relationship.
    """

    resource_type: typing_extensions.Annotated[
        typing.Literal["OrganizationAffiliation"], FieldMetadata(alias="resourceType")
    ] = "OrganizationAffiliation"
    identifier: typing.Optional[typing.List[Identifier]] = pydantic.Field(default=None)
    """
    Business identifiers that are specific to this role.
    """

    active: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Whether this organization affiliation record is in active use.
    """

    period: typing.Optional[Period] = pydantic.Field(default=None)
    """
    The period during which the participatingOrganization is affiliated with the primary organization.
    """

    organization: typing.Optional[Reference] = pydantic.Field(default=None)
    """
    Organization where the role is available (primary organization/has members).
    """

    participating_organization: typing_extensions.Annotated[
        typing.Optional[Reference], FieldMetadata(alias="participatingOrganization")
    ] = pydantic.Field(default=None)
    """
    The Participating Organization provides/performs the role(s) defined by the code to the Primary Organization (e.g. providing services or is a member of).
    """

    network: typing.Optional[typing.List[Reference]] = pydantic.Field(default=None)
    """
    Health insurance provider network in which the participatingOrganization provides the role's services (if defined) at the indicated locations (if defined).
    """

    code: typing.Optional[typing.List[CodeableConcept]] = pydantic.Field(default=None)
    """
    Definition of the role the participatingOrganization plays in the association.
    """

    specialty: typing.Optional[typing.List[CodeableConcept]] = pydantic.Field(
        default=None
    )
    """
    Specific specialty of the participatingOrganization in the context of the role.
    """

    location: typing.Optional[typing.List[Reference]] = pydantic.Field(default=None)
    """
    The location(s) at which the role occurs.
    """

    healthcare_service: typing_extensions.Annotated[
        typing.Optional[typing.List[Reference]],
        FieldMetadata(alias="healthcareService"),
    ] = pydantic.Field(default=None)
    """
    Healthcare services provided through the role.
    """

    telecom: typing.Optional[typing.List[ContactPoint]] = pydantic.Field(default=None)
    """
    Contact details at the participatingOrganization relevant to this Affiliation.
    """

    endpoint: typing.Optional[typing.List[Reference]] = pydantic.Field(default=None)
    """
    Technical endpoints providing access to services operated for this role.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow", frozen=True
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
