# This file was auto-generated by Fern from our API Definition.

from .base_resource import BaseResource
from .address import Address
from .age import Age
from .annotation import Annotation
from .attachment import Attachment
from .codeable_concept import CodeableConcept
from .coding import Coding
from .contact_detail import ContactDetail
from .contact_point import ContactPoint
from .contributor import Contributor
from .count import Count
from .data_requirement import DataRequirement
from .data_requirement_code_filter import DataRequirementCodeFilter
from .data_requirement_date_filter import DataRequirementDateFilter
from .data_requirement_sort import DataRequirementSort
from .distance import Distance
from .dosage import Dosage
from .dosage_dose_and_rate import DosageDoseAndRate
from .duration import Duration
from .expression import Expression
from .extension import Extension
from .human_name import HumanName
from .identifier import Identifier
from .meta import Meta
from .money import Money
from .parameter_definition import ParameterDefinition
from .period import Period
from .quantity import Quantity
from .range import Range
from .ratio import Ratio
from .reference import Reference
from .related_artifact import RelatedArtifact
from .sampled_data import SampledData
from .signature import Signature
from .timing import Timing
from .timing_repeat import TimingRepeat
from .trigger_definition import TriggerDefinition
from .usage_context import UsageContext
import typing_extensions
import typing
from ...core.serialization import FieldMetadata
import pydantic
from .organization_contact import OrganizationContact
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class Organization(BaseResource):
    """
    A formally or informally recognized grouping of people or organizations formed for the purpose of achieving some form of collective action. Includes companies, institutions, corporations, departments, community groups, healthcare practice groups, payer/insurer, etc.
    """

    resource_type: typing_extensions.Annotated[
        typing.Literal["Organization"], FieldMetadata(alias="resourceType")
    ] = "Organization"
    identifier: typing.Optional[typing.List[Identifier]] = pydantic.Field(default=None)
    """
    Identifier for the organization that is used to identify the organization across multiple disparate systems.
    """

    active: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Whether the organization's record is still in active use.
    """

    type: typing.Optional[typing.List[CodeableConcept]] = pydantic.Field(default=None)
    """
    The kind(s) of organization that this is.
    """

    name: typing.Optional[str] = pydantic.Field(default=None)
    """
    A name associated with the organization.
    """

    alias: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    A list of alternate names that the organization is known as, or was known as in the past.
    """

    telecom: typing.Optional[typing.List[ContactPoint]] = pydantic.Field(default=None)
    """
    A contact detail for the organization.
    """

    address: typing.Optional[typing.List[Address]] = pydantic.Field(default=None)
    """
    An address for the organization.
    """

    part_of: typing_extensions.Annotated[
        typing.Optional[Reference], FieldMetadata(alias="partOf")
    ] = pydantic.Field(default=None)
    """
    The organization of which this organization forms a part.
    """

    contact: typing.Optional[typing.List[OrganizationContact]] = pydantic.Field(
        default=None
    )
    """
    Contact for the organization for a certain purpose.
    """

    endpoint: typing.Optional[typing.List[Reference]] = pydantic.Field(default=None)
    """
    Technical endpoints providing access to services operated for the organization.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow", frozen=True
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
