# This file was auto-generated by Fern from our API Definition.

from __future__ import annotations
from ...core.pydantic_utilities import UniversalBaseModel
from .address import Address
from .age import Age
from .annotation import Annotation
from .attachment import Attachment
from .codeable_concept import CodeableConcept
from .coding import Coding
from .contact_detail import ContactDetail
from .contact_point import ContactPoint
from .contributor import Contributor
from .count import Count
from .data_requirement import DataRequirement
from .data_requirement_code_filter import DataRequirementCodeFilter
from .data_requirement_date_filter import DataRequirementDateFilter
from .data_requirement_sort import DataRequirementSort
from .distance import Distance
from .dosage import Dosage
from .dosage_dose_and_rate import DosageDoseAndRate
from .duration import Duration
from .expression import Expression
from .extension import Extension
from .human_name import HumanName
from .identifier import Identifier
from .meta import Meta
from .money import Money
from .parameter_definition import ParameterDefinition
from .period import Period
from .quantity import Quantity
from .range import Range
from .ratio import Ratio
from .reference import Reference
from .related_artifact import RelatedArtifact
from .sampled_data import SampledData
from .signature import Signature
from .timing import Timing
from .timing_repeat import TimingRepeat
from .trigger_definition import TriggerDefinition
from .usage_context import UsageContext
import typing
import pydantic
import typing_extensions
from ...core.serialization import FieldMetadata
from .code import Code
from .operation_definition_parameter_use import OperationDefinitionParameterUse
from .canonical import Canonical
from .operation_definition_parameter_search_type import (
    OperationDefinitionParameterSearchType,
)
from .operation_definition_binding import OperationDefinitionBinding
from .operation_definition_referenced_from import OperationDefinitionReferencedFrom
from ...core.pydantic_utilities import IS_PYDANTIC_V2
from ...core.pydantic_utilities import update_forward_refs


class OperationDefinitionParameter(UniversalBaseModel):
    """
    A formal computable definition of an operation (on the RESTful interface) or a named query (using the search interaction).
    """

    id: typing.Optional[str] = pydantic.Field(default=None)
    """
    Unique id for the element within a resource (for internal references). This may be any string value that does not contain spaces.
    """

    extension: typing.Optional[typing.List[Extension]] = pydantic.Field(default=None)
    """
    May be used to represent additional information that is not part of the basic definition of the element. To make the use of extensions safe and manageable, there is a strict set of governance applied to the definition and use of extensions. Though any implementer can define an extension, there is a set of requirements that SHALL be met as part of the definition of the extension.
    """

    modifier_extension: typing_extensions.Annotated[
        typing.Optional[typing.List[Extension]],
        FieldMetadata(alias="modifierExtension"),
    ] = pydantic.Field(default=None)
    """
    May be used to represent additional information that is not part of the basic definition of the element and that modifies the understanding of the element in which it is contained and/or the understanding of the containing element's descendants. Usually modifier elements provide negation or qualification. To make the use of extensions safe and manageable, there is a strict set of governance applied to the definition and use of extensions. Though any implementer can define an extension, there is a set of requirements that SHALL be met as part of the definition of the extension. Applications processing a resource are required to check for modifier extensions. Modifier extensions SHALL NOT change the meaning of any elements on Resource or DomainResource (including cannot change the meaning of modifierExtension itself).
    """

    name: typing.Optional[Code] = pydantic.Field(default=None)
    """
    The name of used to identify the parameter.
    """

    use: typing.Optional[OperationDefinitionParameterUse] = pydantic.Field(default=None)
    """
    Whether this is an input or an output parameter.
    """

    min: typing.Optional[int] = pydantic.Field(default=None)
    """
    The minimum number of times this parameter SHALL appear in the request or response.
    """

    max: typing.Optional[str] = pydantic.Field(default=None)
    """
    The maximum number of times this element is permitted to appear in the request or response.
    """

    documentation: typing.Optional[str] = pydantic.Field(default=None)
    """
    Describes the meaning or use of this parameter.
    """

    type: typing.Optional[Code] = pydantic.Field(default=None)
    """
    The type for this parameter.
    """

    target_profile: typing_extensions.Annotated[
        typing.Optional[typing.List[Canonical]], FieldMetadata(alias="targetProfile")
    ] = pydantic.Field(default=None)
    """
    Used when the type is "Reference" or "canonical", and identifies a profile structure or implementation Guide that applies to the target of the reference this parameter refers to. If any profiles are specified, then the content must conform to at least one of them. The URL can be a local reference - to a contained StructureDefinition, or a reference to another StructureDefinition or Implementation Guide by a canonical URL. When an implementation guide is specified, the target resource SHALL conform to at least one profile defined in the implementation guide.
    """

    search_type: typing_extensions.Annotated[
        typing.Optional[OperationDefinitionParameterSearchType],
        FieldMetadata(alias="searchType"),
    ] = pydantic.Field(default=None)
    """
    How the parameter is understood as a search parameter. This is only used if the parameter type is 'string'.
    """

    binding: typing.Optional[OperationDefinitionBinding] = pydantic.Field(default=None)
    """
    Binds to a value set if this parameter is coded (code, Coding, CodeableConcept).
    """

    referenced_from: typing_extensions.Annotated[
        typing.Optional[typing.List[OperationDefinitionReferencedFrom]],
        FieldMetadata(alias="referencedFrom"),
    ] = pydantic.Field(default=None)
    """
    Identifies other resource parameters within the operation invocation that are expected to resolve to this resource.
    """

    part: typing.Optional[typing.List["OperationDefinitionParameter"]] = pydantic.Field(
        default=None
    )
    """
    The parts of a nested Parameter.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow", frozen=True
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


update_forward_refs(OperationDefinitionParameter)
