# This file was auto-generated by Fern from our API Definition.

from .base_resource import BaseResource
from .address import Address
from .age import Age
from .annotation import Annotation
from .attachment import Attachment
from .codeable_concept import CodeableConcept
from .coding import Coding
from .contact_detail import ContactDetail
from .contact_point import ContactPoint
from .contributor import Contributor
from .count import Count
from .data_requirement import DataRequirement
from .data_requirement_code_filter import DataRequirementCodeFilter
from .data_requirement_date_filter import DataRequirementDateFilter
from .data_requirement_sort import DataRequirementSort
from .distance import Distance
from .dosage import Dosage
from .dosage_dose_and_rate import DosageDoseAndRate
from .duration import Duration
from .expression import Expression
from .extension import Extension
from .human_name import HumanName
from .identifier import Identifier
from .meta import Meta
from .money import Money
from .parameter_definition import ParameterDefinition
from .period import Period
from .quantity import Quantity
from .range import Range
from .ratio import Ratio
from .reference import Reference
from .related_artifact import RelatedArtifact
from .sampled_data import SampledData
from .signature import Signature
from .timing import Timing
from .timing_repeat import TimingRepeat
from .trigger_definition import TriggerDefinition
from .usage_context import UsageContext
from .operation_definition_parameter import OperationDefinitionParameter
import typing_extensions
import typing
from ...core.serialization import FieldMetadata
from .uri import Uri
import pydantic
from .operation_definition_status import OperationDefinitionStatus
from .operation_definition_kind import OperationDefinitionKind
from .date_time import DateTime
from .markdown import Markdown
from .code import Code
from .canonical import Canonical
from .operation_definition_overload import OperationDefinitionOverload
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class OperationDefinition(BaseResource):
    """
    A formal computable definition of an operation (on the RESTful interface) or a named query (using the search interaction).
    """

    resource_type: typing_extensions.Annotated[
        typing.Literal["OperationDefinition"], FieldMetadata(alias="resourceType")
    ] = "OperationDefinition"
    url: typing.Optional[Uri] = pydantic.Field(default=None)
    """
    An absolute URI that is used to identify this operation definition when it is referenced in a specification, model, design or an instance; also called its canonical identifier. This SHOULD be globally unique and SHOULD be a literal address at which at which an authoritative instance of this operation definition is (or will be) published. This URL can be the target of a canonical reference. It SHALL remain the same when the operation definition is stored on different servers.
    """

    version: typing.Optional[str] = pydantic.Field(default=None)
    """
    The identifier that is used to identify this version of the operation definition when it is referenced in a specification, model, design or instance. This is an arbitrary value managed by the operation definition author and is not expected to be globally unique. For example, it might be a timestamp (e.g. yyyymmdd) if a managed version is not available. There is also no expectation that versions can be placed in a lexicographical sequence.
    """

    name: typing.Optional[str] = pydantic.Field(default=None)
    """
    A natural language name identifying the operation definition. This name should be usable as an identifier for the module by machine processing applications such as code generation.
    """

    title: typing.Optional[str] = pydantic.Field(default=None)
    """
    A short, descriptive, user-friendly title for the operation definition.
    """

    status: typing.Optional[OperationDefinitionStatus] = pydantic.Field(default=None)
    """
    The status of this operation definition. Enables tracking the life-cycle of the content.
    """

    kind: typing.Optional[OperationDefinitionKind] = pydantic.Field(default=None)
    """
    Whether this is an operation or a named query.
    """

    experimental: typing.Optional[bool] = pydantic.Field(default=None)
    """
    A Boolean value to indicate that this operation definition is authored for testing purposes (or education/evaluation/marketing) and is not intended to be used for genuine usage.
    """

    date: typing.Optional[DateTime] = pydantic.Field(default=None)
    """
    The date (and optionally time) when the operation definition was published. The date must change when the business version changes and it must change if the status code changes. In addition, it should change when the substantive content of the operation definition changes.
    """

    publisher: typing.Optional[str] = pydantic.Field(default=None)
    """
    The name of the organization or individual that published the operation definition.
    """

    contact: typing.Optional[typing.List[ContactDetail]] = pydantic.Field(default=None)
    """
    Contact details to assist a user in finding and communicating with the publisher.
    """

    description: typing.Optional[Markdown] = pydantic.Field(default=None)
    """
    A free text natural language description of the operation definition from a consumer's perspective.
    """

    use_context: typing_extensions.Annotated[
        typing.Optional[typing.List[UsageContext]], FieldMetadata(alias="useContext")
    ] = pydantic.Field(default=None)
    """
    The content was developed with a focus and intent of supporting the contexts that are listed. These contexts may be general categories (gender, age, ...) or may be references to specific programs (insurance plans, studies, ...) and may be used to assist with indexing and searching for appropriate operation definition instances.
    """

    jurisdiction: typing.Optional[typing.List[CodeableConcept]] = pydantic.Field(
        default=None
    )
    """
    A legal or geographic region in which the operation definition is intended to be used.
    """

    purpose: typing.Optional[Markdown] = pydantic.Field(default=None)
    """
    Explanation of why this operation definition is needed and why it has been designed as it has.
    """

    affects_state: typing_extensions.Annotated[
        typing.Optional[bool], FieldMetadata(alias="affectsState")
    ] = pydantic.Field(default=None)
    """
    Whether the operation affects state. Side effects such as producing audit trail entries do not count as 'affecting state'.
    """

    code: typing.Optional[Code] = pydantic.Field(default=None)
    """
    The name used to invoke the operation.
    """

    comment: typing.Optional[Markdown] = pydantic.Field(default=None)
    """
    Additional information about how to use this operation or named query.
    """

    base: typing.Optional[Canonical] = pydantic.Field(default=None)
    """
    Indicates that this operation definition is a constraining profile on the base.
    """

    resource: typing.Optional[typing.List[Code]] = pydantic.Field(default=None)
    """
    The types on which this operation can be executed.
    """

    system: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Indicates whether this operation or named query can be invoked at the system level (e.g. without needing to choose a resource type for the context).
    """

    type: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Indicates whether this operation or named query can be invoked at the resource type level for any given resource type level (e.g. without needing to choose a specific resource id for the context).
    """

    instance: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Indicates whether this operation can be invoked on a particular instance of one of the given types.
    """

    input_profile: typing_extensions.Annotated[
        typing.Optional[Canonical], FieldMetadata(alias="inputProfile")
    ] = pydantic.Field(default=None)
    """
    Additional validation information for the in parameters - a single profile that covers all the parameters. The profile is a constraint on the parameters resource as a whole.
    """

    output_profile: typing_extensions.Annotated[
        typing.Optional[Canonical], FieldMetadata(alias="outputProfile")
    ] = pydantic.Field(default=None)
    """
    Additional validation information for the out parameters - a single profile that covers all the parameters. The profile is a constraint on the parameters resource.
    """

    parameter: typing.Optional[typing.List[OperationDefinitionParameter]] = (
        pydantic.Field(default=None)
    )
    """
    The parameters for the operation/query.
    """

    overload: typing.Optional[typing.List[OperationDefinitionOverload]] = (
        pydantic.Field(default=None)
    )
    """
    Defines an appropriate combination of parameters to use when invoking this operation, to help code generators when generating overloaded parameter sets for this operation.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow", frozen=True
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
