# This file was auto-generated by Fern from our API Definition.

from .base_resource import BaseResource
from .address import Address
from .age import Age
from .annotation import Annotation
from .attachment import Attachment
from .codeable_concept import CodeableConcept
from .coding import Coding
from .contact_detail import ContactDetail
from .contact_point import ContactPoint
from .contributor import Contributor
from .count import Count
from .data_requirement import DataRequirement
from .data_requirement_code_filter import DataRequirementCodeFilter
from .data_requirement_date_filter import DataRequirementDateFilter
from .data_requirement_sort import DataRequirementSort
from .distance import Distance
from .dosage import Dosage
from .dosage_dose_and_rate import DosageDoseAndRate
from .duration import Duration
from .expression import Expression
from .extension import Extension
from .human_name import HumanName
from .identifier import Identifier
from .meta import Meta
from .money import Money
from .parameter_definition import ParameterDefinition
from .period import Period
from .quantity import Quantity
from .range import Range
from .ratio import Ratio
from .reference import Reference
from .related_artifact import RelatedArtifact
from .sampled_data import SampledData
from .signature import Signature
from .timing import Timing
from .timing_repeat import TimingRepeat
from .trigger_definition import TriggerDefinition
from .usage_context import UsageContext
import typing_extensions
import typing
from ...core.serialization import FieldMetadata
import pydantic
from .observation_definition_permitted_data_type_item import (
    ObservationDefinitionPermittedDataTypeItem,
)
from .observation_definition_quantitative_details import (
    ObservationDefinitionQuantitativeDetails,
)
from .observation_definition_qualified_interval import (
    ObservationDefinitionQualifiedInterval,
)
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class ObservationDefinition(BaseResource):
    """
    Set of definitional characteristics for a kind of observation or measurement produced or consumed by an orderable health care service.
    """

    resource_type: typing_extensions.Annotated[
        typing.Literal["ObservationDefinition"], FieldMetadata(alias="resourceType")
    ] = "ObservationDefinition"
    publisher: typing.Optional[Reference] = pydantic.Field(default=None)
    """
    The name of the individual or organization that published the ObservationDefinition.
    """

    category: typing.Optional[typing.List[CodeableConcept]] = pydantic.Field(
        default=None
    )
    """
    A code that classifies the general type of observation.
    """

    code: CodeableConcept = pydantic.Field()
    """
    Describes what will be observed. Sometimes this is called the observation "name".
    """

    identifier: typing.Optional[typing.List[Identifier]] = pydantic.Field(default=None)
    """
    A unique identifier assigned to this ObservationDefinition artifact.
    """

    permitted_data_type: typing_extensions.Annotated[
        typing.Optional[typing.List[ObservationDefinitionPermittedDataTypeItem]],
        FieldMetadata(alias="permittedDataType"),
    ] = pydantic.Field(default=None)
    """
    The data types allowed for the value element of the instance observations conforming to this ObservationDefinition.
    """

    multiple_results_allowed: typing_extensions.Annotated[
        typing.Optional[bool], FieldMetadata(alias="multipleResultsAllowed")
    ] = pydantic.Field(default=None)
    """
    Multiple results allowed for observations conforming to this ObservationDefinition.
    """

    method: typing.Optional[CodeableConcept] = pydantic.Field(default=None)
    """
    The method or technique used to perform the observation.
    """

    preferred_report_name: typing_extensions.Annotated[
        typing.Optional[str], FieldMetadata(alias="preferredReportName")
    ] = pydantic.Field(default=None)
    """
    The preferred name to be used when reporting the results of observations conforming to this ObservationDefinition.
    """

    quantitative_details: typing_extensions.Annotated[
        typing.Optional[ObservationDefinitionQuantitativeDetails],
        FieldMetadata(alias="quantitativeDetails"),
    ] = pydantic.Field(default=None)
    """
    Characteristics for quantitative results of this observation.
    """

    qualified_interval: typing_extensions.Annotated[
        typing.Optional[typing.List[ObservationDefinitionQualifiedInterval]],
        FieldMetadata(alias="qualifiedInterval"),
    ] = pydantic.Field(default=None)
    """
    Multiple ranges of results qualified by different contexts for ordinal or continuous observations conforming to this ObservationDefinition.
    """

    valid_coded_value_set: typing_extensions.Annotated[
        typing.Optional[Reference], FieldMetadata(alias="validCodedValueSet")
    ] = pydantic.Field(default=None)
    """
    The set of valid coded results for the observations conforming to this ObservationDefinition.
    """

    normal_coded_value_set: typing_extensions.Annotated[
        typing.Optional[Reference], FieldMetadata(alias="normalCodedValueSet")
    ] = pydantic.Field(default=None)
    """
    The set of normal coded results for the observations conforming to this ObservationDefinition.
    """

    abnormal_coded_value_set: typing_extensions.Annotated[
        typing.Optional[Reference], FieldMetadata(alias="abnormalCodedValueSet")
    ] = pydantic.Field(default=None)
    """
    The set of abnormal coded results for the observation conforming to this ObservationDefinition.
    """

    critical_coded_value_set: typing_extensions.Annotated[
        typing.Optional[Reference], FieldMetadata(alias="criticalCodedValueSet")
    ] = pydantic.Field(default=None)
    """
    The set of critical coded results for the observation conforming to this ObservationDefinition.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow", frozen=True
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
