# This file was auto-generated by Fern from our API Definition.

from ...core.pydantic_utilities import UniversalBaseModel
from .address import Address
from .age import Age
from .annotation import Annotation
from .attachment import Attachment
from .codeable_concept import CodeableConcept
from .coding import Coding
from .contact_detail import ContactDetail
from .contact_point import ContactPoint
from .contributor import Contributor
from .count import Count
from .data_requirement import DataRequirement
from .data_requirement_code_filter import DataRequirementCodeFilter
from .data_requirement_date_filter import DataRequirementDateFilter
from .data_requirement_sort import DataRequirementSort
from .distance import Distance
from .dosage import Dosage
from .dosage_dose_and_rate import DosageDoseAndRate
from .duration import Duration
from .expression import Expression
from .extension import Extension
from .human_name import HumanName
from .identifier import Identifier
from .meta import Meta
from .money import Money
from .parameter_definition import ParameterDefinition
from .period import Period
from .quantity import Quantity
from .range import Range
from .ratio import Ratio
from .reference import Reference
from .related_artifact import RelatedArtifact
from .sampled_data import SampledData
from .signature import Signature
from .timing import Timing
from .timing_repeat import TimingRepeat
from .trigger_definition import TriggerDefinition
from .usage_context import UsageContext
import typing
import pydantic
import typing_extensions
from ...core.serialization import FieldMetadata
from .observation_reference_range import ObservationReferenceRange
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class ObservationComponent(UniversalBaseModel):
    """
    Measurements and simple assertions made about a patient, device or other subject.
    """

    id: typing.Optional[str] = pydantic.Field(default=None)
    """
    Unique id for the element within a resource (for internal references). This may be any string value that does not contain spaces.
    """

    extension: typing.Optional[typing.List[Extension]] = pydantic.Field(default=None)
    """
    May be used to represent additional information that is not part of the basic definition of the element. To make the use of extensions safe and manageable, there is a strict set of governance applied to the definition and use of extensions. Though any implementer can define an extension, there is a set of requirements that SHALL be met as part of the definition of the extension.
    """

    modifier_extension: typing_extensions.Annotated[
        typing.Optional[typing.List[Extension]],
        FieldMetadata(alias="modifierExtension"),
    ] = pydantic.Field(default=None)
    """
    May be used to represent additional information that is not part of the basic definition of the element and that modifies the understanding of the element in which it is contained and/or the understanding of the containing element's descendants. Usually modifier elements provide negation or qualification. To make the use of extensions safe and manageable, there is a strict set of governance applied to the definition and use of extensions. Though any implementer can define an extension, there is a set of requirements that SHALL be met as part of the definition of the extension. Applications processing a resource are required to check for modifier extensions. Modifier extensions SHALL NOT change the meaning of any elements on Resource or DomainResource (including cannot change the meaning of modifierExtension itself).
    """

    code: CodeableConcept = pydantic.Field()
    """
    Describes what was observed. Sometimes this is called the observation "code".
    """

    value_quantity: typing_extensions.Annotated[
        typing.Optional[Quantity], FieldMetadata(alias="valueQuantity")
    ] = pydantic.Field(default=None)
    """
    The information determined as a result of making the observation, if the information has a simple value.
    """

    value_codeable_concept: typing_extensions.Annotated[
        typing.Optional[CodeableConcept], FieldMetadata(alias="valueCodeableConcept")
    ] = pydantic.Field(default=None)
    """
    The information determined as a result of making the observation, if the information has a simple value.
    """

    value_string: typing_extensions.Annotated[
        typing.Optional[str], FieldMetadata(alias="valueString")
    ] = pydantic.Field(default=None)
    """
    The information determined as a result of making the observation, if the information has a simple value.
    """

    value_boolean: typing_extensions.Annotated[
        typing.Optional[bool], FieldMetadata(alias="valueBoolean")
    ] = pydantic.Field(default=None)
    """
    The information determined as a result of making the observation, if the information has a simple value.
    """

    value_integer: typing_extensions.Annotated[
        typing.Optional[float], FieldMetadata(alias="valueInteger")
    ] = pydantic.Field(default=None)
    """
    The information determined as a result of making the observation, if the information has a simple value.
    """

    value_range: typing_extensions.Annotated[
        typing.Optional[Range], FieldMetadata(alias="valueRange")
    ] = pydantic.Field(default=None)
    """
    The information determined as a result of making the observation, if the information has a simple value.
    """

    value_ratio: typing_extensions.Annotated[
        typing.Optional[Ratio], FieldMetadata(alias="valueRatio")
    ] = pydantic.Field(default=None)
    """
    The information determined as a result of making the observation, if the information has a simple value.
    """

    value_sampled_data: typing_extensions.Annotated[
        typing.Optional[SampledData], FieldMetadata(alias="valueSampledData")
    ] = pydantic.Field(default=None)
    """
    The information determined as a result of making the observation, if the information has a simple value.
    """

    value_time: typing_extensions.Annotated[
        typing.Optional[str], FieldMetadata(alias="valueTime")
    ] = pydantic.Field(default=None)
    """
    The information determined as a result of making the observation, if the information has a simple value.
    """

    value_date_time: typing_extensions.Annotated[
        typing.Optional[str], FieldMetadata(alias="valueDateTime")
    ] = pydantic.Field(default=None)
    """
    The information determined as a result of making the observation, if the information has a simple value.
    """

    value_period: typing_extensions.Annotated[
        typing.Optional[Period], FieldMetadata(alias="valuePeriod")
    ] = pydantic.Field(default=None)
    """
    The information determined as a result of making the observation, if the information has a simple value.
    """

    data_absent_reason: typing_extensions.Annotated[
        typing.Optional[CodeableConcept], FieldMetadata(alias="dataAbsentReason")
    ] = pydantic.Field(default=None)
    """
    Provides a reason why the expected value in the element Observation.component.value[x] is missing.
    """

    interpretation: typing.Optional[typing.List[CodeableConcept]] = pydantic.Field(
        default=None
    )
    """
    A categorical assessment of an observation value. For example, high, low, normal.
    """

    reference_range: typing_extensions.Annotated[
        typing.Optional[typing.List[ObservationReferenceRange]],
        FieldMetadata(alias="referenceRange"),
    ] = pydantic.Field(default=None)
    """
    Guidance on how to interpret the value by comparison to a normal or recommended range.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow", frozen=True
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
