# This file was auto-generated by Fern from our API Definition.

from .base_resource import BaseResource
from .address import Address
from .age import Age
from .annotation import Annotation
from .attachment import Attachment
from .codeable_concept import CodeableConcept
from .coding import Coding
from .contact_detail import ContactDetail
from .contact_point import ContactPoint
from .contributor import Contributor
from .count import Count
from .data_requirement import DataRequirement
from .data_requirement_code_filter import DataRequirementCodeFilter
from .data_requirement_date_filter import DataRequirementDateFilter
from .data_requirement_sort import DataRequirementSort
from .distance import Distance
from .dosage import Dosage
from .dosage_dose_and_rate import DosageDoseAndRate
from .duration import Duration
from .expression import Expression
from .extension import Extension
from .human_name import HumanName
from .identifier import Identifier
from .meta import Meta
from .money import Money
from .parameter_definition import ParameterDefinition
from .period import Period
from .quantity import Quantity
from .range import Range
from .ratio import Ratio
from .reference import Reference
from .related_artifact import RelatedArtifact
from .sampled_data import SampledData
from .signature import Signature
from .timing import Timing
from .timing_repeat import TimingRepeat
from .trigger_definition import TriggerDefinition
from .usage_context import UsageContext
import typing_extensions
import typing
from ...core.serialization import FieldMetadata
import pydantic
from .observation_status import ObservationStatus
from .instant import Instant
from .observation_reference_range import ObservationReferenceRange
from .observation_component import ObservationComponent
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class Observation(BaseResource):
    """
    Measurements and simple assertions made about a patient, device or other subject.
    """

    resource_type: typing_extensions.Annotated[
        typing.Literal["Observation"], FieldMetadata(alias="resourceType")
    ] = "Observation"
    identifier: typing.Optional[typing.List[Identifier]] = pydantic.Field(default=None)
    """
    A unique identifier assigned to this observation.
    """

    based_on: typing_extensions.Annotated[
        typing.Optional[typing.List[Reference]], FieldMetadata(alias="basedOn")
    ] = pydantic.Field(default=None)
    """
    A plan, proposal or order that is fulfilled in whole or in part by this event. For example, a MedicationRequest may require a patient to have laboratory test performed before it is dispensed.
    """

    part_of: typing_extensions.Annotated[
        typing.Optional[typing.List[Reference]], FieldMetadata(alias="partOf")
    ] = pydantic.Field(default=None)
    """
    A larger event of which this particular Observation is a component or step. For example, an observation as part of a procedure.
    """

    status: typing.Optional[ObservationStatus] = pydantic.Field(default=None)
    """
    The status of the result value.
    """

    category: typing.Optional[typing.List[CodeableConcept]] = pydantic.Field(
        default=None
    )
    """
    A code that classifies the general type of observation being made.
    """

    code: CodeableConcept = pydantic.Field()
    """
    Describes what was observed. Sometimes this is called the observation "name".
    """

    subject: typing.Optional[Reference] = pydantic.Field(default=None)
    """
    The patient, or group of patients, location, or device this observation is about and into whose record the observation is placed. If the actual focus of the observation is different from the subject (or a sample of, part, or region of the subject), the `focus` element or the `code` itself specifies the actual focus of the observation.
    """

    focus: typing.Optional[typing.List[Reference]] = pydantic.Field(default=None)
    """
    The actual focus of an observation when it is not the patient of record representing something or someone associated with the patient such as a spouse, parent, fetus, or donor. For example, fetus observations in a mother's record. The focus of an observation could also be an existing condition, an intervention, the subject's diet, another observation of the subject, or a body structure such as tumor or implanted device. An example use case would be using the Observation resource to capture whether the mother is trained to change her child's tracheostomy tube. In this example, the child is the patient of record and the mother is the focus.
    """

    encounter: typing.Optional[Reference] = pydantic.Field(default=None)
    """
    The healthcare event (e.g. a patient and healthcare provider interaction) during which this observation is made.
    """

    effective_date_time: typing_extensions.Annotated[
        typing.Optional[str], FieldMetadata(alias="effectiveDateTime")
    ] = pydantic.Field(default=None)
    """
    The time or time-period the observed value is asserted as being true. For biological subjects - e.g. human patients - this is usually called the "physiologically relevant time". This is usually either the time of the procedure or of specimen collection, but very often the source of the date/time is not known, only the date/time itself.
    """

    effective_period: typing_extensions.Annotated[
        typing.Optional[Period], FieldMetadata(alias="effectivePeriod")
    ] = pydantic.Field(default=None)
    """
    The time or time-period the observed value is asserted as being true. For biological subjects - e.g. human patients - this is usually called the "physiologically relevant time". This is usually either the time of the procedure or of specimen collection, but very often the source of the date/time is not known, only the date/time itself.
    """

    effective_timing: typing_extensions.Annotated[
        typing.Optional[Timing], FieldMetadata(alias="effectiveTiming")
    ] = pydantic.Field(default=None)
    """
    The time or time-period the observed value is asserted as being true. For biological subjects - e.g. human patients - this is usually called the "physiologically relevant time". This is usually either the time of the procedure or of specimen collection, but very often the source of the date/time is not known, only the date/time itself.
    """

    effective_instant: typing_extensions.Annotated[
        typing.Optional[str], FieldMetadata(alias="effectiveInstant")
    ] = pydantic.Field(default=None)
    """
    The time or time-period the observed value is asserted as being true. For biological subjects - e.g. human patients - this is usually called the "physiologically relevant time". This is usually either the time of the procedure or of specimen collection, but very often the source of the date/time is not known, only the date/time itself.
    """

    issued: typing.Optional[Instant] = pydantic.Field(default=None)
    """
    The date and time this version of the observation was made available to providers, typically after the results have been reviewed and verified.
    """

    performer: typing.Optional[typing.List[Reference]] = pydantic.Field(default=None)
    """
    Who was responsible for asserting the observed value as "true".
    """

    value_quantity: typing_extensions.Annotated[
        typing.Optional[Quantity], FieldMetadata(alias="valueQuantity")
    ] = pydantic.Field(default=None)
    """
    The information determined as a result of making the observation, if the information has a simple value.
    """

    value_codeable_concept: typing_extensions.Annotated[
        typing.Optional[CodeableConcept], FieldMetadata(alias="valueCodeableConcept")
    ] = pydantic.Field(default=None)
    """
    The information determined as a result of making the observation, if the information has a simple value.
    """

    value_string: typing_extensions.Annotated[
        typing.Optional[str], FieldMetadata(alias="valueString")
    ] = pydantic.Field(default=None)
    """
    The information determined as a result of making the observation, if the information has a simple value.
    """

    value_boolean: typing_extensions.Annotated[
        typing.Optional[bool], FieldMetadata(alias="valueBoolean")
    ] = pydantic.Field(default=None)
    """
    The information determined as a result of making the observation, if the information has a simple value.
    """

    value_integer: typing_extensions.Annotated[
        typing.Optional[float], FieldMetadata(alias="valueInteger")
    ] = pydantic.Field(default=None)
    """
    The information determined as a result of making the observation, if the information has a simple value.
    """

    value_range: typing_extensions.Annotated[
        typing.Optional[Range], FieldMetadata(alias="valueRange")
    ] = pydantic.Field(default=None)
    """
    The information determined as a result of making the observation, if the information has a simple value.
    """

    value_ratio: typing_extensions.Annotated[
        typing.Optional[Ratio], FieldMetadata(alias="valueRatio")
    ] = pydantic.Field(default=None)
    """
    The information determined as a result of making the observation, if the information has a simple value.
    """

    value_sampled_data: typing_extensions.Annotated[
        typing.Optional[SampledData], FieldMetadata(alias="valueSampledData")
    ] = pydantic.Field(default=None)
    """
    The information determined as a result of making the observation, if the information has a simple value.
    """

    value_time: typing_extensions.Annotated[
        typing.Optional[str], FieldMetadata(alias="valueTime")
    ] = pydantic.Field(default=None)
    """
    The information determined as a result of making the observation, if the information has a simple value.
    """

    value_date_time: typing_extensions.Annotated[
        typing.Optional[str], FieldMetadata(alias="valueDateTime")
    ] = pydantic.Field(default=None)
    """
    The information determined as a result of making the observation, if the information has a simple value.
    """

    value_period: typing_extensions.Annotated[
        typing.Optional[Period], FieldMetadata(alias="valuePeriod")
    ] = pydantic.Field(default=None)
    """
    The information determined as a result of making the observation, if the information has a simple value.
    """

    data_absent_reason: typing_extensions.Annotated[
        typing.Optional[CodeableConcept], FieldMetadata(alias="dataAbsentReason")
    ] = pydantic.Field(default=None)
    """
    Provides a reason why the expected value in the element Observation.value[x] is missing.
    """

    interpretation: typing.Optional[typing.List[CodeableConcept]] = pydantic.Field(
        default=None
    )
    """
    A categorical assessment of an observation value. For example, high, low, normal.
    """

    note: typing.Optional[typing.List[Annotation]] = pydantic.Field(default=None)
    """
    Comments about the observation or the results.
    """

    body_site: typing_extensions.Annotated[
        typing.Optional[CodeableConcept], FieldMetadata(alias="bodySite")
    ] = pydantic.Field(default=None)
    """
    Indicates the site on the subject's body where the observation was made (i.e. the target site).
    """

    method: typing.Optional[CodeableConcept] = pydantic.Field(default=None)
    """
    Indicates the mechanism used to perform the observation.
    """

    specimen: typing.Optional[Reference] = pydantic.Field(default=None)
    """
    The specimen that was used when this observation was made.
    """

    device: typing.Optional[Reference] = pydantic.Field(default=None)
    """
    The device used to generate the observation data.
    """

    reference_range: typing_extensions.Annotated[
        typing.Optional[typing.List[ObservationReferenceRange]],
        FieldMetadata(alias="referenceRange"),
    ] = pydantic.Field(default=None)
    """
    Guidance on how to interpret the value by comparison to a normal or recommended range. Multiple reference ranges are interpreted as an "OR". In other words, to represent two distinct target populations, two `referenceRange` elements would be used.
    """

    has_member: typing_extensions.Annotated[
        typing.Optional[typing.List[Reference]], FieldMetadata(alias="hasMember")
    ] = pydantic.Field(default=None)
    """
    This observation is a group observation (e.g. a battery, a panel of tests, a set of vital sign measurements) that includes the target as a member of the group.
    """

    derived_from: typing_extensions.Annotated[
        typing.Optional[typing.List[Reference]], FieldMetadata(alias="derivedFrom")
    ] = pydantic.Field(default=None)
    """
    The target resource that represents a measurement from which this observation value is derived. For example, a calculated anion gap or a fetal measurement based on an ultrasound image.
    """

    component: typing.Optional[typing.List[ObservationComponent]] = pydantic.Field(
        default=None
    )
    """
    Some observations have multiple component observations. These component observations are expressed as separate code value pairs that share the same attributes. Examples include systolic and diastolic component observations for blood pressure measurement and multiple component observations for genetics observations.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow", frozen=True
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
