# This file was auto-generated by Fern from our API Definition.

from ...core.pydantic_utilities import UniversalBaseModel
from .address import Address
from .age import Age
from .annotation import Annotation
from .attachment import Attachment
from .codeable_concept import CodeableConcept
from .coding import Coding
from .contact_detail import ContactDetail
from .contact_point import ContactPoint
from .contributor import Contributor
from .count import Count
from .data_requirement import DataRequirement
from .data_requirement_code_filter import DataRequirementCodeFilter
from .data_requirement_date_filter import DataRequirementDateFilter
from .data_requirement_sort import DataRequirementSort
from .distance import Distance
from .dosage import Dosage
from .dosage_dose_and_rate import DosageDoseAndRate
from .duration import Duration
from .expression import Expression
from .extension import Extension
from .human_name import HumanName
from .identifier import Identifier
from .meta import Meta
from .money import Money
from .parameter_definition import ParameterDefinition
from .period import Period
from .quantity import Quantity
from .range import Range
from .ratio import Ratio
from .reference import Reference
from .related_artifact import RelatedArtifact
from .sampled_data import SampledData
from .signature import Signature
from .timing import Timing
from .timing_repeat import TimingRepeat
from .trigger_definition import TriggerDefinition
from .usage_context import UsageContext
import typing
import pydantic
import typing_extensions
from ...core.serialization import FieldMetadata
from .nutrition_order_administration import NutritionOrderAdministration
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class NutritionOrderEnteralFormula(UniversalBaseModel):
    """
    A request to supply a diet, formula feeding (enteral) or oral nutritional supplement to a patient/resident.
    """

    id: typing.Optional[str] = pydantic.Field(default=None)
    """
    Unique id for the element within a resource (for internal references). This may be any string value that does not contain spaces.
    """

    extension: typing.Optional[typing.List[Extension]] = pydantic.Field(default=None)
    """
    May be used to represent additional information that is not part of the basic definition of the element. To make the use of extensions safe and manageable, there is a strict set of governance applied to the definition and use of extensions. Though any implementer can define an extension, there is a set of requirements that SHALL be met as part of the definition of the extension.
    """

    modifier_extension: typing_extensions.Annotated[
        typing.Optional[typing.List[Extension]],
        FieldMetadata(alias="modifierExtension"),
    ] = pydantic.Field(default=None)
    """
    May be used to represent additional information that is not part of the basic definition of the element and that modifies the understanding of the element in which it is contained and/or the understanding of the containing element's descendants. Usually modifier elements provide negation or qualification. To make the use of extensions safe and manageable, there is a strict set of governance applied to the definition and use of extensions. Though any implementer can define an extension, there is a set of requirements that SHALL be met as part of the definition of the extension. Applications processing a resource are required to check for modifier extensions. Modifier extensions SHALL NOT change the meaning of any elements on Resource or DomainResource (including cannot change the meaning of modifierExtension itself).
    """

    base_formula_type: typing_extensions.Annotated[
        typing.Optional[CodeableConcept], FieldMetadata(alias="baseFormulaType")
    ] = pydantic.Field(default=None)
    """
    The type of enteral or infant formula such as an adult standard formula with fiber or a soy-based infant formula.
    """

    base_formula_product_name: typing_extensions.Annotated[
        typing.Optional[str], FieldMetadata(alias="baseFormulaProductName")
    ] = pydantic.Field(default=None)
    """
    The product or brand name of the enteral or infant formula product such as "ACME Adult Standard Formula".
    """

    additive_type: typing_extensions.Annotated[
        typing.Optional[CodeableConcept], FieldMetadata(alias="additiveType")
    ] = pydantic.Field(default=None)
    """
    Indicates the type of modular component such as protein, carbohydrate, fat or fiber to be provided in addition to or mixed with the base formula.
    """

    additive_product_name: typing_extensions.Annotated[
        typing.Optional[str], FieldMetadata(alias="additiveProductName")
    ] = pydantic.Field(default=None)
    """
    The product or brand name of the type of modular component to be added to the formula.
    """

    caloric_density: typing_extensions.Annotated[
        typing.Optional[Quantity], FieldMetadata(alias="caloricDensity")
    ] = pydantic.Field(default=None)
    """
    The amount of energy (calories) that the formula should provide per specified volume, typically per mL or fluid oz. For example, an infant may require a formula that provides 24 calories per fluid ounce or an adult may require an enteral formula that provides 1.5 calorie/mL.
    """

    routeof_administration: typing_extensions.Annotated[
        typing.Optional[CodeableConcept], FieldMetadata(alias="routeofAdministration")
    ] = pydantic.Field(default=None)
    """
    The route or physiological path of administration into the patient's gastrointestinal tract for purposes of providing the formula feeding, e.g. nasogastric tube.
    """

    administration: typing.Optional[typing.List[NutritionOrderAdministration]] = (
        pydantic.Field(default=None)
    )
    """
    Formula administration instructions as structured data. This repeating structure allows for changing the administration rate or volume over time for both bolus and continuous feeding. An example of this would be an instruction to increase the rate of continuous feeding every 2 hours.
    """

    max_volume_to_deliver: typing_extensions.Annotated[
        typing.Optional[Quantity], FieldMetadata(alias="maxVolumeToDeliver")
    ] = pydantic.Field(default=None)
    """
    The maximum total quantity of formula that may be administered to a subject over the period of time, e.g. 1440 mL over 24 hours.
    """

    administration_instruction: typing_extensions.Annotated[
        typing.Optional[str], FieldMetadata(alias="administrationInstruction")
    ] = pydantic.Field(default=None)
    """
    Free text formula administration, feeding instructions or additional instructions or information.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow", frozen=True
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
