# This file was auto-generated by Fern from our API Definition.

from .base_resource import BaseResource
from .address import Address
from .age import Age
from .annotation import Annotation
from .attachment import Attachment
from .codeable_concept import CodeableConcept
from .coding import Coding
from .contact_detail import ContactDetail
from .contact_point import ContactPoint
from .contributor import Contributor
from .count import Count
from .data_requirement import DataRequirement
from .data_requirement_code_filter import DataRequirementCodeFilter
from .data_requirement_date_filter import DataRequirementDateFilter
from .data_requirement_sort import DataRequirementSort
from .distance import Distance
from .dosage import Dosage
from .dosage_dose_and_rate import DosageDoseAndRate
from .duration import Duration
from .expression import Expression
from .extension import Extension
from .human_name import HumanName
from .identifier import Identifier
from .meta import Meta
from .money import Money
from .parameter_definition import ParameterDefinition
from .period import Period
from .quantity import Quantity
from .range import Range
from .ratio import Ratio
from .reference import Reference
from .related_artifact import RelatedArtifact
from .sampled_data import SampledData
from .signature import Signature
from .timing import Timing
from .timing_repeat import TimingRepeat
from .trigger_definition import TriggerDefinition
from .usage_context import UsageContext
import typing_extensions
import typing
from ...core.serialization import FieldMetadata
import pydantic
from .canonical import Canonical
from .uri import Uri
from .code import Code
from .date_time import DateTime
from .nutrition_order_oral_diet import NutritionOrderOralDiet
from .nutrition_order_supplement import NutritionOrderSupplement
from .nutrition_order_enteral_formula import NutritionOrderEnteralFormula
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class NutritionOrder(BaseResource):
    """
    A request to supply a diet, formula feeding (enteral) or oral nutritional supplement to a patient/resident.
    """

    resource_type: typing_extensions.Annotated[
        typing.Literal["NutritionOrder"], FieldMetadata(alias="resourceType")
    ] = "NutritionOrder"
    identifier: typing.Optional[typing.List[Identifier]] = pydantic.Field(default=None)
    """
    Identifiers assigned to this order by the order sender or by the order receiver.
    """

    instantiates_canonical: typing_extensions.Annotated[
        typing.Optional[typing.List[Canonical]],
        FieldMetadata(alias="instantiatesCanonical"),
    ] = pydantic.Field(default=None)
    """
    The URL pointing to a FHIR-defined protocol, guideline, orderset or other definition that is adhered to in whole or in part by this NutritionOrder.
    """

    instantiates_uri: typing_extensions.Annotated[
        typing.Optional[typing.List[Uri]], FieldMetadata(alias="instantiatesUri")
    ] = pydantic.Field(default=None)
    """
    The URL pointing to an externally maintained protocol, guideline, orderset or other definition that is adhered to in whole or in part by this NutritionOrder.
    """

    instantiates: typing.Optional[typing.List[Uri]] = pydantic.Field(default=None)
    """
    The URL pointing to a protocol, guideline, orderset or other definition that is adhered to in whole or in part by this NutritionOrder.
    """

    status: typing.Optional[Code] = pydantic.Field(default=None)
    """
    The workflow status of the nutrition order/request.
    """

    intent: typing.Optional[Code] = pydantic.Field(default=None)
    """
    Indicates the level of authority/intentionality associated with the NutrionOrder and where the request fits into the workflow chain.
    """

    patient: Reference = pydantic.Field()
    """
    The person (patient) who needs the nutrition order for an oral diet, nutritional supplement and/or enteral or formula feeding.
    """

    encounter: typing.Optional[Reference] = pydantic.Field(default=None)
    """
    An encounter that provides additional information about the healthcare context in which this request is made.
    """

    date_time: typing_extensions.Annotated[
        typing.Optional[DateTime], FieldMetadata(alias="dateTime")
    ] = pydantic.Field(default=None)
    """
    The date and time that this nutrition order was requested.
    """

    orderer: typing.Optional[Reference] = pydantic.Field(default=None)
    """
    The practitioner that holds legal responsibility for ordering the diet, nutritional supplement, or formula feedings.
    """

    allergy_intolerance: typing_extensions.Annotated[
        typing.Optional[typing.List[Reference]],
        FieldMetadata(alias="allergyIntolerance"),
    ] = pydantic.Field(default=None)
    """
    A link to a record of allergies or intolerances which should be included in the nutrition order.
    """

    food_preference_modifier: typing_extensions.Annotated[
        typing.Optional[typing.List[CodeableConcept]],
        FieldMetadata(alias="foodPreferenceModifier"),
    ] = pydantic.Field(default=None)
    """
    This modifier is used to convey order-specific modifiers about the type of food that should be given. These can be derived from patient allergies, intolerances, or preferences such as Halal, Vegan or Kosher. This modifier applies to the entire nutrition order inclusive of the oral diet, nutritional supplements and enteral formula feedings.
    """

    exclude_food_modifier: typing_extensions.Annotated[
        typing.Optional[typing.List[CodeableConcept]],
        FieldMetadata(alias="excludeFoodModifier"),
    ] = pydantic.Field(default=None)
    """
    This modifier is used to convey Order-specific modifier about the type of oral food or oral fluids that should not be given. These can be derived from patient allergies, intolerances, or preferences such as No Red Meat, No Soy or No Wheat or Gluten-Free. While it should not be necessary to repeat allergy or intolerance information captured in the referenced AllergyIntolerance resource in the excludeFoodModifier, this element may be used to convey additional specificity related to foods that should be eliminated from the patient’s diet for any reason. This modifier applies to the entire nutrition order inclusive of the oral diet, nutritional supplements and enteral formula feedings.
    """

    oral_diet: typing_extensions.Annotated[
        typing.Optional[NutritionOrderOralDiet], FieldMetadata(alias="oralDiet")
    ] = pydantic.Field(default=None)
    """
    Diet given orally in contrast to enteral (tube) feeding.
    """

    supplement: typing.Optional[typing.List[NutritionOrderSupplement]] = pydantic.Field(
        default=None
    )
    """
    Oral nutritional products given in order to add further nutritional value to the patient's diet.
    """

    enteral_formula: typing_extensions.Annotated[
        typing.Optional[NutritionOrderEnteralFormula],
        FieldMetadata(alias="enteralFormula"),
    ] = pydantic.Field(default=None)
    """
    Feeding provided through the gastrointestinal tract via a tube, catheter, or stoma that delivers nutrition distal to the oral cavity.
    """

    note: typing.Optional[typing.List[Annotation]] = pydantic.Field(default=None)
    """
    Comments made about the {{title}} by the requester, performer, subject or other participants.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow", frozen=True
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
