# This file was auto-generated by Fern from our API Definition.

from .base_resource import BaseResource
from .address import Address
from .age import Age
from .annotation import Annotation
from .attachment import Attachment
from .codeable_concept import CodeableConcept
from .coding import Coding
from .contact_detail import ContactDetail
from .contact_point import ContactPoint
from .contributor import Contributor
from .count import Count
from .data_requirement import DataRequirement
from .data_requirement_code_filter import DataRequirementCodeFilter
from .data_requirement_date_filter import DataRequirementDateFilter
from .data_requirement_sort import DataRequirementSort
from .distance import Distance
from .dosage import Dosage
from .dosage_dose_and_rate import DosageDoseAndRate
from .duration import Duration
from .expression import Expression
from .extension import Extension
from .human_name import HumanName
from .identifier import Identifier
from .meta import Meta
from .money import Money
from .parameter_definition import ParameterDefinition
from .period import Period
from .quantity import Quantity
from .range import Range
from .ratio import Ratio
from .reference import Reference
from .related_artifact import RelatedArtifact
from .sampled_data import SampledData
from .signature import Signature
from .timing import Timing
from .timing_repeat import TimingRepeat
from .trigger_definition import TriggerDefinition
from .usage_context import UsageContext
import typing_extensions
import typing
from ...core.serialization import FieldMetadata
import pydantic
from .naming_system_status import NamingSystemStatus
from .naming_system_kind import NamingSystemKind
from .date_time import DateTime
from .markdown import Markdown
from .naming_system_unique_id import NamingSystemUniqueId
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class NamingSystem(BaseResource):
    """
    A curated namespace that issues unique symbols within that namespace for the identification of concepts, people, devices, etc. Represents a "System" used within the Identifier and Coding data types.
    """

    resource_type: typing_extensions.Annotated[
        typing.Literal["NamingSystem"], FieldMetadata(alias="resourceType")
    ] = "NamingSystem"
    name: typing.Optional[str] = pydantic.Field(default=None)
    """
    A natural language name identifying the naming system. This name should be usable as an identifier for the module by machine processing applications such as code generation.
    """

    status: typing.Optional[NamingSystemStatus] = pydantic.Field(default=None)
    """
    The status of this naming system. Enables tracking the life-cycle of the content.
    """

    kind: typing.Optional[NamingSystemKind] = pydantic.Field(default=None)
    """
    Indicates the purpose for the naming system - what kinds of things does it make unique?
    """

    date: typing.Optional[DateTime] = pydantic.Field(default=None)
    """
    The date (and optionally time) when the naming system was published. The date must change when the business version changes and it must change if the status code changes. In addition, it should change when the substantive content of the naming system changes.
    """

    publisher: typing.Optional[str] = pydantic.Field(default=None)
    """
    The name of the organization or individual that published the naming system.
    """

    contact: typing.Optional[typing.List[ContactDetail]] = pydantic.Field(default=None)
    """
    Contact details to assist a user in finding and communicating with the publisher.
    """

    responsible: typing.Optional[str] = pydantic.Field(default=None)
    """
    The name of the organization that is responsible for issuing identifiers or codes for this namespace and ensuring their non-collision.
    """

    type: typing.Optional[CodeableConcept] = pydantic.Field(default=None)
    """
    Categorizes a naming system for easier search by grouping related naming systems.
    """

    description: typing.Optional[Markdown] = pydantic.Field(default=None)
    """
    A free text natural language description of the naming system from a consumer's perspective. Details about what the namespace identifies including scope, granularity, version labeling, etc.
    """

    use_context: typing_extensions.Annotated[
        typing.Optional[typing.List[UsageContext]], FieldMetadata(alias="useContext")
    ] = pydantic.Field(default=None)
    """
    The content was developed with a focus and intent of supporting the contexts that are listed. These contexts may be general categories (gender, age, ...) or may be references to specific programs (insurance plans, studies, ...) and may be used to assist with indexing and searching for appropriate naming system instances.
    """

    jurisdiction: typing.Optional[typing.List[CodeableConcept]] = pydantic.Field(
        default=None
    )
    """
    A legal or geographic region in which the naming system is intended to be used.
    """

    usage: typing.Optional[str] = pydantic.Field(default=None)
    """
    Provides guidance on the use of the namespace, including the handling of formatting characters, use of upper vs. lower case, etc.
    """

    unique_id: typing_extensions.Annotated[
        typing.List[NamingSystemUniqueId], FieldMetadata(alias="uniqueId")
    ] = pydantic.Field()
    """
    Indicates how the system may be identified when referenced in electronic exchange.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow", frozen=True
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
