# This file was auto-generated by Fern from our API Definition.

from ...core.pydantic_utilities import UniversalBaseModel
from .address import Address
from .age import Age
from .annotation import Annotation
from .attachment import Attachment
from .codeable_concept import CodeableConcept
from .coding import Coding
from .contact_detail import ContactDetail
from .contact_point import ContactPoint
from .contributor import Contributor
from .count import Count
from .data_requirement import DataRequirement
from .data_requirement_code_filter import DataRequirementCodeFilter
from .data_requirement_date_filter import DataRequirementDateFilter
from .data_requirement_sort import DataRequirementSort
from .distance import Distance
from .dosage import Dosage
from .dosage_dose_and_rate import DosageDoseAndRate
from .duration import Duration
from .expression import Expression
from .extension import Extension
from .human_name import HumanName
from .identifier import Identifier
from .meta import Meta
from .money import Money
from .parameter_definition import ParameterDefinition
from .period import Period
from .quantity import Quantity
from .range import Range
from .ratio import Ratio
from .reference import Reference
from .related_artifact import RelatedArtifact
from .sampled_data import SampledData
from .signature import Signature
from .timing import Timing
from .timing_repeat import TimingRepeat
from .trigger_definition import TriggerDefinition
from .usage_context import UsageContext
import typing
import pydantic
import typing_extensions
from ...core.serialization import FieldMetadata
from .molecular_sequence_reference_seq_orientation import (
    MolecularSequenceReferenceSeqOrientation,
)
from .molecular_sequence_reference_seq_strand import MolecularSequenceReferenceSeqStrand
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class MolecularSequenceReferenceSeq(UniversalBaseModel):
    """
    Raw data describing a biological sequence.
    """

    id: typing.Optional[str] = pydantic.Field(default=None)
    """
    Unique id for the element within a resource (for internal references). This may be any string value that does not contain spaces.
    """

    extension: typing.Optional[typing.List[Extension]] = pydantic.Field(default=None)
    """
    May be used to represent additional information that is not part of the basic definition of the element. To make the use of extensions safe and manageable, there is a strict set of governance applied to the definition and use of extensions. Though any implementer can define an extension, there is a set of requirements that SHALL be met as part of the definition of the extension.
    """

    modifier_extension: typing_extensions.Annotated[
        typing.Optional[typing.List[Extension]],
        FieldMetadata(alias="modifierExtension"),
    ] = pydantic.Field(default=None)
    """
    May be used to represent additional information that is not part of the basic definition of the element and that modifies the understanding of the element in which it is contained and/or the understanding of the containing element's descendants. Usually modifier elements provide negation or qualification. To make the use of extensions safe and manageable, there is a strict set of governance applied to the definition and use of extensions. Though any implementer can define an extension, there is a set of requirements that SHALL be met as part of the definition of the extension. Applications processing a resource are required to check for modifier extensions. Modifier extensions SHALL NOT change the meaning of any elements on Resource or DomainResource (including cannot change the meaning of modifierExtension itself).
    """

    chromosome: typing.Optional[CodeableConcept] = pydantic.Field(default=None)
    """
    Structural unit composed of a nucleic acid molecule which controls its own replication through the interaction of specific proteins at one or more origins of replication ([SO:0000340](http://www.sequenceontology.org/browser/current_svn/term/SO:0000340)).
    """

    genome_build: typing_extensions.Annotated[
        typing.Optional[str], FieldMetadata(alias="genomeBuild")
    ] = pydantic.Field(default=None)
    """
    The Genome Build used for reference, following GRCh build versions e.g. 'GRCh 37'. Version number must be included if a versioned release of a primary build was used.
    """

    orientation: typing.Optional[MolecularSequenceReferenceSeqOrientation] = (
        pydantic.Field(default=None)
    )
    """
    A relative reference to a DNA strand based on gene orientation. The strand that contains the open reading frame of the gene is the "sense" strand, and the opposite complementary strand is the "antisense" strand.
    """

    reference_seq_id: typing_extensions.Annotated[
        typing.Optional[CodeableConcept], FieldMetadata(alias="referenceSeqId")
    ] = pydantic.Field(default=None)
    """
    Reference identifier of reference sequence submitted to NCBI. It must match the type in the MolecularSequence.type field. For example, the prefix, “NG*” identifies reference sequence for genes, “NM*” for messenger RNA transcripts, and “NP\_” for amino acid sequences.
    """

    reference_seq_pointer: typing_extensions.Annotated[
        typing.Optional[Reference], FieldMetadata(alias="referenceSeqPointer")
    ] = pydantic.Field(default=None)
    """
    A pointer to another MolecularSequence entity as reference sequence.
    """

    reference_seq_string: typing_extensions.Annotated[
        typing.Optional[str], FieldMetadata(alias="referenceSeqString")
    ] = pydantic.Field(default=None)
    """
    A string like "ACGT".
    """

    strand: typing.Optional[MolecularSequenceReferenceSeqStrand] = pydantic.Field(
        default=None
    )
    """
    An absolute reference to a strand. The Watson strand is the strand whose 5'-end is on the short arm of the chromosome, and the Crick strand as the one whose 5'-end is on the long arm.
    """

    window_start: typing_extensions.Annotated[
        typing.Optional[int], FieldMetadata(alias="windowStart")
    ] = pydantic.Field(default=None)
    """
    Start position of the window on the reference sequence. If the coordinate system is either 0-based or 1-based, then start position is inclusive.
    """

    window_end: typing_extensions.Annotated[
        typing.Optional[int], FieldMetadata(alias="windowEnd")
    ] = pydantic.Field(default=None)
    """
    End position of the window on the reference sequence. If the coordinate system is 0-based then end is exclusive and does not include the last position. If the coordinate system is 1-base, then end is inclusive and includes the last position.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow", frozen=True
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
