# This file was auto-generated by Fern from our API Definition.

from ...core.pydantic_utilities import UniversalBaseModel
from .address import Address
from .age import Age
from .annotation import Annotation
from .attachment import Attachment
from .codeable_concept import CodeableConcept
from .coding import Coding
from .contact_detail import ContactDetail
from .contact_point import ContactPoint
from .contributor import Contributor
from .count import Count
from .data_requirement import DataRequirement
from .data_requirement_code_filter import DataRequirementCodeFilter
from .data_requirement_date_filter import DataRequirementDateFilter
from .data_requirement_sort import DataRequirementSort
from .distance import Distance
from .dosage import Dosage
from .dosage_dose_and_rate import DosageDoseAndRate
from .duration import Duration
from .expression import Expression
from .extension import Extension
from .human_name import HumanName
from .identifier import Identifier
from .meta import Meta
from .money import Money
from .parameter_definition import ParameterDefinition
from .period import Period
from .quantity import Quantity
from .range import Range
from .ratio import Ratio
from .reference import Reference
from .related_artifact import RelatedArtifact
from .sampled_data import SampledData
from .signature import Signature
from .timing import Timing
from .timing_repeat import TimingRepeat
from .trigger_definition import TriggerDefinition
from .usage_context import UsageContext
import typing
import pydantic
import typing_extensions
from ...core.serialization import FieldMetadata
from .molecular_sequence_quality_type import MolecularSequenceQualityType
from .decimal import Decimal
from .molecular_sequence_roc import MolecularSequenceRoc
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class MolecularSequenceQuality(UniversalBaseModel):
    """
    Raw data describing a biological sequence.
    """

    id: typing.Optional[str] = pydantic.Field(default=None)
    """
    Unique id for the element within a resource (for internal references). This may be any string value that does not contain spaces.
    """

    extension: typing.Optional[typing.List[Extension]] = pydantic.Field(default=None)
    """
    May be used to represent additional information that is not part of the basic definition of the element. To make the use of extensions safe and manageable, there is a strict set of governance applied to the definition and use of extensions. Though any implementer can define an extension, there is a set of requirements that SHALL be met as part of the definition of the extension.
    """

    modifier_extension: typing_extensions.Annotated[
        typing.Optional[typing.List[Extension]],
        FieldMetadata(alias="modifierExtension"),
    ] = pydantic.Field(default=None)
    """
    May be used to represent additional information that is not part of the basic definition of the element and that modifies the understanding of the element in which it is contained and/or the understanding of the containing element's descendants. Usually modifier elements provide negation or qualification. To make the use of extensions safe and manageable, there is a strict set of governance applied to the definition and use of extensions. Though any implementer can define an extension, there is a set of requirements that SHALL be met as part of the definition of the extension. Applications processing a resource are required to check for modifier extensions. Modifier extensions SHALL NOT change the meaning of any elements on Resource or DomainResource (including cannot change the meaning of modifierExtension itself).
    """

    type: typing.Optional[MolecularSequenceQualityType] = pydantic.Field(default=None)
    """
    INDEL / SNP / Undefined variant.
    """

    standard_sequence: typing_extensions.Annotated[
        typing.Optional[CodeableConcept], FieldMetadata(alias="standardSequence")
    ] = pydantic.Field(default=None)
    """
    Gold standard sequence used for comparing against.
    """

    start: typing.Optional[int] = pydantic.Field(default=None)
    """
    Start position of the sequence. If the coordinate system is either 0-based or 1-based, then start position is inclusive.
    """

    end: typing.Optional[int] = pydantic.Field(default=None)
    """
    End position of the sequence. If the coordinate system is 0-based then end is exclusive and does not include the last position. If the coordinate system is 1-base, then end is inclusive and includes the last position.
    """

    score: typing.Optional[Quantity] = pydantic.Field(default=None)
    """
    The score of an experimentally derived feature such as a p-value ([SO:0001685](http://www.sequenceontology.org/browser/current_svn/term/SO:0001685)).
    """

    method: typing.Optional[CodeableConcept] = pydantic.Field(default=None)
    """
    Which method is used to get sequence quality.
    """

    truth_tp: typing_extensions.Annotated[
        typing.Optional[Decimal], FieldMetadata(alias="truthTP")
    ] = pydantic.Field(default=None)
    """
    True positives, from the perspective of the truth data, i.e. the number of sites in the Truth Call Set for which there are paths through the Query Call Set that are consistent with all of the alleles at this site, and for which there is an accurate genotype call for the event.
    """

    query_tp: typing_extensions.Annotated[
        typing.Optional[Decimal], FieldMetadata(alias="queryTP")
    ] = pydantic.Field(default=None)
    """
    True positives, from the perspective of the query data, i.e. the number of sites in the Query Call Set for which there are paths through the Truth Call Set that are consistent with all of the alleles at this site, and for which there is an accurate genotype call for the event.
    """

    truth_fn: typing_extensions.Annotated[
        typing.Optional[Decimal], FieldMetadata(alias="truthFN")
    ] = pydantic.Field(default=None)
    """
    False negatives, i.e. the number of sites in the Truth Call Set for which there is no path through the Query Call Set that is consistent with all of the alleles at this site, or sites for which there is an inaccurate genotype call for the event. Sites with correct variant but incorrect genotype are counted here.
    """

    query_fp: typing_extensions.Annotated[
        typing.Optional[Decimal], FieldMetadata(alias="queryFP")
    ] = pydantic.Field(default=None)
    """
    False positives, i.e. the number of sites in the Query Call Set for which there is no path through the Truth Call Set that is consistent with this site. Sites with correct variant but incorrect genotype are counted here.
    """

    gt_fp: typing_extensions.Annotated[
        typing.Optional[Decimal], FieldMetadata(alias="gtFP")
    ] = pydantic.Field(default=None)
    """
    The number of false positives where the non-REF alleles in the Truth and Query Call Sets match (i.e. cases where the truth is 1/1 and the query is 0/1 or similar).
    """

    precision: typing.Optional[Decimal] = pydantic.Field(default=None)
    """
    QUERY.TP / (QUERY.TP + QUERY.FP).
    """

    recall: typing.Optional[Decimal] = pydantic.Field(default=None)
    """
    TRUTH.TP / (TRUTH.TP + TRUTH.FN).
    """

    f_score: typing_extensions.Annotated[
        typing.Optional[Decimal], FieldMetadata(alias="fScore")
    ] = pydantic.Field(default=None)
    """
    Harmonic mean of Recall and Precision, computed as: 2 _ precision _ recall / (precision + recall).
    """

    roc: typing.Optional[MolecularSequenceRoc] = pydantic.Field(default=None)
    """
    Receiver Operator Characteristic (ROC) Curve to give sensitivity/specificity tradeoff.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow", frozen=True
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
