# This file was auto-generated by Fern from our API Definition.

from .base_resource import BaseResource
from .address import Address
from .age import Age
from .annotation import Annotation
from .attachment import Attachment
from .codeable_concept import CodeableConcept
from .coding import Coding
from .contact_detail import ContactDetail
from .contact_point import ContactPoint
from .contributor import Contributor
from .count import Count
from .data_requirement import DataRequirement
from .data_requirement_code_filter import DataRequirementCodeFilter
from .data_requirement_date_filter import DataRequirementDateFilter
from .data_requirement_sort import DataRequirementSort
from .distance import Distance
from .dosage import Dosage
from .dosage_dose_and_rate import DosageDoseAndRate
from .duration import Duration
from .expression import Expression
from .extension import Extension
from .human_name import HumanName
from .identifier import Identifier
from .meta import Meta
from .money import Money
from .parameter_definition import ParameterDefinition
from .period import Period
from .quantity import Quantity
from .range import Range
from .ratio import Ratio
from .reference import Reference
from .related_artifact import RelatedArtifact
from .sampled_data import SampledData
from .signature import Signature
from .timing import Timing
from .timing_repeat import TimingRepeat
from .trigger_definition import TriggerDefinition
from .usage_context import UsageContext
import typing_extensions
import typing
from ...core.serialization import FieldMetadata
import pydantic
from .molecular_sequence_type import MolecularSequenceType
from .molecular_sequence_reference_seq import MolecularSequenceReferenceSeq
from .molecular_sequence_variant import MolecularSequenceVariant
from .molecular_sequence_quality import MolecularSequenceQuality
from .molecular_sequence_repository import MolecularSequenceRepository
from .molecular_sequence_structure_variant import MolecularSequenceStructureVariant
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class MolecularSequence(BaseResource):
    """
    Raw data describing a biological sequence.
    """

    resource_type: typing_extensions.Annotated[
        typing.Literal["MolecularSequence"], FieldMetadata(alias="resourceType")
    ] = "MolecularSequence"
    identifier: typing.Optional[typing.List[Identifier]] = pydantic.Field(default=None)
    """
    A unique identifier for this particular sequence instance. This is a FHIR-defined id.
    """

    type: typing.Optional[MolecularSequenceType] = pydantic.Field(default=None)
    """
    Amino Acid Sequence/ DNA Sequence / RNA Sequence.
    """

    coordinate_system: typing_extensions.Annotated[
        typing.Optional[int], FieldMetadata(alias="coordinateSystem")
    ] = pydantic.Field(default=None)
    """
    Whether the sequence is numbered starting at 0 (0-based numbering or coordinates, inclusive start, exclusive end) or starting at 1 (1-based numbering, inclusive start and inclusive end).
    """

    patient: typing.Optional[Reference] = pydantic.Field(default=None)
    """
    The patient whose sequencing results are described by this resource.
    """

    specimen: typing.Optional[Reference] = pydantic.Field(default=None)
    """
    Specimen used for sequencing.
    """

    device: typing.Optional[Reference] = pydantic.Field(default=None)
    """
    The method for sequencing, for example, chip information.
    """

    performer: typing.Optional[Reference] = pydantic.Field(default=None)
    """
    The organization or lab that should be responsible for this result.
    """

    quantity: typing.Optional[Quantity] = pydantic.Field(default=None)
    """
    The number of copies of the sequence of interest. (RNASeq).
    """

    reference_seq: typing_extensions.Annotated[
        typing.Optional[MolecularSequenceReferenceSeq],
        FieldMetadata(alias="referenceSeq"),
    ] = pydantic.Field(default=None)
    """
    A sequence that is used as a reference to describe variants that are present in a sequence analyzed.
    """

    variant: typing.Optional[typing.List[MolecularSequenceVariant]] = pydantic.Field(
        default=None
    )
    """
    The definition of variant here originates from Sequence ontology ([variant_of](http://www.sequenceontology.org/browser/current_svn/term/variant_of)). This element can represent amino acid or nucleic sequence change(including insertion,deletion,SNP,etc.) It can represent some complex mutation or segment variation with the assist of CIGAR string.
    """

    observed_seq: typing_extensions.Annotated[
        typing.Optional[str], FieldMetadata(alias="observedSeq")
    ] = pydantic.Field(default=None)
    """
    Sequence that was observed. It is the result marked by referenceSeq along with variant records on referenceSeq. This shall start from referenceSeq.windowStart and end by referenceSeq.windowEnd.
    """

    quality: typing.Optional[typing.List[MolecularSequenceQuality]] = pydantic.Field(
        default=None
    )
    """
    An experimental feature attribute that defines the quality of the feature in a quantitative way, such as a phred quality score ([SO:0001686](http://www.sequenceontology.org/browser/current_svn/term/SO:0001686)).
    """

    read_coverage: typing_extensions.Annotated[
        typing.Optional[int], FieldMetadata(alias="readCoverage")
    ] = pydantic.Field(default=None)
    """
    Coverage (read depth or depth) is the average number of reads representing a given nucleotide in the reconstructed sequence.
    """

    repository: typing.Optional[typing.List[MolecularSequenceRepository]] = (
        pydantic.Field(default=None)
    )
    """
    Configurations of the external repository. The repository shall store target's observedSeq or records related with target's observedSeq.
    """

    pointer: typing.Optional[typing.List[Reference]] = pydantic.Field(default=None)
    """
    Pointer to next atomic sequence which at most contains one variant.
    """

    structure_variant: typing_extensions.Annotated[
        typing.Optional[typing.List[MolecularSequenceStructureVariant]],
        FieldMetadata(alias="structureVariant"),
    ] = pydantic.Field(default=None)
    """
    Information about chromosome structure variation.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow", frozen=True
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
