# This file was auto-generated by Fern from our API Definition.

from __future__ import annotations
from ...core.pydantic_utilities import UniversalBaseModel
import typing
import pydantic
import typing_extensions
from .id import Id
from ...core.serialization import FieldMetadata
from .instant import Instant
from .uri import Uri
from .canonical import Canonical
from ...core.pydantic_utilities import IS_PYDANTIC_V2
from ...core.pydantic_utilities import update_forward_refs


class Meta(UniversalBaseModel):
    """
    The metadata about a resource. This is content in the resource that is maintained by the infrastructure. Changes to the content might not always be associated with version changes to the resource.
    """

    id: typing.Optional[str] = pydantic.Field(default=None)
    """
    Unique id for the element within a resource (for internal references). This may be any string value that does not contain spaces.
    """

    extension: typing.Optional[typing.List["Extension"]] = pydantic.Field(default=None)
    """
    May be used to represent additional information that is not part of the basic definition of the element. To make the use of extensions safe and manageable, there is a strict set of governance applied to the definition and use of extensions. Though any implementer can define an extension, there is a set of requirements that SHALL be met as part of the definition of the extension.
    """

    version_id: typing_extensions.Annotated[
        typing.Optional[Id], FieldMetadata(alias="versionId")
    ] = pydantic.Field(default=None)
    """
    The version specific identifier, as it appears in the version portion of the URL. This value changes when the resource is created, updated, or deleted.
    """

    last_updated: typing_extensions.Annotated[
        typing.Optional[Instant], FieldMetadata(alias="lastUpdated")
    ] = pydantic.Field(default=None)
    """
    When the resource last changed - e.g. when the version changed.
    """

    source: typing.Optional[Uri] = pydantic.Field(default=None)
    """
    A uri that identifies the source system of the resource. This provides a minimal amount of [[[Provenance]]] information that can be used to track or differentiate the source of information in the resource. The source may identify another FHIR server, document, message, database, etc.
    """

    profile: typing.Optional[typing.List[Canonical]] = pydantic.Field(default=None)
    """
    A list of profiles (references to [[[StructureDefinition]]] resources) that this resource claims to conform to. The URL is a reference to [[[StructureDefinition.url]]].
    """

    security: typing.Optional[typing.List["Coding"]] = pydantic.Field(default=None)
    """
    Security labels applied to this resource. These tags connect specific resources to the overall security policy and infrastructure.
    """

    tag: typing.Optional[typing.List["Coding"]] = pydantic.Field(default=None)
    """
    Tags applied to this resource. Tags are intended to be used to identify and relate resources to process and workflow, and applications are not required to consider the tags when interpreting the meaning of a resource.
    """

    project: typing.Optional[Uri] = pydantic.Field(default=None)
    """
    The project that contains this resource.
    """

    author: typing.Optional["Reference"] = pydantic.Field(default=None)
    """
    The individual, device or organization who initiated the last change.
    """

    account: typing.Optional["Reference"] = pydantic.Field(default=None)
    """
    Optional account reference that can be used for sub-project compartments.
    """

    compartment: typing.Optional[typing.List["Reference"]] = pydantic.Field(
        default=None
    )
    """
    The list of compartments containing this resource. This is readonly and is set by the server.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow", frozen=True
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


from .address import Address  # noqa: E402
from .age import Age  # noqa: E402
from .annotation import Annotation  # noqa: E402
from .attachment import Attachment  # noqa: E402
from .codeable_concept import CodeableConcept  # noqa: E402
from .coding import Coding  # noqa: E402
from .contact_detail import ContactDetail  # noqa: E402
from .contact_point import ContactPoint  # noqa: E402
from .contributor import Contributor  # noqa: E402
from .count import Count  # noqa: E402
from .data_requirement import DataRequirement  # noqa: E402
from .data_requirement_code_filter import DataRequirementCodeFilter  # noqa: E402
from .data_requirement_date_filter import DataRequirementDateFilter  # noqa: E402
from .data_requirement_sort import DataRequirementSort  # noqa: E402
from .distance import Distance  # noqa: E402
from .dosage import Dosage  # noqa: E402
from .dosage_dose_and_rate import DosageDoseAndRate  # noqa: E402
from .duration import Duration  # noqa: E402
from .expression import Expression  # noqa: E402
from .extension import Extension  # noqa: E402
from .human_name import HumanName  # noqa: E402
from .identifier import Identifier  # noqa: E402
from .money import Money  # noqa: E402
from .parameter_definition import ParameterDefinition  # noqa: E402
from .period import Period  # noqa: E402
from .quantity import Quantity  # noqa: E402
from .range import Range  # noqa: E402
from .ratio import Ratio  # noqa: E402
from .reference import Reference  # noqa: E402
from .related_artifact import RelatedArtifact  # noqa: E402
from .sampled_data import SampledData  # noqa: E402
from .signature import Signature  # noqa: E402
from .timing import Timing  # noqa: E402
from .timing_repeat import TimingRepeat  # noqa: E402
from .trigger_definition import TriggerDefinition  # noqa: E402
from .usage_context import UsageContext  # noqa: E402

update_forward_refs(Meta)
