# This file was auto-generated by Fern from our API Definition.

from .base_resource import BaseResource
from .address import Address
from .age import Age
from .annotation import Annotation
from .attachment import Attachment
from .codeable_concept import CodeableConcept
from .coding import Coding
from .contact_detail import ContactDetail
from .contact_point import ContactPoint
from .contributor import Contributor
from .count import Count
from .data_requirement import DataRequirement
from .data_requirement_code_filter import DataRequirementCodeFilter
from .data_requirement_date_filter import DataRequirementDateFilter
from .data_requirement_sort import DataRequirementSort
from .distance import Distance
from .dosage import Dosage
from .dosage_dose_and_rate import DosageDoseAndRate
from .duration import Duration
from .expression import Expression
from .extension import Extension
from .human_name import HumanName
from .identifier import Identifier
from .meta import Meta
from .money import Money
from .parameter_definition import ParameterDefinition
from .period import Period
from .quantity import Quantity
from .range import Range
from .ratio import Ratio
from .reference import Reference
from .related_artifact import RelatedArtifact
from .sampled_data import SampledData
from .signature import Signature
from .timing import Timing
from .timing_repeat import TimingRepeat
from .trigger_definition import TriggerDefinition
from .usage_context import UsageContext
import typing_extensions
import typing
from ...core.serialization import FieldMetadata
import pydantic
from .message_header_destination import MessageHeaderDestination
from .message_header_source import MessageHeaderSource
from .message_header_response import MessageHeaderResponse
from .canonical import Canonical
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class MessageHeader(BaseResource):
    """
    The header for a message exchange that is either requesting or responding to an action. The reference(s) that are the subject of the action as well as other information related to the action are typically transmitted in a bundle in which the MessageHeader resource instance is the first resource in the bundle.
    """

    resource_type: typing_extensions.Annotated[
        typing.Literal["MessageHeader"], FieldMetadata(alias="resourceType")
    ] = "MessageHeader"
    event_coding: typing_extensions.Annotated[
        typing.Optional[Coding], FieldMetadata(alias="eventCoding")
    ] = pydantic.Field(default=None)
    """
    Code that identifies the event this message represents and connects it with its definition. Events defined as part of the FHIR specification have the system value "http://terminology.hl7.org/CodeSystem/message-events". Alternatively uri to the EventDefinition.
    """

    event_uri: typing_extensions.Annotated[
        typing.Optional[str], FieldMetadata(alias="eventUri")
    ] = pydantic.Field(default=None)
    """
    Code that identifies the event this message represents and connects it with its definition. Events defined as part of the FHIR specification have the system value "http://terminology.hl7.org/CodeSystem/message-events". Alternatively uri to the EventDefinition.
    """

    destination: typing.Optional[typing.List[MessageHeaderDestination]] = (
        pydantic.Field(default=None)
    )
    """
    The destination application which the message is intended for.
    """

    sender: typing.Optional[Reference] = pydantic.Field(default=None)
    """
    Identifies the sending system to allow the use of a trust relationship.
    """

    enterer: typing.Optional[Reference] = pydantic.Field(default=None)
    """
    The person or device that performed the data entry leading to this message. When there is more than one candidate, pick the most proximal to the message. Can provide other enterers in extensions.
    """

    author: typing.Optional[Reference] = pydantic.Field(default=None)
    """
    The logical author of the message - the person or device that decided the described event should happen. When there is more than one candidate, pick the most proximal to the MessageHeader. Can provide other authors in extensions.
    """

    source: MessageHeaderSource = pydantic.Field()
    """
    The source application from which this message originated.
    """

    responsible: typing.Optional[Reference] = pydantic.Field(default=None)
    """
    The person or organization that accepts overall responsibility for the contents of the message. The implication is that the message event happened under the policies of the responsible party.
    """

    reason: typing.Optional[CodeableConcept] = pydantic.Field(default=None)
    """
    Coded indication of the cause for the event - indicates a reason for the occurrence of the event that is a focus of this message.
    """

    response: typing.Optional[MessageHeaderResponse] = pydantic.Field(default=None)
    """
    Information about the message that this message is a response to. Only present if this message is a response.
    """

    focus: typing.Optional[typing.List[Reference]] = pydantic.Field(default=None)
    """
    The actual data of the message - a reference to the root/focus class of the event.
    """

    definition: typing.Optional[Canonical] = pydantic.Field(default=None)
    """
    Permanent link to the MessageDefinition for this message.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow", frozen=True
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
