# This file was auto-generated by Fern from our API Definition.

from .base_resource import BaseResource
from .address import Address
from .age import Age
from .annotation import Annotation
from .attachment import Attachment
from .codeable_concept import CodeableConcept
from .coding import Coding
from .contact_detail import ContactDetail
from .contact_point import ContactPoint
from .contributor import Contributor
from .count import Count
from .data_requirement import DataRequirement
from .data_requirement_code_filter import DataRequirementCodeFilter
from .data_requirement_date_filter import DataRequirementDateFilter
from .data_requirement_sort import DataRequirementSort
from .distance import Distance
from .dosage import Dosage
from .dosage_dose_and_rate import DosageDoseAndRate
from .duration import Duration
from .expression import Expression
from .extension import Extension
from .human_name import HumanName
from .identifier import Identifier
from .meta import Meta
from .money import Money
from .parameter_definition import ParameterDefinition
from .period import Period
from .quantity import Quantity
from .range import Range
from .ratio import Ratio
from .reference import Reference
from .related_artifact import RelatedArtifact
from .sampled_data import SampledData
from .signature import Signature
from .timing import Timing
from .timing_repeat import TimingRepeat
from .trigger_definition import TriggerDefinition
from .usage_context import UsageContext
import typing_extensions
import typing
from ...core.serialization import FieldMetadata
from .uri import Uri
import pydantic
from .canonical import Canonical
from .message_definition_status import MessageDefinitionStatus
from .date_time import DateTime
from .markdown import Markdown
from .message_definition_category import MessageDefinitionCategory
from .message_definition_focus import MessageDefinitionFocus
from .message_definition_response_required import MessageDefinitionResponseRequired
from .message_definition_allowed_response import MessageDefinitionAllowedResponse
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class MessageDefinition(BaseResource):
    """
    Defines the characteristics of a message that can be shared between systems, including the type of event that initiates the message, the content to be transmitted and what response(s), if any, are permitted.
    """

    resource_type: typing_extensions.Annotated[
        typing.Literal["MessageDefinition"], FieldMetadata(alias="resourceType")
    ] = "MessageDefinition"
    url: typing.Optional[Uri] = pydantic.Field(default=None)
    """
    The business identifier that is used to reference the MessageDefinition and _is_ expected to be consistent from server to server.
    """

    identifier: typing.Optional[typing.List[Identifier]] = pydantic.Field(default=None)
    """
    A formal identifier that is used to identify this message definition when it is represented in other formats, or referenced in a specification, model, design or an instance.
    """

    version: typing.Optional[str] = pydantic.Field(default=None)
    """
    The identifier that is used to identify this version of the message definition when it is referenced in a specification, model, design or instance. This is an arbitrary value managed by the message definition author and is not expected to be globally unique. For example, it might be a timestamp (e.g. yyyymmdd) if a managed version is not available. There is also no expectation that versions can be placed in a lexicographical sequence.
    """

    name: typing.Optional[str] = pydantic.Field(default=None)
    """
    A natural language name identifying the message definition. This name should be usable as an identifier for the module by machine processing applications such as code generation.
    """

    title: typing.Optional[str] = pydantic.Field(default=None)
    """
    A short, descriptive, user-friendly title for the message definition.
    """

    replaces: typing.Optional[typing.List[Canonical]] = pydantic.Field(default=None)
    """
    A MessageDefinition that is superseded by this definition.
    """

    status: typing.Optional[MessageDefinitionStatus] = pydantic.Field(default=None)
    """
    The status of this message definition. Enables tracking the life-cycle of the content.
    """

    experimental: typing.Optional[bool] = pydantic.Field(default=None)
    """
    A Boolean value to indicate that this message definition is authored for testing purposes (or education/evaluation/marketing) and is not intended to be used for genuine usage.
    """

    date: typing.Optional[DateTime] = pydantic.Field(default=None)
    """
    The date (and optionally time) when the message definition was published. The date must change when the business version changes and it must change if the status code changes. In addition, it should change when the substantive content of the message definition changes.
    """

    publisher: typing.Optional[str] = pydantic.Field(default=None)
    """
    The name of the organization or individual that published the message definition.
    """

    contact: typing.Optional[typing.List[ContactDetail]] = pydantic.Field(default=None)
    """
    Contact details to assist a user in finding and communicating with the publisher.
    """

    description: typing.Optional[Markdown] = pydantic.Field(default=None)
    """
    A free text natural language description of the message definition from a consumer's perspective.
    """

    use_context: typing_extensions.Annotated[
        typing.Optional[typing.List[UsageContext]], FieldMetadata(alias="useContext")
    ] = pydantic.Field(default=None)
    """
    The content was developed with a focus and intent of supporting the contexts that are listed. These contexts may be general categories (gender, age, ...) or may be references to specific programs (insurance plans, studies, ...) and may be used to assist with indexing and searching for appropriate message definition instances.
    """

    jurisdiction: typing.Optional[typing.List[CodeableConcept]] = pydantic.Field(
        default=None
    )
    """
    A legal or geographic region in which the message definition is intended to be used.
    """

    purpose: typing.Optional[Markdown] = pydantic.Field(default=None)
    """
    Explanation of why this message definition is needed and why it has been designed as it has.
    """

    copyright: typing.Optional[Markdown] = pydantic.Field(default=None)
    """
    A copyright statement relating to the message definition and/or its contents. Copyright statements are generally legal restrictions on the use and publishing of the message definition.
    """

    base: typing.Optional[Canonical] = pydantic.Field(default=None)
    """
    The MessageDefinition that is the basis for the contents of this resource.
    """

    parent: typing.Optional[typing.List[Canonical]] = pydantic.Field(default=None)
    """
    Identifies a protocol or workflow that this MessageDefinition represents a step in.
    """

    event_coding: typing_extensions.Annotated[
        typing.Optional[Coding], FieldMetadata(alias="eventCoding")
    ] = pydantic.Field(default=None)
    """
    Event code or link to the EventDefinition.
    """

    event_uri: typing_extensions.Annotated[
        typing.Optional[str], FieldMetadata(alias="eventUri")
    ] = pydantic.Field(default=None)
    """
    Event code or link to the EventDefinition.
    """

    category: typing.Optional[MessageDefinitionCategory] = pydantic.Field(default=None)
    """
    The impact of the content of the message.
    """

    focus: typing.Optional[typing.List[MessageDefinitionFocus]] = pydantic.Field(
        default=None
    )
    """
    Identifies the resource (or resources) that are being addressed by the event. For example, the Encounter for an admit message or two Account records for a merge.
    """

    response_required: typing_extensions.Annotated[
        typing.Optional[MessageDefinitionResponseRequired],
        FieldMetadata(alias="responseRequired"),
    ] = pydantic.Field(default=None)
    """
    Declare at a message definition level whether a response is required or only upon error or success, or never.
    """

    allowed_response: typing_extensions.Annotated[
        typing.Optional[typing.List[MessageDefinitionAllowedResponse]],
        FieldMetadata(alias="allowedResponse"),
    ] = pydantic.Field(default=None)
    """
    Indicates what types of messages may be sent as an application-level response to this message.
    """

    graph: typing.Optional[typing.List[Canonical]] = pydantic.Field(default=None)
    """
    Canonical reference to a GraphDefinition. If a URL is provided, it is the canonical reference to a [[[GraphDefinition]]] that it controls what resources are to be added to the bundle when building the document. The GraphDefinition can also specify profiles that apply to the various resources.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow", frozen=True
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
