# This file was auto-generated by Fern from our API Definition.

from .base_resource import BaseResource
from .address import Address
from .age import Age
from .annotation import Annotation
from .attachment import Attachment
from .codeable_concept import CodeableConcept
from .coding import Coding
from .contact_detail import ContactDetail
from .contact_point import ContactPoint
from .contributor import Contributor
from .count import Count
from .data_requirement import DataRequirement
from .data_requirement_code_filter import DataRequirementCodeFilter
from .data_requirement_date_filter import DataRequirementDateFilter
from .data_requirement_sort import DataRequirementSort
from .distance import Distance
from .dosage import Dosage
from .dosage_dose_and_rate import DosageDoseAndRate
from .duration import Duration
from .expression import Expression
from .extension import Extension
from .human_name import HumanName
from .identifier import Identifier
from .meta import Meta
from .money import Money
from .parameter_definition import ParameterDefinition
from .period import Period
from .quantity import Quantity
from .range import Range
from .ratio import Ratio
from .reference import Reference
from .related_artifact import RelatedArtifact
from .sampled_data import SampledData
from .signature import Signature
from .timing import Timing
from .timing_repeat import TimingRepeat
from .trigger_definition import TriggerDefinition
from .usage_context import UsageContext
import typing_extensions
import typing
from ...core.serialization import FieldMetadata
import pydantic
from .medicinal_product_pharmaceutical_characteristics import (
    MedicinalProductPharmaceuticalCharacteristics,
)
from .medicinal_product_pharmaceutical_route_of_administration import (
    MedicinalProductPharmaceuticalRouteOfAdministration,
)
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class MedicinalProductPharmaceutical(BaseResource):
    """
    A pharmaceutical product described in terms of its composition and dose form.
    """

    resource_type: typing_extensions.Annotated[
        typing.Literal["MedicinalProductPharmaceutical"],
        FieldMetadata(alias="resourceType"),
    ] = "MedicinalProductPharmaceutical"
    identifier: typing.Optional[typing.List[Identifier]] = pydantic.Field(default=None)
    """
    An identifier for the pharmaceutical medicinal product.
    """

    administrable_dose_form: typing_extensions.Annotated[
        CodeableConcept, FieldMetadata(alias="administrableDoseForm")
    ] = pydantic.Field()
    """
    The administrable dose form, after necessary reconstitution.
    """

    unit_of_presentation: typing_extensions.Annotated[
        typing.Optional[CodeableConcept], FieldMetadata(alias="unitOfPresentation")
    ] = pydantic.Field(default=None)
    """
    Todo.
    """

    ingredient: typing.Optional[typing.List[Reference]] = pydantic.Field(default=None)
    """
    Ingredient.
    """

    device: typing.Optional[typing.List[Reference]] = pydantic.Field(default=None)
    """
    Accompanying device.
    """

    characteristics: typing.Optional[
        typing.List[MedicinalProductPharmaceuticalCharacteristics]
    ] = pydantic.Field(default=None)
    """
    Characteristics e.g. a products onset of action.
    """

    route_of_administration: typing_extensions.Annotated[
        typing.List[MedicinalProductPharmaceuticalRouteOfAdministration],
        FieldMetadata(alias="routeOfAdministration"),
    ] = pydantic.Field()
    """
    The path by which the pharmaceutical product is taken into or makes contact with the body.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow", frozen=True
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
