# This file was auto-generated by Fern from our API Definition.

from .base_resource import BaseResource
from .address import Address
from .age import Age
from .annotation import Annotation
from .attachment import Attachment
from .codeable_concept import CodeableConcept
from .coding import Coding
from .contact_detail import ContactDetail
from .contact_point import ContactPoint
from .contributor import Contributor
from .count import Count
from .data_requirement import DataRequirement
from .data_requirement_code_filter import DataRequirementCodeFilter
from .data_requirement_date_filter import DataRequirementDateFilter
from .data_requirement_sort import DataRequirementSort
from .distance import Distance
from .dosage import Dosage
from .dosage_dose_and_rate import DosageDoseAndRate
from .duration import Duration
from .expression import Expression
from .extension import Extension
from .human_name import HumanName
from .identifier import Identifier
from .meta import Meta
from .money import Money
from .parameter_definition import ParameterDefinition
from .period import Period
from .quantity import Quantity
from .range import Range
from .ratio import Ratio
from .reference import Reference
from .related_artifact import RelatedArtifact
from .sampled_data import SampledData
from .signature import Signature
from .timing import Timing
from .timing_repeat import TimingRepeat
from .trigger_definition import TriggerDefinition
from .usage_context import UsageContext
from .medicinal_product_packaged_package_item import MedicinalProductPackagedPackageItem
import typing_extensions
import typing
from ...core.serialization import FieldMetadata
import pydantic
from .marketing_status import MarketingStatus
from .medicinal_product_packaged_batch_identifier import (
    MedicinalProductPackagedBatchIdentifier,
)
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class MedicinalProductPackaged(BaseResource):
    """
    A medicinal product in a container or package.
    """

    resource_type: typing_extensions.Annotated[
        typing.Literal["MedicinalProductPackaged"], FieldMetadata(alias="resourceType")
    ] = "MedicinalProductPackaged"
    identifier: typing.Optional[typing.List[Identifier]] = pydantic.Field(default=None)
    """
    Unique identifier.
    """

    subject: typing.Optional[typing.List[Reference]] = pydantic.Field(default=None)
    """
    The product with this is a pack for.
    """

    description: typing.Optional[str] = pydantic.Field(default=None)
    """
    Textual description.
    """

    legal_status_of_supply: typing_extensions.Annotated[
        typing.Optional[CodeableConcept], FieldMetadata(alias="legalStatusOfSupply")
    ] = pydantic.Field(default=None)
    """
    The legal status of supply of the medicinal product as classified by the regulator.
    """

    marketing_status: typing_extensions.Annotated[
        typing.Optional[typing.List[MarketingStatus]],
        FieldMetadata(alias="marketingStatus"),
    ] = pydantic.Field(default=None)
    """
    Marketing information.
    """

    marketing_authorization: typing_extensions.Annotated[
        typing.Optional[Reference], FieldMetadata(alias="marketingAuthorization")
    ] = pydantic.Field(default=None)
    """
    Manufacturer of this Package Item.
    """

    manufacturer: typing.Optional[typing.List[Reference]] = pydantic.Field(default=None)
    """
    Manufacturer of this Package Item.
    """

    batch_identifier: typing_extensions.Annotated[
        typing.Optional[typing.List[MedicinalProductPackagedBatchIdentifier]],
        FieldMetadata(alias="batchIdentifier"),
    ] = pydantic.Field(default=None)
    """
    Batch numbering.
    """

    package_item: typing_extensions.Annotated[
        typing.List[MedicinalProductPackagedPackageItem],
        FieldMetadata(alias="packageItem"),
    ] = pydantic.Field()
    """
    A packaging item, as a contained for medicine, possibly with other packaging items within.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow", frozen=True
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
