# This file was auto-generated by Fern from our API Definition.

from .base_resource import BaseResource
from .address import Address
from .age import Age
from .annotation import Annotation
from .attachment import Attachment
from .codeable_concept import CodeableConcept
from .coding import Coding
from .contact_detail import ContactDetail
from .contact_point import ContactPoint
from .contributor import Contributor
from .count import Count
from .data_requirement import DataRequirement
from .data_requirement_code_filter import DataRequirementCodeFilter
from .data_requirement_date_filter import DataRequirementDateFilter
from .data_requirement_sort import DataRequirementSort
from .distance import Distance
from .dosage import Dosage
from .dosage_dose_and_rate import DosageDoseAndRate
from .duration import Duration
from .expression import Expression
from .extension import Extension
from .human_name import HumanName
from .identifier import Identifier
from .meta import Meta
from .money import Money
from .parameter_definition import ParameterDefinition
from .period import Period
from .quantity import Quantity
from .range import Range
from .ratio import Ratio
from .reference import Reference
from .related_artifact import RelatedArtifact
from .sampled_data import SampledData
from .signature import Signature
from .timing import Timing
from .timing_repeat import TimingRepeat
from .trigger_definition import TriggerDefinition
from .usage_context import UsageContext
import typing_extensions
import typing
from ...core.serialization import FieldMetadata
import pydantic
from .prod_characteristic import ProdCharacteristic
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class MedicinalProductManufactured(BaseResource):
    """
    The manufactured item as contained in the packaged medicinal product.
    """

    resource_type: typing_extensions.Annotated[
        typing.Literal["MedicinalProductManufactured"],
        FieldMetadata(alias="resourceType"),
    ] = "MedicinalProductManufactured"
    manufactured_dose_form: typing_extensions.Annotated[
        CodeableConcept, FieldMetadata(alias="manufacturedDoseForm")
    ] = pydantic.Field()
    """
    Dose form as manufactured and before any transformation into the pharmaceutical product.
    """

    unit_of_presentation: typing_extensions.Annotated[
        typing.Optional[CodeableConcept], FieldMetadata(alias="unitOfPresentation")
    ] = pydantic.Field(default=None)
    """
    The “real world” units in which the quantity of the manufactured item is described.
    """

    quantity: Quantity = pydantic.Field()
    """
    The quantity or "count number" of the manufactured item.
    """

    manufacturer: typing.Optional[typing.List[Reference]] = pydantic.Field(default=None)
    """
    Manufacturer of the item (Note that this should be named "manufacturer" but it currently causes technical issues).
    """

    ingredient: typing.Optional[typing.List[Reference]] = pydantic.Field(default=None)
    """
    Ingredient.
    """

    physical_characteristics: typing_extensions.Annotated[
        typing.Optional[ProdCharacteristic],
        FieldMetadata(alias="physicalCharacteristics"),
    ] = pydantic.Field(default=None)
    """
    Dimensions, color etc.
    """

    other_characteristics: typing_extensions.Annotated[
        typing.Optional[typing.List[CodeableConcept]],
        FieldMetadata(alias="otherCharacteristics"),
    ] = pydantic.Field(default=None)
    """
    Other codeable characteristics.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow", frozen=True
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
