# This file was auto-generated by Fern from our API Definition.

from .base_resource import BaseResource
from .address import Address
from .age import Age
from .annotation import Annotation
from .attachment import Attachment
from .codeable_concept import CodeableConcept
from .coding import Coding
from .contact_detail import ContactDetail
from .contact_point import ContactPoint
from .contributor import Contributor
from .count import Count
from .data_requirement import DataRequirement
from .data_requirement_code_filter import DataRequirementCodeFilter
from .data_requirement_date_filter import DataRequirementDateFilter
from .data_requirement_sort import DataRequirementSort
from .distance import Distance
from .dosage import Dosage
from .dosage_dose_and_rate import DosageDoseAndRate
from .duration import Duration
from .expression import Expression
from .extension import Extension
from .human_name import HumanName
from .identifier import Identifier
from .meta import Meta
from .money import Money
from .parameter_definition import ParameterDefinition
from .period import Period
from .quantity import Quantity
from .range import Range
from .ratio import Ratio
from .reference import Reference
from .related_artifact import RelatedArtifact
from .sampled_data import SampledData
from .signature import Signature
from .timing import Timing
from .timing_repeat import TimingRepeat
from .trigger_definition import TriggerDefinition
from .usage_context import UsageContext
import typing_extensions
import typing
from ...core.serialization import FieldMetadata
import pydantic
from .medicinal_product_interaction_interactant import (
    MedicinalProductInteractionInteractant,
)
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class MedicinalProductInteraction(BaseResource):
    """
    The interactions of the medicinal product with other medicinal products, or other forms of interactions.
    """

    resource_type: typing_extensions.Annotated[
        typing.Literal["MedicinalProductInteraction"],
        FieldMetadata(alias="resourceType"),
    ] = "MedicinalProductInteraction"
    subject: typing.Optional[typing.List[Reference]] = pydantic.Field(default=None)
    """
    The medication for which this is a described interaction.
    """

    description: typing.Optional[str] = pydantic.Field(default=None)
    """
    The interaction described.
    """

    interactant: typing.Optional[
        typing.List[MedicinalProductInteractionInteractant]
    ] = pydantic.Field(default=None)
    """
    The specific medication, food or laboratory test that interacts.
    """

    type: typing.Optional[CodeableConcept] = pydantic.Field(default=None)
    """
    The type of the interaction e.g. drug-drug interaction, drug-food interaction, drug-lab test interaction.
    """

    effect: typing.Optional[CodeableConcept] = pydantic.Field(default=None)
    """
    The effect of the interaction, for example "reduced gastric absorption of primary medication".
    """

    incidence: typing.Optional[CodeableConcept] = pydantic.Field(default=None)
    """
    The incidence of the interaction, e.g. theoretical, observed.
    """

    management: typing.Optional[CodeableConcept] = pydantic.Field(default=None)
    """
    Actions for managing the interaction.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow", frozen=True
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
