# This file was auto-generated by Fern from our API Definition.

from .base_resource import BaseResource
from .address import Address
from .age import Age
from .annotation import Annotation
from .attachment import Attachment
from .codeable_concept import CodeableConcept
from .coding import Coding
from .contact_detail import ContactDetail
from .contact_point import ContactPoint
from .contributor import Contributor
from .count import Count
from .data_requirement import DataRequirement
from .data_requirement_code_filter import DataRequirementCodeFilter
from .data_requirement_date_filter import DataRequirementDateFilter
from .data_requirement_sort import DataRequirementSort
from .distance import Distance
from .dosage import Dosage
from .dosage_dose_and_rate import DosageDoseAndRate
from .duration import Duration
from .expression import Expression
from .extension import Extension
from .human_name import HumanName
from .identifier import Identifier
from .meta import Meta
from .money import Money
from .parameter_definition import ParameterDefinition
from .period import Period
from .quantity import Quantity
from .range import Range
from .ratio import Ratio
from .reference import Reference
from .related_artifact import RelatedArtifact
from .sampled_data import SampledData
from .signature import Signature
from .timing import Timing
from .timing_repeat import TimingRepeat
from .trigger_definition import TriggerDefinition
from .usage_context import UsageContext
import typing_extensions
import typing
from ...core.serialization import FieldMetadata
import pydantic
from .medicinal_product_contraindication_other_therapy import (
    MedicinalProductContraindicationOtherTherapy,
)
from .population import Population
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class MedicinalProductContraindication(BaseResource):
    """
    The clinical particulars - indications, contraindications etc. of a medicinal product, including for regulatory purposes.
    """

    resource_type: typing_extensions.Annotated[
        typing.Literal["MedicinalProductContraindication"],
        FieldMetadata(alias="resourceType"),
    ] = "MedicinalProductContraindication"
    subject: typing.Optional[typing.List[Reference]] = pydantic.Field(default=None)
    """
    The medication for which this is an indication.
    """

    disease: typing.Optional[CodeableConcept] = pydantic.Field(default=None)
    """
    The disease, symptom or procedure for the contraindication.
    """

    disease_status: typing_extensions.Annotated[
        typing.Optional[CodeableConcept], FieldMetadata(alias="diseaseStatus")
    ] = pydantic.Field(default=None)
    """
    The status of the disease or symptom for the contraindication.
    """

    comorbidity: typing.Optional[typing.List[CodeableConcept]] = pydantic.Field(
        default=None
    )
    """
    A comorbidity (concurrent condition) or coinfection.
    """

    therapeutic_indication: typing_extensions.Annotated[
        typing.Optional[typing.List[Reference]],
        FieldMetadata(alias="therapeuticIndication"),
    ] = pydantic.Field(default=None)
    """
    Information about the use of the medicinal product in relation to other therapies as part of the indication.
    """

    other_therapy: typing_extensions.Annotated[
        typing.Optional[typing.List[MedicinalProductContraindicationOtherTherapy]],
        FieldMetadata(alias="otherTherapy"),
    ] = pydantic.Field(default=None)
    """
    Information about the use of the medicinal product in relation to other therapies described as part of the indication.
    """

    population: typing.Optional[typing.List[Population]] = pydantic.Field(default=None)
    """
    The population group to which this applies.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow", frozen=True
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
