# This file was auto-generated by Fern from our API Definition.

from .base_resource import BaseResource
from .address import Address
from .age import Age
from .annotation import Annotation
from .attachment import Attachment
from .codeable_concept import CodeableConcept
from .coding import Coding
from .contact_detail import ContactDetail
from .contact_point import ContactPoint
from .contributor import Contributor
from .count import Count
from .data_requirement import DataRequirement
from .data_requirement_code_filter import DataRequirementCodeFilter
from .data_requirement_date_filter import DataRequirementDateFilter
from .data_requirement_sort import DataRequirementSort
from .distance import Distance
from .dosage import Dosage
from .dosage_dose_and_rate import DosageDoseAndRate
from .duration import Duration
from .expression import Expression
from .extension import Extension
from .human_name import HumanName
from .identifier import Identifier
from .meta import Meta
from .money import Money
from .parameter_definition import ParameterDefinition
from .period import Period
from .quantity import Quantity
from .range import Range
from .ratio import Ratio
from .reference import Reference
from .related_artifact import RelatedArtifact
from .sampled_data import SampledData
from .signature import Signature
from .timing import Timing
from .timing_repeat import TimingRepeat
from .trigger_definition import TriggerDefinition
from .usage_context import UsageContext
from .medicinal_product_authorization_procedure import (
    MedicinalProductAuthorizationProcedure,
)
import typing_extensions
import typing
from ...core.serialization import FieldMetadata
import pydantic
from .date_time import DateTime
from .medicinal_product_authorization_jurisdictional_authorization import (
    MedicinalProductAuthorizationJurisdictionalAuthorization,
)
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class MedicinalProductAuthorization(BaseResource):
    """
    The regulatory authorization of a medicinal product.
    """

    resource_type: typing_extensions.Annotated[
        typing.Literal["MedicinalProductAuthorization"],
        FieldMetadata(alias="resourceType"),
    ] = "MedicinalProductAuthorization"
    identifier: typing.Optional[typing.List[Identifier]] = pydantic.Field(default=None)
    """
    Business identifier for the marketing authorization, as assigned by a regulator.
    """

    subject: typing.Optional[Reference] = pydantic.Field(default=None)
    """
    The medicinal product that is being authorized.
    """

    country: typing.Optional[typing.List[CodeableConcept]] = pydantic.Field(
        default=None
    )
    """
    The country in which the marketing authorization has been granted.
    """

    jurisdiction: typing.Optional[typing.List[CodeableConcept]] = pydantic.Field(
        default=None
    )
    """
    Jurisdiction within a country.
    """

    status: typing.Optional[CodeableConcept] = pydantic.Field(default=None)
    """
    The status of the marketing authorization.
    """

    status_date: typing_extensions.Annotated[
        typing.Optional[DateTime], FieldMetadata(alias="statusDate")
    ] = pydantic.Field(default=None)
    """
    The date at which the given status has become applicable.
    """

    restore_date: typing_extensions.Annotated[
        typing.Optional[DateTime], FieldMetadata(alias="restoreDate")
    ] = pydantic.Field(default=None)
    """
    The date when a suspended the marketing or the marketing authorization of the product is anticipated to be restored.
    """

    validity_period: typing_extensions.Annotated[
        typing.Optional[Period], FieldMetadata(alias="validityPeriod")
    ] = pydantic.Field(default=None)
    """
    The beginning of the time period in which the marketing authorization is in the specific status shall be specified A complete date consisting of day, month and year shall be specified using the ISO 8601 date format.
    """

    data_exclusivity_period: typing_extensions.Annotated[
        typing.Optional[Period], FieldMetadata(alias="dataExclusivityPeriod")
    ] = pydantic.Field(default=None)
    """
    A period of time after authorization before generic product applicatiosn can be submitted.
    """

    date_of_first_authorization: typing_extensions.Annotated[
        typing.Optional[DateTime], FieldMetadata(alias="dateOfFirstAuthorization")
    ] = pydantic.Field(default=None)
    """
    The date when the first authorization was granted by a Medicines Regulatory Agency.
    """

    international_birth_date: typing_extensions.Annotated[
        typing.Optional[DateTime], FieldMetadata(alias="internationalBirthDate")
    ] = pydantic.Field(default=None)
    """
    Date of first marketing authorization for a company's new medicinal product in any country in the World.
    """

    legal_basis: typing_extensions.Annotated[
        typing.Optional[CodeableConcept], FieldMetadata(alias="legalBasis")
    ] = pydantic.Field(default=None)
    """
    The legal framework against which this authorization is granted.
    """

    jurisdictional_authorization: typing_extensions.Annotated[
        typing.Optional[
            typing.List[MedicinalProductAuthorizationJurisdictionalAuthorization]
        ],
        FieldMetadata(alias="jurisdictionalAuthorization"),
    ] = pydantic.Field(default=None)
    """
    Authorization in areas within a country.
    """

    holder: typing.Optional[Reference] = pydantic.Field(default=None)
    """
    Marketing Authorization Holder.
    """

    regulator: typing.Optional[Reference] = pydantic.Field(default=None)
    """
    Medicines Regulatory Agency.
    """

    procedure: typing.Optional[MedicinalProductAuthorizationProcedure] = pydantic.Field(
        default=None
    )
    """
    The regulatory procedure for granting or amending a marketing authorization.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow", frozen=True
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
