# This file was auto-generated by Fern from our API Definition.

from .base_resource import BaseResource
from .address import Address
from .age import Age
from .annotation import Annotation
from .attachment import Attachment
from .codeable_concept import CodeableConcept
from .coding import Coding
from .contact_detail import ContactDetail
from .contact_point import ContactPoint
from .contributor import Contributor
from .count import Count
from .data_requirement import DataRequirement
from .data_requirement_code_filter import DataRequirementCodeFilter
from .data_requirement_date_filter import DataRequirementDateFilter
from .data_requirement_sort import DataRequirementSort
from .distance import Distance
from .dosage import Dosage
from .dosage_dose_and_rate import DosageDoseAndRate
from .duration import Duration
from .expression import Expression
from .extension import Extension
from .human_name import HumanName
from .identifier import Identifier
from .meta import Meta
from .money import Money
from .parameter_definition import ParameterDefinition
from .period import Period
from .quantity import Quantity
from .range import Range
from .ratio import Ratio
from .reference import Reference
from .related_artifact import RelatedArtifact
from .sampled_data import SampledData
from .signature import Signature
from .timing import Timing
from .timing_repeat import TimingRepeat
from .trigger_definition import TriggerDefinition
from .usage_context import UsageContext
import typing_extensions
import typing
from ...core.serialization import FieldMetadata
import pydantic
from .marketing_status import MarketingStatus
from .medicinal_product_name import MedicinalProductName
from .medicinal_product_manufacturing_business_operation import (
    MedicinalProductManufacturingBusinessOperation,
)
from .medicinal_product_special_designation import MedicinalProductSpecialDesignation
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class MedicinalProduct(BaseResource):
    """
    Detailed definition of a medicinal product, typically for uses other than direct patient care (e.g. regulatory use).
    """

    resource_type: typing_extensions.Annotated[
        typing.Literal["MedicinalProduct"], FieldMetadata(alias="resourceType")
    ] = "MedicinalProduct"
    identifier: typing.Optional[typing.List[Identifier]] = pydantic.Field(default=None)
    """
    Business identifier for this product. Could be an MPID.
    """

    type: typing.Optional[CodeableConcept] = pydantic.Field(default=None)
    """
    Regulatory type, e.g. Investigational or Authorized.
    """

    domain: typing.Optional[Coding] = pydantic.Field(default=None)
    """
    If this medicine applies to human or veterinary uses.
    """

    combined_pharmaceutical_dose_form: typing_extensions.Annotated[
        typing.Optional[CodeableConcept],
        FieldMetadata(alias="combinedPharmaceuticalDoseForm"),
    ] = pydantic.Field(default=None)
    """
    The dose form for a single part product, or combined form of a multiple part product.
    """

    legal_status_of_supply: typing_extensions.Annotated[
        typing.Optional[CodeableConcept], FieldMetadata(alias="legalStatusOfSupply")
    ] = pydantic.Field(default=None)
    """
    The legal status of supply of the medicinal product as classified by the regulator.
    """

    additional_monitoring_indicator: typing_extensions.Annotated[
        typing.Optional[CodeableConcept],
        FieldMetadata(alias="additionalMonitoringIndicator"),
    ] = pydantic.Field(default=None)
    """
    Whether the Medicinal Product is subject to additional monitoring for regulatory reasons.
    """

    special_measures: typing_extensions.Annotated[
        typing.Optional[typing.List[str]], FieldMetadata(alias="specialMeasures")
    ] = pydantic.Field(default=None)
    """
    Whether the Medicinal Product is subject to special measures for regulatory reasons.
    """

    paediatric_use_indicator: typing_extensions.Annotated[
        typing.Optional[CodeableConcept], FieldMetadata(alias="paediatricUseIndicator")
    ] = pydantic.Field(default=None)
    """
    If authorised for use in children.
    """

    product_classification: typing_extensions.Annotated[
        typing.Optional[typing.List[CodeableConcept]],
        FieldMetadata(alias="productClassification"),
    ] = pydantic.Field(default=None)
    """
    Allows the product to be classified by various systems.
    """

    marketing_status: typing_extensions.Annotated[
        typing.Optional[typing.List[MarketingStatus]],
        FieldMetadata(alias="marketingStatus"),
    ] = pydantic.Field(default=None)
    """
    Marketing status of the medicinal product, in contrast to marketing authorizaton.
    """

    pharmaceutical_product: typing_extensions.Annotated[
        typing.Optional[typing.List[Reference]],
        FieldMetadata(alias="pharmaceuticalProduct"),
    ] = pydantic.Field(default=None)
    """
    Pharmaceutical aspects of product.
    """

    packaged_medicinal_product: typing_extensions.Annotated[
        typing.Optional[typing.List[Reference]],
        FieldMetadata(alias="packagedMedicinalProduct"),
    ] = pydantic.Field(default=None)
    """
    Package representation for the product.
    """

    attached_document: typing_extensions.Annotated[
        typing.Optional[typing.List[Reference]], FieldMetadata(alias="attachedDocument")
    ] = pydantic.Field(default=None)
    """
    Supporting documentation, typically for regulatory submission.
    """

    master_file: typing_extensions.Annotated[
        typing.Optional[typing.List[Reference]], FieldMetadata(alias="masterFile")
    ] = pydantic.Field(default=None)
    """
    A master file for to the medicinal product (e.g. Pharmacovigilance System Master File).
    """

    contact: typing.Optional[typing.List[Reference]] = pydantic.Field(default=None)
    """
    A product specific contact, person (in a role), or an organization.
    """

    clinical_trial: typing_extensions.Annotated[
        typing.Optional[typing.List[Reference]], FieldMetadata(alias="clinicalTrial")
    ] = pydantic.Field(default=None)
    """
    Clinical trials or studies that this product is involved in.
    """

    name: typing.List[MedicinalProductName] = pydantic.Field()
    """
    The product's name, including full name and possibly coded parts.
    """

    cross_reference: typing_extensions.Annotated[
        typing.Optional[typing.List[Identifier]], FieldMetadata(alias="crossReference")
    ] = pydantic.Field(default=None)
    """
    Reference to another product, e.g. for linking authorised to investigational product.
    """

    manufacturing_business_operation: typing_extensions.Annotated[
        typing.Optional[typing.List[MedicinalProductManufacturingBusinessOperation]],
        FieldMetadata(alias="manufacturingBusinessOperation"),
    ] = pydantic.Field(default=None)
    """
    An operation applied to the product, for manufacturing or adminsitrative purpose.
    """

    special_designation: typing_extensions.Annotated[
        typing.Optional[typing.List[MedicinalProductSpecialDesignation]],
        FieldMetadata(alias="specialDesignation"),
    ] = pydantic.Field(default=None)
    """
    Indicates if the medicinal product has an orphan designation for the treatment of a rare disease.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow", frozen=True
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
