# This file was auto-generated by Fern from our API Definition.

from .base_resource import BaseResource
from .address import Address
from .age import Age
from .annotation import Annotation
from .attachment import Attachment
from .codeable_concept import CodeableConcept
from .coding import Coding
from .contact_detail import ContactDetail
from .contact_point import ContactPoint
from .contributor import Contributor
from .count import Count
from .data_requirement import DataRequirement
from .data_requirement_code_filter import DataRequirementCodeFilter
from .data_requirement_date_filter import DataRequirementDateFilter
from .data_requirement_sort import DataRequirementSort
from .distance import Distance
from .dosage import Dosage
from .dosage_dose_and_rate import DosageDoseAndRate
from .duration import Duration
from .expression import Expression
from .extension import Extension
from .human_name import HumanName
from .identifier import Identifier
from .meta import Meta
from .money import Money
from .parameter_definition import ParameterDefinition
from .period import Period
from .quantity import Quantity
from .range import Range
from .ratio import Ratio
from .reference import Reference
from .related_artifact import RelatedArtifact
from .sampled_data import SampledData
from .signature import Signature
from .timing import Timing
from .timing_repeat import TimingRepeat
from .trigger_definition import TriggerDefinition
from .usage_context import UsageContext
import typing_extensions
import typing
from ...core.serialization import FieldMetadata
import pydantic
from .code import Code
from .date_time import DateTime
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class MedicationStatement(BaseResource):
    """
    A record of a medication that is being consumed by a patient. A MedicationStatement may indicate that the patient may be taking the medication now or has taken the medication in the past or will be taking the medication in the future. The source of this information can be the patient, significant other (such as a family member or spouse), or a clinician. A common scenario where this information is captured is during the history taking process during a patient visit or stay. The medication information may come from sources such as the patient's memory, from a prescription bottle, or from a list of medications the patient, clinician or other party maintains. The primary difference between a medication statement and a medication administration is that the medication administration has complete administration information and is based on actual administration information from the person who administered the medication. A medication statement is often, if not always, less specific. There is no required date/time when the medication was administered, in fact we only know that a source has reported the patient is taking this medication, where details such as time, quantity, or rate or even medication product may be incomplete or missing or less precise. As stated earlier, the medication statement information may come from the patient's memory, from a prescription bottle or from a list of medications the patient, clinician or other party maintains. Medication administration is more formal and is not missing detailed information.
    """

    resource_type: typing_extensions.Annotated[
        typing.Literal["MedicationStatement"], FieldMetadata(alias="resourceType")
    ] = "MedicationStatement"
    identifier: typing.Optional[typing.List[Identifier]] = pydantic.Field(default=None)
    """
    Identifiers associated with this Medication Statement that are defined by business processes and/or used to refer to it when a direct URL reference to the resource itself is not appropriate. They are business identifiers assigned to this resource by the performer or other systems and remain constant as the resource is updated and propagates from server to server.
    """

    based_on: typing_extensions.Annotated[
        typing.Optional[typing.List[Reference]], FieldMetadata(alias="basedOn")
    ] = pydantic.Field(default=None)
    """
    A plan, proposal or order that is fulfilled in whole or in part by this event.
    """

    part_of: typing_extensions.Annotated[
        typing.Optional[typing.List[Reference]], FieldMetadata(alias="partOf")
    ] = pydantic.Field(default=None)
    """
    A larger event of which this particular event is a component or step.
    """

    status: typing.Optional[Code] = pydantic.Field(default=None)
    """
    A code representing the patient or other source's judgment about the state of the medication used that this statement is about. Generally, this will be active or completed.
    """

    status_reason: typing_extensions.Annotated[
        typing.Optional[typing.List[CodeableConcept]],
        FieldMetadata(alias="statusReason"),
    ] = pydantic.Field(default=None)
    """
    Captures the reason for the current state of the MedicationStatement.
    """

    category: typing.Optional[CodeableConcept] = pydantic.Field(default=None)
    """
    Indicates where the medication is expected to be consumed or administered.
    """

    medication_codeable_concept: typing_extensions.Annotated[
        typing.Optional[CodeableConcept],
        FieldMetadata(alias="medicationCodeableConcept"),
    ] = pydantic.Field(default=None)
    """
    Identifies the medication being administered. This is either a link to a resource representing the details of the medication or a simple attribute carrying a code that identifies the medication from a known list of medications.
    """

    medication_reference: typing_extensions.Annotated[
        typing.Optional[Reference], FieldMetadata(alias="medicationReference")
    ] = pydantic.Field(default=None)
    """
    Identifies the medication being administered. This is either a link to a resource representing the details of the medication or a simple attribute carrying a code that identifies the medication from a known list of medications.
    """

    subject: Reference = pydantic.Field()
    """
    The person, animal or group who is/was taking the medication.
    """

    context: typing.Optional[Reference] = pydantic.Field(default=None)
    """
    The encounter or episode of care that establishes the context for this MedicationStatement.
    """

    effective_date_time: typing_extensions.Annotated[
        typing.Optional[str], FieldMetadata(alias="effectiveDateTime")
    ] = pydantic.Field(default=None)
    """
    The interval of time during which it is being asserted that the patient is/was/will be taking the medication (or was not taking, when the MedicationStatement.taken element is No).
    """

    effective_period: typing_extensions.Annotated[
        typing.Optional[Period], FieldMetadata(alias="effectivePeriod")
    ] = pydantic.Field(default=None)
    """
    The interval of time during which it is being asserted that the patient is/was/will be taking the medication (or was not taking, when the MedicationStatement.taken element is No).
    """

    date_asserted: typing_extensions.Annotated[
        typing.Optional[DateTime], FieldMetadata(alias="dateAsserted")
    ] = pydantic.Field(default=None)
    """
    The date when the medication statement was asserted by the information source.
    """

    information_source: typing_extensions.Annotated[
        typing.Optional[Reference], FieldMetadata(alias="informationSource")
    ] = pydantic.Field(default=None)
    """
    The person or organization that provided the information about the taking of this medication. Note: Use derivedFrom when a MedicationStatement is derived from other resources, e.g. Claim or MedicationRequest.
    """

    derived_from: typing_extensions.Annotated[
        typing.Optional[typing.List[Reference]], FieldMetadata(alias="derivedFrom")
    ] = pydantic.Field(default=None)
    """
    Allows linking the MedicationStatement to the underlying MedicationRequest, or to other information that supports or is used to derive the MedicationStatement.
    """

    reason_code: typing_extensions.Annotated[
        typing.Optional[typing.List[CodeableConcept]], FieldMetadata(alias="reasonCode")
    ] = pydantic.Field(default=None)
    """
    A reason for why the medication is being/was taken.
    """

    reason_reference: typing_extensions.Annotated[
        typing.Optional[typing.List[Reference]], FieldMetadata(alias="reasonReference")
    ] = pydantic.Field(default=None)
    """
    Condition or observation that supports why the medication is being/was taken.
    """

    note: typing.Optional[typing.List[Annotation]] = pydantic.Field(default=None)
    """
    Provides extra information about the medication statement that is not conveyed by the other attributes.
    """

    dosage: typing.Optional[typing.List[Dosage]] = pydantic.Field(default=None)
    """
    Indicates how the medication is/was or should be taken by the patient.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow", frozen=True
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
