# This file was auto-generated by Fern from our API Definition.

from ...core.pydantic_utilities import UniversalBaseModel
from .address import Address
from .age import Age
from .annotation import Annotation
from .attachment import Attachment
from .codeable_concept import CodeableConcept
from .coding import Coding
from .contact_detail import ContactDetail
from .contact_point import ContactPoint
from .contributor import Contributor
from .count import Count
from .data_requirement import DataRequirement
from .data_requirement_code_filter import DataRequirementCodeFilter
from .data_requirement_date_filter import DataRequirementDateFilter
from .data_requirement_sort import DataRequirementSort
from .distance import Distance
from .dosage import Dosage
from .dosage_dose_and_rate import DosageDoseAndRate
from .duration import Duration
from .expression import Expression
from .extension import Extension
from .human_name import HumanName
from .identifier import Identifier
from .meta import Meta
from .money import Money
from .parameter_definition import ParameterDefinition
from .period import Period
from .quantity import Quantity
from .range import Range
from .ratio import Ratio
from .reference import Reference
from .related_artifact import RelatedArtifact
from .sampled_data import SampledData
from .signature import Signature
from .timing import Timing
from .timing_repeat import TimingRepeat
from .trigger_definition import TriggerDefinition
from .usage_context import UsageContext
import typing
import pydantic
import typing_extensions
from ...core.serialization import FieldMetadata
from .medication_request_initial_fill import MedicationRequestInitialFill
from .unsigned_int import UnsignedInt
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class MedicationRequestDispenseRequest(UniversalBaseModel):
    """
    An order or request for both supply of the medication and the instructions for administration of the medication to a patient. The resource is called "MedicationRequest" rather than "MedicationPrescription" or "MedicationOrder" to generalize the use across inpatient and outpatient settings, including care plans, etc., and to harmonize with workflow patterns.
    """

    id: typing.Optional[str] = pydantic.Field(default=None)
    """
    Unique id for the element within a resource (for internal references). This may be any string value that does not contain spaces.
    """

    extension: typing.Optional[typing.List[Extension]] = pydantic.Field(default=None)
    """
    May be used to represent additional information that is not part of the basic definition of the element. To make the use of extensions safe and manageable, there is a strict set of governance applied to the definition and use of extensions. Though any implementer can define an extension, there is a set of requirements that SHALL be met as part of the definition of the extension.
    """

    modifier_extension: typing_extensions.Annotated[
        typing.Optional[typing.List[Extension]],
        FieldMetadata(alias="modifierExtension"),
    ] = pydantic.Field(default=None)
    """
    May be used to represent additional information that is not part of the basic definition of the element and that modifies the understanding of the element in which it is contained and/or the understanding of the containing element's descendants. Usually modifier elements provide negation or qualification. To make the use of extensions safe and manageable, there is a strict set of governance applied to the definition and use of extensions. Though any implementer can define an extension, there is a set of requirements that SHALL be met as part of the definition of the extension. Applications processing a resource are required to check for modifier extensions. Modifier extensions SHALL NOT change the meaning of any elements on Resource or DomainResource (including cannot change the meaning of modifierExtension itself).
    """

    initial_fill: typing_extensions.Annotated[
        typing.Optional[MedicationRequestInitialFill],
        FieldMetadata(alias="initialFill"),
    ] = pydantic.Field(default=None)
    """
    Indicates the quantity or duration for the first dispense of the medication.
    """

    dispense_interval: typing_extensions.Annotated[
        typing.Optional[Duration], FieldMetadata(alias="dispenseInterval")
    ] = pydantic.Field(default=None)
    """
    The minimum period of time that must occur between dispenses of the medication.
    """

    validity_period: typing_extensions.Annotated[
        typing.Optional[Period], FieldMetadata(alias="validityPeriod")
    ] = pydantic.Field(default=None)
    """
    This indicates the validity period of a prescription (stale dating the Prescription).
    """

    number_of_repeats_allowed: typing_extensions.Annotated[
        typing.Optional[UnsignedInt], FieldMetadata(alias="numberOfRepeatsAllowed")
    ] = pydantic.Field(default=None)
    """
    An integer indicating the number of times, in addition to the original dispense, (aka refills or repeats) that the patient can receive the prescribed medication. Usage Notes: This integer does not include the original order dispense. This means that if an order indicates dispense 30 tablets plus "3 repeats", then the order can be dispensed a total of 4 times and the patient can receive a total of 120 tablets. A prescriber may explicitly say that zero refills are permitted after the initial dispense.
    """

    quantity: typing.Optional[Quantity] = pydantic.Field(default=None)
    """
    The amount that is to be dispensed for one fill.
    """

    expected_supply_duration: typing_extensions.Annotated[
        typing.Optional[Duration], FieldMetadata(alias="expectedSupplyDuration")
    ] = pydantic.Field(default=None)
    """
    Identifies the period time over which the supplied product is expected to be used, or the length of time the dispense is expected to last.
    """

    performer: typing.Optional[Reference] = pydantic.Field(default=None)
    """
    Indicates the intended dispensing Organization specified by the prescriber.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow", frozen=True
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
