# This file was auto-generated by Fern from our API Definition.

from .base_resource import BaseResource
from .address import Address
from .age import Age
from .annotation import Annotation
from .attachment import Attachment
from .codeable_concept import CodeableConcept
from .coding import Coding
from .contact_detail import ContactDetail
from .contact_point import ContactPoint
from .contributor import Contributor
from .count import Count
from .data_requirement import DataRequirement
from .data_requirement_code_filter import DataRequirementCodeFilter
from .data_requirement_date_filter import DataRequirementDateFilter
from .data_requirement_sort import DataRequirementSort
from .distance import Distance
from .dosage import Dosage
from .dosage_dose_and_rate import DosageDoseAndRate
from .duration import Duration
from .expression import Expression
from .extension import Extension
from .human_name import HumanName
from .identifier import Identifier
from .meta import Meta
from .money import Money
from .parameter_definition import ParameterDefinition
from .period import Period
from .quantity import Quantity
from .range import Range
from .ratio import Ratio
from .reference import Reference
from .related_artifact import RelatedArtifact
from .sampled_data import SampledData
from .signature import Signature
from .timing import Timing
from .timing_repeat import TimingRepeat
from .trigger_definition import TriggerDefinition
from .usage_context import UsageContext
import typing_extensions
import typing
from ...core.serialization import FieldMetadata
import pydantic
from .code import Code
from .date_time import DateTime
from .canonical import Canonical
from .uri import Uri
from .medication_request_dispense_request import MedicationRequestDispenseRequest
from .medication_request_substitution import MedicationRequestSubstitution
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class MedicationRequest(BaseResource):
    """
    An order or request for both supply of the medication and the instructions for administration of the medication to a patient. The resource is called "MedicationRequest" rather than "MedicationPrescription" or "MedicationOrder" to generalize the use across inpatient and outpatient settings, including care plans, etc., and to harmonize with workflow patterns.
    """

    resource_type: typing_extensions.Annotated[
        typing.Literal["MedicationRequest"], FieldMetadata(alias="resourceType")
    ] = "MedicationRequest"
    identifier: typing.Optional[typing.List[Identifier]] = pydantic.Field(default=None)
    """
    Identifiers associated with this medication request that are defined by business processes and/or used to refer to it when a direct URL reference to the resource itself is not appropriate. They are business identifiers assigned to this resource by the performer or other systems and remain constant as the resource is updated and propagates from server to server.
    """

    status: typing.Optional[Code] = pydantic.Field(default=None)
    """
    A code specifying the current state of the order. Generally, this will be active or completed state.
    """

    status_reason: typing_extensions.Annotated[
        typing.Optional[CodeableConcept], FieldMetadata(alias="statusReason")
    ] = pydantic.Field(default=None)
    """
    Captures the reason for the current state of the MedicationRequest.
    """

    intent: typing.Optional[Code] = pydantic.Field(default=None)
    """
    Whether the request is a proposal, plan, or an original order.
    """

    category: typing.Optional[typing.List[CodeableConcept]] = pydantic.Field(
        default=None
    )
    """
    Indicates the type of medication request (for example, where the medication is expected to be consumed or administered (i.e. inpatient or outpatient)).
    """

    priority: typing.Optional[Code] = pydantic.Field(default=None)
    """
    Indicates how quickly the Medication Request should be addressed with respect to other requests.
    """

    do_not_perform: typing_extensions.Annotated[
        typing.Optional[bool], FieldMetadata(alias="doNotPerform")
    ] = pydantic.Field(default=None)
    """
    If true indicates that the provider is asking for the medication request not to occur.
    """

    reported_boolean: typing_extensions.Annotated[
        typing.Optional[bool], FieldMetadata(alias="reportedBoolean")
    ] = pydantic.Field(default=None)
    """
    Indicates if this record was captured as a secondary 'reported' record rather than as an original primary source-of-truth record. It may also indicate the source of the report.
    """

    reported_reference: typing_extensions.Annotated[
        typing.Optional[Reference], FieldMetadata(alias="reportedReference")
    ] = pydantic.Field(default=None)
    """
    Indicates if this record was captured as a secondary 'reported' record rather than as an original primary source-of-truth record. It may also indicate the source of the report.
    """

    medication_codeable_concept: typing_extensions.Annotated[
        typing.Optional[CodeableConcept],
        FieldMetadata(alias="medicationCodeableConcept"),
    ] = pydantic.Field(default=None)
    """
    Identifies the medication being requested. This is a link to a resource that represents the medication which may be the details of the medication or simply an attribute carrying a code that identifies the medication from a known list of medications.
    """

    medication_reference: typing_extensions.Annotated[
        typing.Optional[Reference], FieldMetadata(alias="medicationReference")
    ] = pydantic.Field(default=None)
    """
    Identifies the medication being requested. This is a link to a resource that represents the medication which may be the details of the medication or simply an attribute carrying a code that identifies the medication from a known list of medications.
    """

    subject: Reference = pydantic.Field()
    """
    A link to a resource representing the person or set of individuals to whom the medication will be given.
    """

    encounter: typing.Optional[Reference] = pydantic.Field(default=None)
    """
    The Encounter during which this [x] was created or to which the creation of this record is tightly associated.
    """

    supporting_information: typing_extensions.Annotated[
        typing.Optional[typing.List[Reference]],
        FieldMetadata(alias="supportingInformation"),
    ] = pydantic.Field(default=None)
    """
    Include additional information (for example, patient height and weight) that supports the ordering of the medication.
    """

    authored_on: typing_extensions.Annotated[
        typing.Optional[DateTime], FieldMetadata(alias="authoredOn")
    ] = pydantic.Field(default=None)
    """
    The date (and perhaps time) when the prescription was initially written or authored on.
    """

    requester: typing.Optional[Reference] = pydantic.Field(default=None)
    """
    The individual, organization, or device that initiated the request and has responsibility for its activation.
    """

    performer: typing.Optional[Reference] = pydantic.Field(default=None)
    """
    The specified desired performer of the medication treatment (e.g. the performer of the medication administration).
    """

    performer_type: typing_extensions.Annotated[
        typing.Optional[CodeableConcept], FieldMetadata(alias="performerType")
    ] = pydantic.Field(default=None)
    """
    Indicates the type of performer of the administration of the medication.
    """

    recorder: typing.Optional[Reference] = pydantic.Field(default=None)
    """
    The person who entered the order on behalf of another individual for example in the case of a verbal or a telephone order.
    """

    reason_code: typing_extensions.Annotated[
        typing.Optional[typing.List[CodeableConcept]], FieldMetadata(alias="reasonCode")
    ] = pydantic.Field(default=None)
    """
    The reason or the indication for ordering or not ordering the medication.
    """

    reason_reference: typing_extensions.Annotated[
        typing.Optional[typing.List[Reference]], FieldMetadata(alias="reasonReference")
    ] = pydantic.Field(default=None)
    """
    Condition or observation that supports why the medication was ordered.
    """

    instantiates_canonical: typing_extensions.Annotated[
        typing.Optional[typing.List[Canonical]],
        FieldMetadata(alias="instantiatesCanonical"),
    ] = pydantic.Field(default=None)
    """
    The URL pointing to a protocol, guideline, orderset, or other definition that is adhered to in whole or in part by this MedicationRequest.
    """

    instantiates_uri: typing_extensions.Annotated[
        typing.Optional[typing.List[Uri]], FieldMetadata(alias="instantiatesUri")
    ] = pydantic.Field(default=None)
    """
    The URL pointing to an externally maintained protocol, guideline, orderset or other definition that is adhered to in whole or in part by this MedicationRequest.
    """

    based_on: typing_extensions.Annotated[
        typing.Optional[typing.List[Reference]], FieldMetadata(alias="basedOn")
    ] = pydantic.Field(default=None)
    """
    A plan or request that is fulfilled in whole or in part by this medication request.
    """

    group_identifier: typing_extensions.Annotated[
        typing.Optional[Identifier], FieldMetadata(alias="groupIdentifier")
    ] = pydantic.Field(default=None)
    """
    A shared identifier common to all requests that were authorized more or less simultaneously by a single author, representing the identifier of the requisition or prescription.
    """

    course_of_therapy_type: typing_extensions.Annotated[
        typing.Optional[CodeableConcept], FieldMetadata(alias="courseOfTherapyType")
    ] = pydantic.Field(default=None)
    """
    The description of the overall patte3rn of the administration of the medication to the patient.
    """

    insurance: typing.Optional[typing.List[Reference]] = pydantic.Field(default=None)
    """
    Insurance plans, coverage extensions, pre-authorizations and/or pre-determinations that may be required for delivering the requested service.
    """

    note: typing.Optional[typing.List[Annotation]] = pydantic.Field(default=None)
    """
    Extra information about the prescription that could not be conveyed by the other attributes.
    """

    dosage_instruction: typing_extensions.Annotated[
        typing.Optional[typing.List[Dosage]], FieldMetadata(alias="dosageInstruction")
    ] = pydantic.Field(default=None)
    """
    Indicates how the medication is to be used by the patient.
    """

    dispense_request: typing_extensions.Annotated[
        typing.Optional[MedicationRequestDispenseRequest],
        FieldMetadata(alias="dispenseRequest"),
    ] = pydantic.Field(default=None)
    """
    Indicates the specific details for the dispense or medication supply part of a medication request (also known as a Medication Prescription or Medication Order). Note that this information is not always sent with the order. There may be in some settings (e.g. hospitals) institutional or system support for completing the dispense details in the pharmacy department.
    """

    substitution: typing.Optional[MedicationRequestSubstitution] = pydantic.Field(
        default=None
    )
    """
    Indicates whether or not substitution can or should be part of the dispense. In some cases, substitution must happen, in other cases substitution must not happen. This block explains the prescriber's intent. If nothing is specified substitution may be done.
    """

    prior_prescription: typing_extensions.Annotated[
        typing.Optional[Reference], FieldMetadata(alias="priorPrescription")
    ] = pydantic.Field(default=None)
    """
    A link to a resource representing an earlier order related order or prescription.
    """

    detected_issue: typing_extensions.Annotated[
        typing.Optional[typing.List[Reference]], FieldMetadata(alias="detectedIssue")
    ] = pydantic.Field(default=None)
    """
    Indicates an actual or potential clinical issue with or between one or more active or proposed clinical actions for a patient; e.g. Drug-drug interaction, duplicate therapy, dosage alert etc.
    """

    event_history: typing_extensions.Annotated[
        typing.Optional[typing.List[Reference]], FieldMetadata(alias="eventHistory")
    ] = pydantic.Field(default=None)
    """
    Links to Provenance records for past versions of this resource or fulfilling request or event resources that identify key state transitions or updates that are likely to be relevant to a user looking at the current version of the resource.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow", frozen=True
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
