# This file was auto-generated by Fern from our API Definition.

from .base_resource import BaseResource
from .address import Address
from .age import Age
from .annotation import Annotation
from .attachment import Attachment
from .codeable_concept import CodeableConcept
from .coding import Coding
from .contact_detail import ContactDetail
from .contact_point import ContactPoint
from .contributor import Contributor
from .count import Count
from .data_requirement import DataRequirement
from .data_requirement_code_filter import DataRequirementCodeFilter
from .data_requirement_date_filter import DataRequirementDateFilter
from .data_requirement_sort import DataRequirementSort
from .distance import Distance
from .dosage import Dosage
from .dosage_dose_and_rate import DosageDoseAndRate
from .duration import Duration
from .expression import Expression
from .extension import Extension
from .human_name import HumanName
from .identifier import Identifier
from .meta import Meta
from .money import Money
from .parameter_definition import ParameterDefinition
from .period import Period
from .quantity import Quantity
from .range import Range
from .ratio import Ratio
from .reference import Reference
from .related_artifact import RelatedArtifact
from .sampled_data import SampledData
from .signature import Signature
from .timing import Timing
from .timing_repeat import TimingRepeat
from .trigger_definition import TriggerDefinition
from .usage_context import UsageContext
import typing_extensions
import typing
from ...core.serialization import FieldMetadata
import pydantic
from .code import Code
from .medication_knowledge_related_medication_knowledge import (
    MedicationKnowledgeRelatedMedicationKnowledge,
)
from .medication_knowledge_monograph import MedicationKnowledgeMonograph
from .medication_knowledge_ingredient import MedicationKnowledgeIngredient
from .markdown import Markdown
from .medication_knowledge_cost import MedicationKnowledgeCost
from .medication_knowledge_monitoring_program import (
    MedicationKnowledgeMonitoringProgram,
)
from .medication_knowledge_administration_guidelines import (
    MedicationKnowledgeAdministrationGuidelines,
)
from .medication_knowledge_medicine_classification import (
    MedicationKnowledgeMedicineClassification,
)
from .medication_knowledge_packaging import MedicationKnowledgePackaging
from .medication_knowledge_drug_characteristic import (
    MedicationKnowledgeDrugCharacteristic,
)
from .medication_knowledge_regulatory import MedicationKnowledgeRegulatory
from .medication_knowledge_kinetics import MedicationKnowledgeKinetics
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class MedicationKnowledge(BaseResource):
    """
    Information about a medication that is used to support knowledge.
    """

    resource_type: typing_extensions.Annotated[
        typing.Literal["MedicationKnowledge"], FieldMetadata(alias="resourceType")
    ] = "MedicationKnowledge"
    code: typing.Optional[CodeableConcept] = pydantic.Field(default=None)
    """
    A code that specifies this medication, or a textual description if no code is available. Usage note: This could be a standard medication code such as a code from RxNorm, SNOMED CT, IDMP etc. It could also be a national or local formulary code, optionally with translations to other code systems.
    """

    status: typing.Optional[Code] = pydantic.Field(default=None)
    """
    A code to indicate if the medication is in active use. The status refers to the validity about the information of the medication and not to its medicinal properties.
    """

    manufacturer: typing.Optional[Reference] = pydantic.Field(default=None)
    """
    Describes the details of the manufacturer of the medication product. This is not intended to represent the distributor of a medication product.
    """

    dose_form: typing_extensions.Annotated[
        typing.Optional[CodeableConcept], FieldMetadata(alias="doseForm")
    ] = pydantic.Field(default=None)
    """
    Describes the form of the item. Powder; tablets; capsule.
    """

    amount: typing.Optional[Quantity] = pydantic.Field(default=None)
    """
    Specific amount of the drug in the packaged product. For example, when specifying a product that has the same strength (For example, Insulin glargine 100 unit per mL solution for injection), this attribute provides additional clarification of the package amount (For example, 3 mL, 10mL, etc.).
    """

    synonym: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    Additional names for a medication, for example, the name(s) given to a medication in different countries. For example, acetaminophen and paracetamol or salbutamol and albuterol.
    """

    related_medication_knowledge: typing_extensions.Annotated[
        typing.Optional[typing.List[MedicationKnowledgeRelatedMedicationKnowledge]],
        FieldMetadata(alias="relatedMedicationKnowledge"),
    ] = pydantic.Field(default=None)
    """
    Associated or related knowledge about a medication.
    """

    associated_medication: typing_extensions.Annotated[
        typing.Optional[typing.List[Reference]],
        FieldMetadata(alias="associatedMedication"),
    ] = pydantic.Field(default=None)
    """
    Associated or related medications. For example, if the medication is a branded product (e.g. Crestor), this is the Therapeutic Moeity (e.g. Rosuvastatin) or if this is a generic medication (e.g. Rosuvastatin), this would link to a branded product (e.g. Crestor).
    """

    product_type: typing_extensions.Annotated[
        typing.Optional[typing.List[CodeableConcept]],
        FieldMetadata(alias="productType"),
    ] = pydantic.Field(default=None)
    """
    Category of the medication or product (e.g. branded product, therapeutic moeity, generic product, innovator product, etc.).
    """

    monograph: typing.Optional[typing.List[MedicationKnowledgeMonograph]] = (
        pydantic.Field(default=None)
    )
    """
    Associated documentation about the medication.
    """

    ingredient: typing.Optional[typing.List[MedicationKnowledgeIngredient]] = (
        pydantic.Field(default=None)
    )
    """
    Identifies a particular constituent of interest in the product.
    """

    preparation_instruction: typing_extensions.Annotated[
        typing.Optional[Markdown], FieldMetadata(alias="preparationInstruction")
    ] = pydantic.Field(default=None)
    """
    The instructions for preparing the medication.
    """

    intended_route: typing_extensions.Annotated[
        typing.Optional[typing.List[CodeableConcept]],
        FieldMetadata(alias="intendedRoute"),
    ] = pydantic.Field(default=None)
    """
    The intended or approved route of administration.
    """

    cost: typing.Optional[typing.List[MedicationKnowledgeCost]] = pydantic.Field(
        default=None
    )
    """
    The price of the medication.
    """

    monitoring_program: typing_extensions.Annotated[
        typing.Optional[typing.List[MedicationKnowledgeMonitoringProgram]],
        FieldMetadata(alias="monitoringProgram"),
    ] = pydantic.Field(default=None)
    """
    The program under which the medication is reviewed.
    """

    administration_guidelines: typing_extensions.Annotated[
        typing.Optional[typing.List[MedicationKnowledgeAdministrationGuidelines]],
        FieldMetadata(alias="administrationGuidelines"),
    ] = pydantic.Field(default=None)
    """
    Guidelines for the administration of the medication.
    """

    medicine_classification: typing_extensions.Annotated[
        typing.Optional[typing.List[MedicationKnowledgeMedicineClassification]],
        FieldMetadata(alias="medicineClassification"),
    ] = pydantic.Field(default=None)
    """
    Categorization of the medication within a formulary or classification system.
    """

    packaging: typing.Optional[MedicationKnowledgePackaging] = pydantic.Field(
        default=None
    )
    """
    Information that only applies to packages (not products).
    """

    drug_characteristic: typing_extensions.Annotated[
        typing.Optional[typing.List[MedicationKnowledgeDrugCharacteristic]],
        FieldMetadata(alias="drugCharacteristic"),
    ] = pydantic.Field(default=None)
    """
    Specifies descriptive properties of the medicine, such as color, shape, imprints, etc.
    """

    contraindication: typing.Optional[typing.List[Reference]] = pydantic.Field(
        default=None
    )
    """
    Potential clinical issue with or between medication(s) (for example, drug-drug interaction, drug-disease contraindication, drug-allergy interaction, etc.).
    """

    regulatory: typing.Optional[typing.List[MedicationKnowledgeRegulatory]] = (
        pydantic.Field(default=None)
    )
    """
    Regulatory information about a medication.
    """

    kinetics: typing.Optional[typing.List[MedicationKnowledgeKinetics]] = (
        pydantic.Field(default=None)
    )
    """
    The time course of drug absorption, distribution, metabolism and excretion of a medication from the body.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow", frozen=True
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
