# This file was auto-generated by Fern from our API Definition.

from .base_resource import BaseResource
from .address import Address
from .age import Age
from .annotation import Annotation
from .attachment import Attachment
from .codeable_concept import CodeableConcept
from .coding import Coding
from .contact_detail import ContactDetail
from .contact_point import ContactPoint
from .contributor import Contributor
from .count import Count
from .data_requirement import DataRequirement
from .data_requirement_code_filter import DataRequirementCodeFilter
from .data_requirement_date_filter import DataRequirementDateFilter
from .data_requirement_sort import DataRequirementSort
from .distance import Distance
from .dosage import Dosage
from .dosage_dose_and_rate import DosageDoseAndRate
from .duration import Duration
from .expression import Expression
from .extension import Extension
from .human_name import HumanName
from .identifier import Identifier
from .meta import Meta
from .money import Money
from .parameter_definition import ParameterDefinition
from .period import Period
from .quantity import Quantity
from .range import Range
from .ratio import Ratio
from .reference import Reference
from .related_artifact import RelatedArtifact
from .sampled_data import SampledData
from .signature import Signature
from .timing import Timing
from .timing_repeat import TimingRepeat
from .trigger_definition import TriggerDefinition
from .usage_context import UsageContext
import typing_extensions
import typing
from ...core.serialization import FieldMetadata
import pydantic
from .code import Code
from .medication_dispense_performer import MedicationDispensePerformer
from .date_time import DateTime
from .medication_dispense_substitution import MedicationDispenseSubstitution
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class MedicationDispense(BaseResource):
    """
    Indicates that a medication product is to be or has been dispensed for a named person/patient. This includes a description of the medication product (supply) provided and the instructions for administering the medication. The medication dispense is the result of a pharmacy system responding to a medication order.
    """

    resource_type: typing_extensions.Annotated[
        typing.Literal["MedicationDispense"], FieldMetadata(alias="resourceType")
    ] = "MedicationDispense"
    identifier: typing.Optional[typing.List[Identifier]] = pydantic.Field(default=None)
    """
    Identifiers associated with this Medication Dispense that are defined by business processes and/or used to refer to it when a direct URL reference to the resource itself is not appropriate. They are business identifiers assigned to this resource by the performer or other systems and remain constant as the resource is updated and propagates from server to server.
    """

    part_of: typing_extensions.Annotated[
        typing.Optional[typing.List[Reference]], FieldMetadata(alias="partOf")
    ] = pydantic.Field(default=None)
    """
    The procedure that trigger the dispense.
    """

    status: typing.Optional[Code] = pydantic.Field(default=None)
    """
    A code specifying the state of the set of dispense events.
    """

    status_reason_codeable_concept: typing_extensions.Annotated[
        typing.Optional[CodeableConcept],
        FieldMetadata(alias="statusReasonCodeableConcept"),
    ] = pydantic.Field(default=None)
    """
    Indicates the reason why a dispense was not performed.
    """

    status_reason_reference: typing_extensions.Annotated[
        typing.Optional[Reference], FieldMetadata(alias="statusReasonReference")
    ] = pydantic.Field(default=None)
    """
    Indicates the reason why a dispense was not performed.
    """

    category: typing.Optional[CodeableConcept] = pydantic.Field(default=None)
    """
    Indicates the type of medication dispense (for example, where the medication is expected to be consumed or administered (i.e. inpatient or outpatient)).
    """

    medication_codeable_concept: typing_extensions.Annotated[
        typing.Optional[CodeableConcept],
        FieldMetadata(alias="medicationCodeableConcept"),
    ] = pydantic.Field(default=None)
    """
    Identifies the medication being administered. This is either a link to a resource representing the details of the medication or a simple attribute carrying a code that identifies the medication from a known list of medications.
    """

    medication_reference: typing_extensions.Annotated[
        typing.Optional[Reference], FieldMetadata(alias="medicationReference")
    ] = pydantic.Field(default=None)
    """
    Identifies the medication being administered. This is either a link to a resource representing the details of the medication or a simple attribute carrying a code that identifies the medication from a known list of medications.
    """

    subject: typing.Optional[Reference] = pydantic.Field(default=None)
    """
    A link to a resource representing the person or the group to whom the medication will be given.
    """

    context: typing.Optional[Reference] = pydantic.Field(default=None)
    """
    The encounter or episode of care that establishes the context for this event.
    """

    supporting_information: typing_extensions.Annotated[
        typing.Optional[typing.List[Reference]],
        FieldMetadata(alias="supportingInformation"),
    ] = pydantic.Field(default=None)
    """
    Additional information that supports the medication being dispensed.
    """

    performer: typing.Optional[typing.List[MedicationDispensePerformer]] = (
        pydantic.Field(default=None)
    )
    """
    Indicates who or what performed the event.
    """

    location: typing.Optional[Reference] = pydantic.Field(default=None)
    """
    The principal physical location where the dispense was performed.
    """

    authorizing_prescription: typing_extensions.Annotated[
        typing.Optional[typing.List[Reference]],
        FieldMetadata(alias="authorizingPrescription"),
    ] = pydantic.Field(default=None)
    """
    Indicates the medication order that is being dispensed against.
    """

    type: typing.Optional[CodeableConcept] = pydantic.Field(default=None)
    """
    Indicates the type of dispensing event that is performed. For example, Trial Fill, Completion of Trial, Partial Fill, Emergency Fill, Samples, etc.
    """

    quantity: typing.Optional[Quantity] = pydantic.Field(default=None)
    """
    The amount of medication that has been dispensed. Includes unit of measure.
    """

    days_supply: typing_extensions.Annotated[
        typing.Optional[Quantity], FieldMetadata(alias="daysSupply")
    ] = pydantic.Field(default=None)
    """
    The amount of medication expressed as a timing amount.
    """

    when_prepared: typing_extensions.Annotated[
        typing.Optional[DateTime], FieldMetadata(alias="whenPrepared")
    ] = pydantic.Field(default=None)
    """
    The time when the dispensed product was packaged and reviewed.
    """

    when_handed_over: typing_extensions.Annotated[
        typing.Optional[DateTime], FieldMetadata(alias="whenHandedOver")
    ] = pydantic.Field(default=None)
    """
    The time the dispensed product was provided to the patient or their representative.
    """

    destination: typing.Optional[Reference] = pydantic.Field(default=None)
    """
    Identification of the facility/location where the medication was shipped to, as part of the dispense event.
    """

    receiver: typing.Optional[typing.List[Reference]] = pydantic.Field(default=None)
    """
    Identifies the person who picked up the medication. This will usually be a patient or their caregiver, but some cases exist where it can be a healthcare professional.
    """

    note: typing.Optional[typing.List[Annotation]] = pydantic.Field(default=None)
    """
    Extra information about the dispense that could not be conveyed in the other attributes.
    """

    dosage_instruction: typing_extensions.Annotated[
        typing.Optional[typing.List[Dosage]], FieldMetadata(alias="dosageInstruction")
    ] = pydantic.Field(default=None)
    """
    Indicates how the medication is to be used by the patient.
    """

    substitution: typing.Optional[MedicationDispenseSubstitution] = pydantic.Field(
        default=None
    )
    """
    Indicates whether or not substitution was made as part of the dispense. In some cases, substitution will be expected but does not happen, in other cases substitution is not expected but does happen. This block explains what substitution did or did not happen and why. If nothing is specified, substitution was not done.
    """

    detected_issue: typing_extensions.Annotated[
        typing.Optional[typing.List[Reference]], FieldMetadata(alias="detectedIssue")
    ] = pydantic.Field(default=None)
    """
    Indicates an actual or potential clinical issue with or between one or more active or proposed clinical actions for a patient; e.g. drug-drug interaction, duplicate therapy, dosage alert etc.
    """

    event_history: typing_extensions.Annotated[
        typing.Optional[typing.List[Reference]], FieldMetadata(alias="eventHistory")
    ] = pydantic.Field(default=None)
    """
    A summary of the events of interest that have occurred, such as when the dispense was verified.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow", frozen=True
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
