# This file was auto-generated by Fern from our API Definition.

from .base_resource import BaseResource
from .address import Address
from .age import Age
from .annotation import Annotation
from .attachment import Attachment
from .codeable_concept import CodeableConcept
from .coding import Coding
from .contact_detail import ContactDetail
from .contact_point import ContactPoint
from .contributor import Contributor
from .count import Count
from .data_requirement import DataRequirement
from .data_requirement_code_filter import DataRequirementCodeFilter
from .data_requirement_date_filter import DataRequirementDateFilter
from .data_requirement_sort import DataRequirementSort
from .distance import Distance
from .dosage import Dosage
from .dosage_dose_and_rate import DosageDoseAndRate
from .duration import Duration
from .expression import Expression
from .extension import Extension
from .human_name import HumanName
from .identifier import Identifier
from .meta import Meta
from .money import Money
from .parameter_definition import ParameterDefinition
from .period import Period
from .quantity import Quantity
from .range import Range
from .ratio import Ratio
from .reference import Reference
from .related_artifact import RelatedArtifact
from .sampled_data import SampledData
from .signature import Signature
from .timing import Timing
from .timing_repeat import TimingRepeat
from .trigger_definition import TriggerDefinition
from .usage_context import UsageContext
import typing_extensions
import typing
from ...core.serialization import FieldMetadata
import pydantic
from .uri import Uri
from .code import Code
from .medication_administration_performer import MedicationAdministrationPerformer
from .medication_administration_dosage import MedicationAdministrationDosage
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class MedicationAdministration(BaseResource):
    """
    Describes the event of a patient consuming or otherwise being administered a medication. This may be as simple as swallowing a tablet or it may be a long running infusion. Related resources tie this event to the authorizing prescription, and the specific encounter between patient and health care practitioner.
    """

    resource_type: typing_extensions.Annotated[
        typing.Literal["MedicationAdministration"], FieldMetadata(alias="resourceType")
    ] = "MedicationAdministration"
    identifier: typing.Optional[typing.List[Identifier]] = pydantic.Field(default=None)
    """
    Identifiers associated with this Medication Administration that are defined by business processes and/or used to refer to it when a direct URL reference to the resource itself is not appropriate. They are business identifiers assigned to this resource by the performer or other systems and remain constant as the resource is updated and propagates from server to server.
    """

    instantiates: typing.Optional[typing.List[Uri]] = pydantic.Field(default=None)
    """
    A protocol, guideline, orderset, or other definition that was adhered to in whole or in part by this event.
    """

    part_of: typing_extensions.Annotated[
        typing.Optional[typing.List[Reference]], FieldMetadata(alias="partOf")
    ] = pydantic.Field(default=None)
    """
    A larger event of which this particular event is a component or step.
    """

    status: typing.Optional[Code] = pydantic.Field(default=None)
    """
    Will generally be set to show that the administration has been completed. For some long running administrations such as infusions, it is possible for an administration to be started but not completed or it may be paused while some other process is under way.
    """

    status_reason: typing_extensions.Annotated[
        typing.Optional[typing.List[CodeableConcept]],
        FieldMetadata(alias="statusReason"),
    ] = pydantic.Field(default=None)
    """
    A code indicating why the administration was not performed.
    """

    category: typing.Optional[CodeableConcept] = pydantic.Field(default=None)
    """
    Indicates where the medication is expected to be consumed or administered.
    """

    medication_codeable_concept: typing_extensions.Annotated[
        typing.Optional[CodeableConcept],
        FieldMetadata(alias="medicationCodeableConcept"),
    ] = pydantic.Field(default=None)
    """
    Identifies the medication that was administered. This is either a link to a resource representing the details of the medication or a simple attribute carrying a code that identifies the medication from a known list of medications.
    """

    medication_reference: typing_extensions.Annotated[
        typing.Optional[Reference], FieldMetadata(alias="medicationReference")
    ] = pydantic.Field(default=None)
    """
    Identifies the medication that was administered. This is either a link to a resource representing the details of the medication or a simple attribute carrying a code that identifies the medication from a known list of medications.
    """

    subject: Reference = pydantic.Field()
    """
    The person or animal or group receiving the medication.
    """

    context: typing.Optional[Reference] = pydantic.Field(default=None)
    """
    The visit, admission, or other contact between patient and health care provider during which the medication administration was performed.
    """

    supporting_information: typing_extensions.Annotated[
        typing.Optional[typing.List[Reference]],
        FieldMetadata(alias="supportingInformation"),
    ] = pydantic.Field(default=None)
    """
    Additional information (for example, patient height and weight) that supports the administration of the medication.
    """

    effective_date_time: typing_extensions.Annotated[
        typing.Optional[str], FieldMetadata(alias="effectiveDateTime")
    ] = pydantic.Field(default=None)
    """
    A specific date/time or interval of time during which the administration took place (or did not take place, when the 'notGiven' attribute is true). For many administrations, such as swallowing a tablet the use of dateTime is more appropriate.
    """

    effective_period: typing_extensions.Annotated[
        typing.Optional[Period], FieldMetadata(alias="effectivePeriod")
    ] = pydantic.Field(default=None)
    """
    A specific date/time or interval of time during which the administration took place (or did not take place, when the 'notGiven' attribute is true). For many administrations, such as swallowing a tablet the use of dateTime is more appropriate.
    """

    performer: typing.Optional[typing.List[MedicationAdministrationPerformer]] = (
        pydantic.Field(default=None)
    )
    """
    Indicates who or what performed the medication administration and how they were involved.
    """

    reason_code: typing_extensions.Annotated[
        typing.Optional[typing.List[CodeableConcept]], FieldMetadata(alias="reasonCode")
    ] = pydantic.Field(default=None)
    """
    A code indicating why the medication was given.
    """

    reason_reference: typing_extensions.Annotated[
        typing.Optional[typing.List[Reference]], FieldMetadata(alias="reasonReference")
    ] = pydantic.Field(default=None)
    """
    Condition or observation that supports why the medication was administered.
    """

    request: typing.Optional[Reference] = pydantic.Field(default=None)
    """
    The original request, instruction or authority to perform the administration.
    """

    device: typing.Optional[typing.List[Reference]] = pydantic.Field(default=None)
    """
    The device used in administering the medication to the patient. For example, a particular infusion pump.
    """

    note: typing.Optional[typing.List[Annotation]] = pydantic.Field(default=None)
    """
    Extra information about the medication administration that is not conveyed by the other attributes.
    """

    dosage: typing.Optional[MedicationAdministrationDosage] = pydantic.Field(
        default=None
    )
    """
    Describes the medication dosage information details e.g. dose, rate, site, route, etc.
    """

    event_history: typing_extensions.Annotated[
        typing.Optional[typing.List[Reference]], FieldMetadata(alias="eventHistory")
    ] = pydantic.Field(default=None)
    """
    A summary of the events of interest that have occurred, such as when the administration was verified.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow", frozen=True
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
