# This file was auto-generated by Fern from our API Definition.

from .base_resource import BaseResource
from .address import Address
from .age import Age
from .annotation import Annotation
from .attachment import Attachment
from .codeable_concept import CodeableConcept
from .coding import Coding
from .contact_detail import ContactDetail
from .contact_point import ContactPoint
from .contributor import Contributor
from .count import Count
from .data_requirement import DataRequirement
from .data_requirement_code_filter import DataRequirementCodeFilter
from .data_requirement_date_filter import DataRequirementDateFilter
from .data_requirement_sort import DataRequirementSort
from .distance import Distance
from .dosage import Dosage
from .dosage_dose_and_rate import DosageDoseAndRate
from .duration import Duration
from .expression import Expression
from .extension import Extension
from .human_name import HumanName
from .identifier import Identifier
from .meta import Meta
from .money import Money
from .parameter_definition import ParameterDefinition
from .period import Period
from .quantity import Quantity
from .range import Range
from .ratio import Ratio
from .reference import Reference
from .related_artifact import RelatedArtifact
from .sampled_data import SampledData
from .signature import Signature
from .timing import Timing
from .timing_repeat import TimingRepeat
from .trigger_definition import TriggerDefinition
from .usage_context import UsageContext
import typing_extensions
import typing
from ...core.serialization import FieldMetadata
import pydantic
from .code import Code
from .medication_ingredient import MedicationIngredient
from .medication_batch import MedicationBatch
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class Medication(BaseResource):
    """
    This resource is primarily used for the identification and definition of a medication for the purposes of prescribing, dispensing, and administering a medication as well as for making statements about medication use.
    """

    resource_type: typing_extensions.Annotated[
        typing.Literal["Medication"], FieldMetadata(alias="resourceType")
    ] = "Medication"
    identifier: typing.Optional[typing.List[Identifier]] = pydantic.Field(default=None)
    """
    Business identifier for this medication.
    """

    code: typing.Optional[CodeableConcept] = pydantic.Field(default=None)
    """
    A code (or set of codes) that specify this medication, or a textual description if no code is available. Usage note: This could be a standard medication code such as a code from RxNorm, SNOMED CT, IDMP etc. It could also be a national or local formulary code, optionally with translations to other code systems.
    """

    status: typing.Optional[Code] = pydantic.Field(default=None)
    """
    A code to indicate if the medication is in active use.
    """

    manufacturer: typing.Optional[Reference] = pydantic.Field(default=None)
    """
    Describes the details of the manufacturer of the medication product. This is not intended to represent the distributor of a medication product.
    """

    form: typing.Optional[CodeableConcept] = pydantic.Field(default=None)
    """
    Describes the form of the item. Powder; tablets; capsule.
    """

    amount: typing.Optional[Ratio] = pydantic.Field(default=None)
    """
    Specific amount of the drug in the packaged product. For example, when specifying a product that has the same strength (For example, Insulin glargine 100 unit per mL solution for injection), this attribute provides additional clarification of the package amount (For example, 3 mL, 10mL, etc.).
    """

    ingredient: typing.Optional[typing.List[MedicationIngredient]] = pydantic.Field(
        default=None
    )
    """
    Identifies a particular constituent of interest in the product.
    """

    batch: typing.Optional[MedicationBatch] = pydantic.Field(default=None)
    """
    Information that only applies to packages (not products).
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow", frozen=True
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
