# This file was auto-generated by Fern from our API Definition.

from .base_resource import BaseResource
from .address import Address
from .age import Age
from .annotation import Annotation
from .attachment import Attachment
from .codeable_concept import CodeableConcept
from .coding import Coding
from .contact_detail import ContactDetail
from .contact_point import ContactPoint
from .contributor import Contributor
from .count import Count
from .data_requirement import DataRequirement
from .data_requirement_code_filter import DataRequirementCodeFilter
from .data_requirement_date_filter import DataRequirementDateFilter
from .data_requirement_sort import DataRequirementSort
from .distance import Distance
from .dosage import Dosage
from .dosage_dose_and_rate import DosageDoseAndRate
from .duration import Duration
from .expression import Expression
from .extension import Extension
from .human_name import HumanName
from .identifier import Identifier
from .meta import Meta
from .money import Money
from .parameter_definition import ParameterDefinition
from .period import Period
from .quantity import Quantity
from .range import Range
from .ratio import Ratio
from .reference import Reference
from .related_artifact import RelatedArtifact
from .sampled_data import SampledData
from .signature import Signature
from .timing import Timing
from .timing_repeat import TimingRepeat
from .trigger_definition import TriggerDefinition
from .usage_context import UsageContext
import typing_extensions
import typing
from ...core.serialization import FieldMetadata
import pydantic
from .code import Code
from .instant import Instant
from .positive_int import PositiveInt
from .decimal import Decimal
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class Media(BaseResource):
    """
    A photo, video, or audio recording acquired or used in healthcare. The actual content may be inline or provided by direct reference.
    """

    resource_type: typing_extensions.Annotated[
        typing.Literal["Media"], FieldMetadata(alias="resourceType")
    ] = "Media"
    identifier: typing.Optional[typing.List[Identifier]] = pydantic.Field(default=None)
    """
    Identifiers associated with the image - these may include identifiers for the image itself, identifiers for the context of its collection (e.g. series ids) and context ids such as accession numbers or other workflow identifiers.
    """

    based_on: typing_extensions.Annotated[
        typing.Optional[typing.List[Reference]], FieldMetadata(alias="basedOn")
    ] = pydantic.Field(default=None)
    """
    A procedure that is fulfilled in whole or in part by the creation of this media.
    """

    part_of: typing_extensions.Annotated[
        typing.Optional[typing.List[Reference]], FieldMetadata(alias="partOf")
    ] = pydantic.Field(default=None)
    """
    A larger event of which this particular event is a component or step.
    """

    status: typing.Optional[Code] = pydantic.Field(default=None)
    """
    The current state of the {{title}}.
    """

    type: typing.Optional[CodeableConcept] = pydantic.Field(default=None)
    """
    A code that classifies whether the media is an image, video or audio recording or some other media category.
    """

    modality: typing.Optional[CodeableConcept] = pydantic.Field(default=None)
    """
    Details of the type of the media - usually, how it was acquired (what type of device). If images sourced from a DICOM system, are wrapped in a Media resource, then this is the modality.
    """

    view: typing.Optional[CodeableConcept] = pydantic.Field(default=None)
    """
    The name of the imaging view e.g. Lateral or Antero-posterior (AP).
    """

    subject: typing.Optional[Reference] = pydantic.Field(default=None)
    """
    Who/What this Media is a record of.
    """

    encounter: typing.Optional[Reference] = pydantic.Field(default=None)
    """
    The encounter that establishes the context for this media.
    """

    created_date_time: typing_extensions.Annotated[
        typing.Optional[str], FieldMetadata(alias="createdDateTime")
    ] = pydantic.Field(default=None)
    """
    The date and time(s) at which the media was collected.
    """

    created_period: typing_extensions.Annotated[
        typing.Optional[Period], FieldMetadata(alias="createdPeriod")
    ] = pydantic.Field(default=None)
    """
    The date and time(s) at which the media was collected.
    """

    issued: typing.Optional[Instant] = pydantic.Field(default=None)
    """
    The date and time this version of the media was made available to providers, typically after having been reviewed.
    """

    operator: typing.Optional[Reference] = pydantic.Field(default=None)
    """
    The person who administered the collection of the image.
    """

    reason_code: typing_extensions.Annotated[
        typing.Optional[typing.List[CodeableConcept]], FieldMetadata(alias="reasonCode")
    ] = pydantic.Field(default=None)
    """
    Describes why the event occurred in coded or textual form.
    """

    body_site: typing_extensions.Annotated[
        typing.Optional[CodeableConcept], FieldMetadata(alias="bodySite")
    ] = pydantic.Field(default=None)
    """
    Indicates the site on the subject's body where the observation was made (i.e. the target site).
    """

    device_name: typing_extensions.Annotated[
        typing.Optional[str], FieldMetadata(alias="deviceName")
    ] = pydantic.Field(default=None)
    """
    The name of the device / manufacturer of the device that was used to make the recording.
    """

    device: typing.Optional[Reference] = pydantic.Field(default=None)
    """
    The device used to collect the media.
    """

    height: typing.Optional[PositiveInt] = pydantic.Field(default=None)
    """
    Height of the image in pixels (photo/video).
    """

    width: typing.Optional[PositiveInt] = pydantic.Field(default=None)
    """
    Width of the image in pixels (photo/video).
    """

    frames: typing.Optional[PositiveInt] = pydantic.Field(default=None)
    """
    The number of frames in a photo. This is used with a multi-page fax, or an imaging acquisition context that takes multiple slices in a single image, or an animated gif. If there is more than one frame, this SHALL have a value in order to alert interface software that a multi-frame capable rendering widget is required.
    """

    duration: typing.Optional[Decimal] = pydantic.Field(default=None)
    """
    The duration of the recording in seconds - for audio and video.
    """

    content: Attachment = pydantic.Field()
    """
    The actual content of the media - inline or by direct reference to the media source file.
    """

    note: typing.Optional[typing.List[Annotation]] = pydantic.Field(default=None)
    """
    Comments made about the media by the performer, subject or other participants.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow", frozen=True
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
