# This file was auto-generated by Fern from our API Definition.

from .base_resource import BaseResource
from .address import Address
from .age import Age
from .annotation import Annotation
from .attachment import Attachment
from .codeable_concept import CodeableConcept
from .coding import Coding
from .contact_detail import ContactDetail
from .contact_point import ContactPoint
from .contributor import Contributor
from .count import Count
from .data_requirement import DataRequirement
from .data_requirement_code_filter import DataRequirementCodeFilter
from .data_requirement_date_filter import DataRequirementDateFilter
from .data_requirement_sort import DataRequirementSort
from .distance import Distance
from .dosage import Dosage
from .dosage_dose_and_rate import DosageDoseAndRate
from .duration import Duration
from .expression import Expression
from .extension import Extension
from .human_name import HumanName
from .identifier import Identifier
from .meta import Meta
from .money import Money
from .parameter_definition import ParameterDefinition
from .period import Period
from .quantity import Quantity
from .range import Range
from .ratio import Ratio
from .reference import Reference
from .related_artifact import RelatedArtifact
from .sampled_data import SampledData
from .signature import Signature
from .timing import Timing
from .timing_repeat import TimingRepeat
from .trigger_definition import TriggerDefinition
from .usage_context import UsageContext
import typing_extensions
import typing
from ...core.serialization import FieldMetadata
import pydantic
from .measure_report_status import MeasureReportStatus
from .measure_report_type import MeasureReportType
from .canonical import Canonical
from .date_time import DateTime
from .measure_report_group import MeasureReportGroup
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class MeasureReport(BaseResource):
    """
    The MeasureReport resource contains the results of the calculation of a measure; and optionally a reference to the resources involved in that calculation.
    """

    resource_type: typing_extensions.Annotated[
        typing.Literal["MeasureReport"], FieldMetadata(alias="resourceType")
    ] = "MeasureReport"
    identifier: typing.Optional[typing.List[Identifier]] = pydantic.Field(default=None)
    """
    A formal identifier that is used to identify this MeasureReport when it is represented in other formats or referenced in a specification, model, design or an instance.
    """

    status: typing.Optional[MeasureReportStatus] = pydantic.Field(default=None)
    """
    The MeasureReport status. No data will be available until the MeasureReport status is complete.
    """

    type: typing.Optional[MeasureReportType] = pydantic.Field(default=None)
    """
    The type of measure report. This may be an individual report, which provides the score for the measure for an individual member of the population; a subject-listing, which returns the list of members that meet the various criteria in the measure; a summary report, which returns a population count for each of the criteria in the measure; or a data-collection, which enables the MeasureReport to be used to exchange the data-of-interest for a quality measure.
    """

    measure: Canonical = pydantic.Field()
    """
    A reference to the Measure that was calculated to produce this report.
    """

    subject: typing.Optional[Reference] = pydantic.Field(default=None)
    """
    Optional subject identifying the individual or individuals the report is for.
    """

    date: typing.Optional[DateTime] = pydantic.Field(default=None)
    """
    The date this measure report was generated.
    """

    reporter: typing.Optional[Reference] = pydantic.Field(default=None)
    """
    The individual, location, or organization that is reporting the data.
    """

    period: Period = pydantic.Field()
    """
    The reporting period for which the report was calculated.
    """

    improvement_notation: typing_extensions.Annotated[
        typing.Optional[CodeableConcept], FieldMetadata(alias="improvementNotation")
    ] = pydantic.Field(default=None)
    """
    Whether improvement in the measure is noted by an increase or decrease in the measure score.
    """

    group: typing.Optional[typing.List[MeasureReportGroup]] = pydantic.Field(
        default=None
    )
    """
    The results of the calculation, one for each population group in the measure.
    """

    evaluated_resource: typing_extensions.Annotated[
        typing.Optional[typing.List[Reference]],
        FieldMetadata(alias="evaluatedResource"),
    ] = pydantic.Field(default=None)
    """
    A reference to a Bundle containing the Resources that were used in the calculation of this measure.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow", frozen=True
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
