# This file was auto-generated by Fern from our API Definition.

from .base_resource import BaseResource
from .address import Address
from .age import Age
from .annotation import Annotation
from .attachment import Attachment
from .codeable_concept import CodeableConcept
from .coding import Coding
from .contact_detail import ContactDetail
from .contact_point import ContactPoint
from .contributor import Contributor
from .count import Count
from .data_requirement import DataRequirement
from .data_requirement_code_filter import DataRequirementCodeFilter
from .data_requirement_date_filter import DataRequirementDateFilter
from .data_requirement_sort import DataRequirementSort
from .distance import Distance
from .dosage import Dosage
from .dosage_dose_and_rate import DosageDoseAndRate
from .duration import Duration
from .expression import Expression
from .extension import Extension
from .human_name import HumanName
from .identifier import Identifier
from .meta import Meta
from .money import Money
from .parameter_definition import ParameterDefinition
from .period import Period
from .quantity import Quantity
from .range import Range
from .ratio import Ratio
from .reference import Reference
from .related_artifact import RelatedArtifact
from .sampled_data import SampledData
from .signature import Signature
from .timing import Timing
from .timing_repeat import TimingRepeat
from .trigger_definition import TriggerDefinition
from .usage_context import UsageContext
import typing_extensions
import typing
from ...core.serialization import FieldMetadata
from .uri import Uri
import pydantic
from .measure_status import MeasureStatus
from .date_time import DateTime
from .markdown import Markdown
import datetime as dt
from .canonical import Canonical
from .measure_group import MeasureGroup
from .measure_supplemental_data import MeasureSupplementalData
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class Measure(BaseResource):
    """
    The Measure resource provides the definition of a quality measure.
    """

    resource_type: typing_extensions.Annotated[
        typing.Literal["Measure"], FieldMetadata(alias="resourceType")
    ] = "Measure"
    url: typing.Optional[Uri] = pydantic.Field(default=None)
    """
    An absolute URI that is used to identify this measure when it is referenced in a specification, model, design or an instance; also called its canonical identifier. This SHOULD be globally unique and SHOULD be a literal address at which at which an authoritative instance of this measure is (or will be) published. This URL can be the target of a canonical reference. It SHALL remain the same when the measure is stored on different servers.
    """

    identifier: typing.Optional[typing.List[Identifier]] = pydantic.Field(default=None)
    """
    A formal identifier that is used to identify this measure when it is represented in other formats, or referenced in a specification, model, design or an instance.
    """

    version: typing.Optional[str] = pydantic.Field(default=None)
    """
    The identifier that is used to identify this version of the measure when it is referenced in a specification, model, design or instance. This is an arbitrary value managed by the measure author and is not expected to be globally unique. For example, it might be a timestamp (e.g. yyyymmdd) if a managed version is not available. There is also no expectation that versions can be placed in a lexicographical sequence. To provide a version consistent with the Decision Support Service specification, use the format Major.Minor.Revision (e.g. 1.0.0). For more information on versioning knowledge assets, refer to the Decision Support Service specification. Note that a version is required for non-experimental active artifacts.
    """

    name: typing.Optional[str] = pydantic.Field(default=None)
    """
    A natural language name identifying the measure. This name should be usable as an identifier for the module by machine processing applications such as code generation.
    """

    title: typing.Optional[str] = pydantic.Field(default=None)
    """
    A short, descriptive, user-friendly title for the measure.
    """

    subtitle: typing.Optional[str] = pydantic.Field(default=None)
    """
    An explanatory or alternate title for the measure giving additional information about its content.
    """

    status: typing.Optional[MeasureStatus] = pydantic.Field(default=None)
    """
    The status of this measure. Enables tracking the life-cycle of the content.
    """

    experimental: typing.Optional[bool] = pydantic.Field(default=None)
    """
    A Boolean value to indicate that this measure is authored for testing purposes (or education/evaluation/marketing) and is not intended to be used for genuine usage.
    """

    subject_codeable_concept: typing_extensions.Annotated[
        typing.Optional[CodeableConcept], FieldMetadata(alias="subjectCodeableConcept")
    ] = pydantic.Field(default=None)
    """
    The intended subjects for the measure. If this element is not provided, a Patient subject is assumed, but the subject of the measure can be anything.
    """

    subject_reference: typing_extensions.Annotated[
        typing.Optional[Reference], FieldMetadata(alias="subjectReference")
    ] = pydantic.Field(default=None)
    """
    The intended subjects for the measure. If this element is not provided, a Patient subject is assumed, but the subject of the measure can be anything.
    """

    date: typing.Optional[DateTime] = pydantic.Field(default=None)
    """
    The date (and optionally time) when the measure was published. The date must change when the business version changes and it must change if the status code changes. In addition, it should change when the substantive content of the measure changes.
    """

    publisher: typing.Optional[str] = pydantic.Field(default=None)
    """
    The name of the organization or individual that published the measure.
    """

    contact: typing.Optional[typing.List[ContactDetail]] = pydantic.Field(default=None)
    """
    Contact details to assist a user in finding and communicating with the publisher.
    """

    description: typing.Optional[Markdown] = pydantic.Field(default=None)
    """
    A free text natural language description of the measure from a consumer's perspective.
    """

    use_context: typing_extensions.Annotated[
        typing.Optional[typing.List[UsageContext]], FieldMetadata(alias="useContext")
    ] = pydantic.Field(default=None)
    """
    The content was developed with a focus and intent of supporting the contexts that are listed. These contexts may be general categories (gender, age, ...) or may be references to specific programs (insurance plans, studies, ...) and may be used to assist with indexing and searching for appropriate measure instances.
    """

    jurisdiction: typing.Optional[typing.List[CodeableConcept]] = pydantic.Field(
        default=None
    )
    """
    A legal or geographic region in which the measure is intended to be used.
    """

    purpose: typing.Optional[Markdown] = pydantic.Field(default=None)
    """
    Explanation of why this measure is needed and why it has been designed as it has.
    """

    usage: typing.Optional[str] = pydantic.Field(default=None)
    """
    A detailed description, from a clinical perspective, of how the measure is used.
    """

    copyright: typing.Optional[Markdown] = pydantic.Field(default=None)
    """
    A copyright statement relating to the measure and/or its contents. Copyright statements are generally legal restrictions on the use and publishing of the measure.
    """

    approval_date: typing_extensions.Annotated[
        typing.Optional[dt.date], FieldMetadata(alias="approvalDate")
    ] = pydantic.Field(default=None)
    """
    The date on which the resource content was approved by the publisher. Approval happens once when the content is officially approved for usage.
    """

    last_review_date: typing_extensions.Annotated[
        typing.Optional[dt.date], FieldMetadata(alias="lastReviewDate")
    ] = pydantic.Field(default=None)
    """
    The date on which the resource content was last reviewed. Review happens periodically after approval but does not change the original approval date.
    """

    effective_period: typing_extensions.Annotated[
        typing.Optional[Period], FieldMetadata(alias="effectivePeriod")
    ] = pydantic.Field(default=None)
    """
    The period during which the measure content was or is planned to be in active use.
    """

    topic: typing.Optional[typing.List[CodeableConcept]] = pydantic.Field(default=None)
    """
    Descriptive topics related to the content of the measure. Topics provide a high-level categorization grouping types of measures that can be useful for filtering and searching.
    """

    author: typing.Optional[typing.List[ContactDetail]] = pydantic.Field(default=None)
    """
    An individiual or organization primarily involved in the creation and maintenance of the content.
    """

    editor: typing.Optional[typing.List[ContactDetail]] = pydantic.Field(default=None)
    """
    An individual or organization primarily responsible for internal coherence of the content.
    """

    reviewer: typing.Optional[typing.List[ContactDetail]] = pydantic.Field(default=None)
    """
    An individual or organization primarily responsible for review of some aspect of the content.
    """

    endorser: typing.Optional[typing.List[ContactDetail]] = pydantic.Field(default=None)
    """
    An individual or organization responsible for officially endorsing the content for use in some setting.
    """

    related_artifact: typing_extensions.Annotated[
        typing.Optional[typing.List[RelatedArtifact]],
        FieldMetadata(alias="relatedArtifact"),
    ] = pydantic.Field(default=None)
    """
    Related artifacts such as additional documentation, justification, or bibliographic references.
    """

    library: typing.Optional[typing.List[Canonical]] = pydantic.Field(default=None)
    """
    A reference to a Library resource containing the formal logic used by the measure.
    """

    disclaimer: typing.Optional[Markdown] = pydantic.Field(default=None)
    """
    Notices and disclaimers regarding the use of the measure or related to intellectual property (such as code systems) referenced by the measure.
    """

    scoring: typing.Optional[CodeableConcept] = pydantic.Field(default=None)
    """
    Indicates how the calculation is performed for the measure, including proportion, ratio, continuous-variable, and cohort. The value set is extensible, allowing additional measure scoring types to be represented.
    """

    composite_scoring: typing_extensions.Annotated[
        typing.Optional[CodeableConcept], FieldMetadata(alias="compositeScoring")
    ] = pydantic.Field(default=None)
    """
    If this is a composite measure, the scoring method used to combine the component measures to determine the composite score.
    """

    type: typing.Optional[typing.List[CodeableConcept]] = pydantic.Field(default=None)
    """
    Indicates whether the measure is used to examine a process, an outcome over time, a patient-reported outcome, or a structure measure such as utilization.
    """

    risk_adjustment: typing_extensions.Annotated[
        typing.Optional[str], FieldMetadata(alias="riskAdjustment")
    ] = pydantic.Field(default=None)
    """
    A description of the risk adjustment factors that may impact the resulting score for the measure and how they may be accounted for when computing and reporting measure results.
    """

    rate_aggregation: typing_extensions.Annotated[
        typing.Optional[str], FieldMetadata(alias="rateAggregation")
    ] = pydantic.Field(default=None)
    """
    Describes how to combine the information calculated, based on logic in each of several populations, into one summarized result.
    """

    rationale: typing.Optional[Markdown] = pydantic.Field(default=None)
    """
    Provides a succinct statement of the need for the measure. Usually includes statements pertaining to importance criterion: impact, gap in care, and evidence.
    """

    clinical_recommendation_statement: typing_extensions.Annotated[
        typing.Optional[Markdown],
        FieldMetadata(alias="clinicalRecommendationStatement"),
    ] = pydantic.Field(default=None)
    """
    Provides a summary of relevant clinical guidelines or other clinical recommendations supporting the measure.
    """

    improvement_notation: typing_extensions.Annotated[
        typing.Optional[CodeableConcept], FieldMetadata(alias="improvementNotation")
    ] = pydantic.Field(default=None)
    """
    Information on whether an increase or decrease in score is the preferred result (e.g., a higher score indicates better quality OR a lower score indicates better quality OR quality is within a range).
    """

    definition: typing.Optional[typing.List[Markdown]] = pydantic.Field(default=None)
    """
    Provides a description of an individual term used within the measure.
    """

    guidance: typing.Optional[Markdown] = pydantic.Field(default=None)
    """
    Additional guidance for the measure including how it can be used in a clinical context, and the intent of the measure.
    """

    group: typing.Optional[typing.List[MeasureGroup]] = pydantic.Field(default=None)
    """
    A group of population criteria for the measure.
    """

    supplemental_data: typing_extensions.Annotated[
        typing.Optional[typing.List[MeasureSupplementalData]],
        FieldMetadata(alias="supplementalData"),
    ] = pydantic.Field(default=None)
    """
    The supplemental data criteria for the measure report, specified as either the name of a valid CQL expression within a referenced library, or a valid FHIR Resource Path.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow", frozen=True
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
