# This file was auto-generated by Fern from our API Definition.

from ...core.pydantic_utilities import UniversalBaseModel
from .address import Address
from .age import Age
from .annotation import Annotation
from .attachment import Attachment
from .codeable_concept import CodeableConcept
from .coding import Coding
from .contact_detail import ContactDetail
from .contact_point import ContactPoint
from .contributor import Contributor
from .count import Count
from .data_requirement import DataRequirement
from .data_requirement_code_filter import DataRequirementCodeFilter
from .data_requirement_date_filter import DataRequirementDateFilter
from .data_requirement_sort import DataRequirementSort
from .distance import Distance
from .dosage import Dosage
from .dosage_dose_and_rate import DosageDoseAndRate
from .duration import Duration
from .expression import Expression
from .extension import Extension
from .human_name import HumanName
from .identifier import Identifier
from .meta import Meta
from .money import Money
from .parameter_definition import ParameterDefinition
from .period import Period
from .quantity import Quantity
from .range import Range
from .ratio import Ratio
from .reference import Reference
from .related_artifact import RelatedArtifact
from .sampled_data import SampledData
from .signature import Signature
from .timing import Timing
from .timing_repeat import TimingRepeat
from .trigger_definition import TriggerDefinition
from .usage_context import UsageContext
import typing_extensions
import typing
from ...core.serialization import FieldMetadata
from .id import Id
import pydantic
from .uri import Uri
from .code import Code
from .login_auth_method import LoginAuthMethod
from .instant import Instant
from .login_code_challenge_method import LoginCodeChallengeMethod
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class Login(UniversalBaseModel):
    """
    Login event and session details.
    """

    resource_type: typing_extensions.Annotated[
        typing.Literal["Login"], FieldMetadata(alias="resourceType")
    ] = "Login"
    id: typing.Optional[Id] = pydantic.Field(default=None)
    """
    The logical id of the resource, as used in the URL for the resource. Once assigned, this value never changes.
    """

    meta: typing.Optional[Meta] = pydantic.Field(default=None)
    """
    The metadata about the resource. This is content that is maintained by the infrastructure. Changes to the content might not always be associated with version changes to the resource.
    """

    implicit_rules: typing_extensions.Annotated[
        typing.Optional[Uri], FieldMetadata(alias="implicitRules")
    ] = pydantic.Field(default=None)
    """
    A reference to a set of rules that were followed when the resource was constructed, and which must be understood when processing the content. Often, this is a reference to an implementation guide that defines the special rules along with other profiles etc.
    """

    language: typing.Optional[Code] = pydantic.Field(default=None)
    """
    The base language in which the resource is written.
    """

    client: typing.Optional[Reference] = pydantic.Field(default=None)
    """
    The client requesting the code.
    """

    profile_type: typing_extensions.Annotated[
        typing.Optional[Code], FieldMetadata(alias="profileType")
    ] = pydantic.Field(default=None)
    """
    Optional required profile resource type.
    """

    project: typing.Optional[Reference] = pydantic.Field(default=None)
    """
    Optional required project for the login.
    """

    user: Reference = pydantic.Field()
    """
    The user requesting the code.
    """

    membership: typing.Optional[Reference] = pydantic.Field(default=None)
    """
    Reference to the project membership which includes FHIR identity (patient, practitioner, etc), access policy, and user configuration.
    """

    scope: typing.Optional[str] = pydantic.Field(default=None)
    """
    OAuth scope or scopes.
    """

    auth_method: typing_extensions.Annotated[
        LoginAuthMethod, FieldMetadata(alias="authMethod")
    ] = pydantic.Field()
    """
    The authentication method used to obtain the code (password or google).
    """

    auth_time: typing_extensions.Annotated[Instant, FieldMetadata(alias="authTime")] = (
        pydantic.Field()
    )
    """
    Time when the End-User authentication occurred.
    """

    cookie: typing.Optional[str] = pydantic.Field(default=None)
    """
    The cookie value that can be used for session management.
    """

    code: typing.Optional[str] = pydantic.Field(default=None)
    """
    The authorization code generated by the authorization server. The authorization code MUST expire shortly after it is issued to mitigate the risk of leaks. A maximum authorization code lifetime of 10 minutes is RECOMMENDED. The client MUST NOT use the authorization code more than once. If an authorization code is used more than once, the authorization server MUST deny the request and SHOULD revoke (when possible) all tokens previously issued based on that authorization code. The authorization code is bound to the client identifier and redirection URI.
    """

    code_challenge: typing_extensions.Annotated[
        typing.Optional[str], FieldMetadata(alias="codeChallenge")
    ] = pydantic.Field(default=None)
    """
    PKCE code challenge presented in the authorization request.
    """

    code_challenge_method: typing_extensions.Annotated[
        typing.Optional[LoginCodeChallengeMethod],
        FieldMetadata(alias="codeChallengeMethod"),
    ] = pydantic.Field(default=None)
    """
    OPTIONAL, defaults to "plain" if not present in the request. Code verifier transformation method is "S256" or "plain".
    """

    refresh_secret: typing_extensions.Annotated[
        typing.Optional[str], FieldMetadata(alias="refreshSecret")
    ] = pydantic.Field(default=None)
    """
    Optional secure random string that can be used in an OAuth refresh token.
    """

    nonce: typing.Optional[str] = pydantic.Field(default=None)
    """
    Optional cryptographically random string that your app adds to the initial request and the authorization server includes inside the ID Token, used to prevent token replay attacks.
    """

    mfa_verified: typing_extensions.Annotated[
        typing.Optional[bool], FieldMetadata(alias="mfaVerified")
    ] = pydantic.Field(default=None)
    """
    Whether the user has verified using multi-factor authentication (MFA). This will only be set is the user has MFA enabled (see User.mfaEnrolled).
    """

    granted: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Whether a token has been granted for this login.
    """

    revoked: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Whether this login has been revoked or invalidated.
    """

    admin: typing.Optional[bool] = pydantic.Field(default=None)
    """
    DEPRECATED
    """

    super_admin: typing_extensions.Annotated[
        typing.Optional[bool], FieldMetadata(alias="superAdmin")
    ] = pydantic.Field(default=None)
    """
    Whether this login has super administrator privileges.
    """

    launch: typing.Optional[Reference] = pydantic.Field(default=None)
    """
    Optional SMART App Launch context for this login.
    """

    remote_address: typing_extensions.Annotated[
        typing.Optional[str], FieldMetadata(alias="remoteAddress")
    ] = pydantic.Field(default=None)
    """
    The Internet Protocol (IP) address of the client or last proxy that sent the request.
    """

    user_agent: typing_extensions.Annotated[
        typing.Optional[str], FieldMetadata(alias="userAgent")
    ] = pydantic.Field(default=None)
    """
    The User-Agent request header as sent by the client.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow", frozen=True
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
