# This file was auto-generated by Fern from our API Definition.

from .base_resource import BaseResource
from .address import Address
from .age import Age
from .annotation import Annotation
from .attachment import Attachment
from .codeable_concept import CodeableConcept
from .coding import Coding
from .contact_detail import ContactDetail
from .contact_point import ContactPoint
from .contributor import Contributor
from .count import Count
from .data_requirement import DataRequirement
from .data_requirement_code_filter import DataRequirementCodeFilter
from .data_requirement_date_filter import DataRequirementDateFilter
from .data_requirement_sort import DataRequirementSort
from .distance import Distance
from .dosage import Dosage
from .dosage_dose_and_rate import DosageDoseAndRate
from .duration import Duration
from .expression import Expression
from .extension import Extension
from .human_name import HumanName
from .identifier import Identifier
from .meta import Meta
from .money import Money
from .parameter_definition import ParameterDefinition
from .period import Period
from .quantity import Quantity
from .range import Range
from .ratio import Ratio
from .reference import Reference
from .related_artifact import RelatedArtifact
from .sampled_data import SampledData
from .signature import Signature
from .timing import Timing
from .timing_repeat import TimingRepeat
from .trigger_definition import TriggerDefinition
from .usage_context import UsageContext
import typing_extensions
import typing
from ...core.serialization import FieldMetadata
import pydantic
from .location_status import LocationStatus
from .location_mode import LocationMode
from .location_position import LocationPosition
from .location_hours_of_operation import LocationHoursOfOperation
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class Location(BaseResource):
    """
    Details and position information for a physical place where services are provided and resources and participants may be stored, found, contained, or accommodated.
    """

    resource_type: typing_extensions.Annotated[
        typing.Literal["Location"], FieldMetadata(alias="resourceType")
    ] = "Location"
    identifier: typing.Optional[typing.List[Identifier]] = pydantic.Field(default=None)
    """
    Unique code or number identifying the location to its users.
    """

    status: typing.Optional[LocationStatus] = pydantic.Field(default=None)
    """
    The status property covers the general availability of the resource, not the current value which may be covered by the operationStatus, or by a schedule/slots if they are configured for the location.
    """

    operational_status: typing_extensions.Annotated[
        typing.Optional[Coding], FieldMetadata(alias="operationalStatus")
    ] = pydantic.Field(default=None)
    """
    The operational status covers operation values most relevant to beds (but can also apply to rooms/units/chairs/etc. such as an isolation unit/dialysis chair). This typically covers concepts such as contamination, housekeeping, and other activities like maintenance.
    """

    name: typing.Optional[str] = pydantic.Field(default=None)
    """
    Name of the location as used by humans. Does not need to be unique.
    """

    alias: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    A list of alternate names that the location is known as, or was known as, in the past.
    """

    description: typing.Optional[str] = pydantic.Field(default=None)
    """
    Description of the Location, which helps in finding or referencing the place.
    """

    mode: typing.Optional[LocationMode] = pydantic.Field(default=None)
    """
    Indicates whether a resource instance represents a specific location or a class of locations.
    """

    type: typing.Optional[typing.List[CodeableConcept]] = pydantic.Field(default=None)
    """
    Indicates the type of function performed at the location.
    """

    telecom: typing.Optional[typing.List[ContactPoint]] = pydantic.Field(default=None)
    """
    The contact details of communication devices available at the location. This can include phone numbers, fax numbers, mobile numbers, email addresses and web sites.
    """

    address: typing.Optional[Address] = pydantic.Field(default=None)
    """
    Physical location.
    """

    physical_type: typing_extensions.Annotated[
        typing.Optional[CodeableConcept], FieldMetadata(alias="physicalType")
    ] = pydantic.Field(default=None)
    """
    Physical form of the location, e.g. building, room, vehicle, road.
    """

    position: typing.Optional[LocationPosition] = pydantic.Field(default=None)
    """
    The absolute geographic location of the Location, expressed using the WGS84 datum (This is the same co-ordinate system used in KML).
    """

    managing_organization: typing_extensions.Annotated[
        typing.Optional[Reference], FieldMetadata(alias="managingOrganization")
    ] = pydantic.Field(default=None)
    """
    The organization responsible for the provisioning and upkeep of the location.
    """

    part_of: typing_extensions.Annotated[
        typing.Optional[Reference], FieldMetadata(alias="partOf")
    ] = pydantic.Field(default=None)
    """
    Another Location of which this Location is physically a part of.
    """

    hours_of_operation: typing_extensions.Annotated[
        typing.Optional[typing.List[LocationHoursOfOperation]],
        FieldMetadata(alias="hoursOfOperation"),
    ] = pydantic.Field(default=None)
    """
    What days/times during a week is this location usually open.
    """

    availability_exceptions: typing_extensions.Annotated[
        typing.Optional[str], FieldMetadata(alias="availabilityExceptions")
    ] = pydantic.Field(default=None)
    """
    A description of when the locations opening ours are different to normal, e.g. public holiday availability. Succinctly describing all possible exceptions to normal site availability as detailed in the opening hours Times.
    """

    endpoint: typing.Optional[typing.List[Reference]] = pydantic.Field(default=None)
    """
    Technical endpoints providing access to services operated for the location.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow", frozen=True
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
