# This file was auto-generated by Fern from our API Definition.

from .base_resource import BaseResource
from .address import Address
from .age import Age
from .annotation import Annotation
from .attachment import Attachment
from .codeable_concept import CodeableConcept
from .coding import Coding
from .contact_detail import ContactDetail
from .contact_point import ContactPoint
from .contributor import Contributor
from .count import Count
from .data_requirement import DataRequirement
from .data_requirement_code_filter import DataRequirementCodeFilter
from .data_requirement_date_filter import DataRequirementDateFilter
from .data_requirement_sort import DataRequirementSort
from .distance import Distance
from .dosage import Dosage
from .dosage_dose_and_rate import DosageDoseAndRate
from .duration import Duration
from .expression import Expression
from .extension import Extension
from .human_name import HumanName
from .identifier import Identifier
from .meta import Meta
from .money import Money
from .parameter_definition import ParameterDefinition
from .period import Period
from .quantity import Quantity
from .range import Range
from .ratio import Ratio
from .reference import Reference
from .related_artifact import RelatedArtifact
from .sampled_data import SampledData
from .signature import Signature
from .timing import Timing
from .timing_repeat import TimingRepeat
from .trigger_definition import TriggerDefinition
from .usage_context import UsageContext
import typing_extensions
import typing
from ...core.serialization import FieldMetadata
import pydantic
from .list_status import ListStatus
from .list_mode import ListMode
from .date_time import DateTime
from .list_entry import ListEntry
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class List(BaseResource):
    """
    A list is a curated collection of resources.
    """

    resource_type: typing_extensions.Annotated[
        typing.Literal["List"], FieldMetadata(alias="resourceType")
    ] = "List"
    identifier: typing.Optional[typing.List[Identifier]] = pydantic.Field(default=None)
    """
    Identifier for the List assigned for business purposes outside the context of FHIR.
    """

    status: typing.Optional[ListStatus] = pydantic.Field(default=None)
    """
    Indicates the current state of this list.
    """

    mode: typing.Optional[ListMode] = pydantic.Field(default=None)
    """
    How this list was prepared - whether it is a working list that is suitable for being maintained on an ongoing basis, or if it represents a snapshot of a list of items from another source, or whether it is a prepared list where items may be marked as added, modified or deleted.
    """

    title: typing.Optional[str] = pydantic.Field(default=None)
    """
    A label for the list assigned by the author.
    """

    code: typing.Optional[CodeableConcept] = pydantic.Field(default=None)
    """
    This code defines the purpose of the list - why it was created.
    """

    subject: typing.Optional[Reference] = pydantic.Field(default=None)
    """
    The common subject (or patient) of the resources that are in the list if there is one.
    """

    encounter: typing.Optional[Reference] = pydantic.Field(default=None)
    """
    The encounter that is the context in which this list was created.
    """

    date: typing.Optional[DateTime] = pydantic.Field(default=None)
    """
    The date that the list was prepared.
    """

    source: typing.Optional[Reference] = pydantic.Field(default=None)
    """
    The entity responsible for deciding what the contents of the list were. Where the list was created by a human, this is the same as the author of the list.
    """

    ordered_by: typing_extensions.Annotated[
        typing.Optional[CodeableConcept], FieldMetadata(alias="orderedBy")
    ] = pydantic.Field(default=None)
    """
    What order applies to the items in the list.
    """

    note: typing.Optional[typing.List[Annotation]] = pydantic.Field(default=None)
    """
    Comments that apply to the overall list.
    """

    entry: typing.Optional[typing.List[ListEntry]] = pydantic.Field(default=None)
    """
    Entries in this list.
    """

    empty_reason: typing_extensions.Annotated[
        typing.Optional[CodeableConcept], FieldMetadata(alias="emptyReason")
    ] = pydantic.Field(default=None)
    """
    If the list is empty, why the list is empty.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow", frozen=True
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
