# This file was auto-generated by Fern from our API Definition.

from .base_resource import BaseResource
from .address import Address
from .age import Age
from .annotation import Annotation
from .attachment import Attachment
from .codeable_concept import CodeableConcept
from .coding import Coding
from .contact_detail import ContactDetail
from .contact_point import ContactPoint
from .contributor import Contributor
from .count import Count
from .data_requirement import DataRequirement
from .data_requirement_code_filter import DataRequirementCodeFilter
from .data_requirement_date_filter import DataRequirementDateFilter
from .data_requirement_sort import DataRequirementSort
from .distance import Distance
from .dosage import Dosage
from .dosage_dose_and_rate import DosageDoseAndRate
from .duration import Duration
from .expression import Expression
from .extension import Extension
from .human_name import HumanName
from .identifier import Identifier
from .meta import Meta
from .money import Money
from .parameter_definition import ParameterDefinition
from .period import Period
from .quantity import Quantity
from .range import Range
from .ratio import Ratio
from .reference import Reference
from .related_artifact import RelatedArtifact
from .sampled_data import SampledData
from .signature import Signature
from .timing import Timing
from .timing_repeat import TimingRepeat
from .trigger_definition import TriggerDefinition
from .usage_context import UsageContext
import typing_extensions
import typing
from ...core.serialization import FieldMetadata
import pydantic
from .invoice_status import InvoiceStatus
from .date_time import DateTime
from .invoice_participant import InvoiceParticipant
from .invoice_line_item import InvoiceLineItem
from .invoice_price_component import InvoicePriceComponent
from .markdown import Markdown
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class Invoice(BaseResource):
    """
    Invoice containing collected ChargeItems from an Account with calculated individual and total price for Billing purpose.
    """

    resource_type: typing_extensions.Annotated[
        typing.Literal["Invoice"], FieldMetadata(alias="resourceType")
    ] = "Invoice"
    identifier: typing.Optional[typing.List[Identifier]] = pydantic.Field(default=None)
    """
    Identifier of this Invoice, often used for reference in correspondence about this invoice or for tracking of payments.
    """

    status: typing.Optional[InvoiceStatus] = pydantic.Field(default=None)
    """
    The current state of the Invoice.
    """

    cancelled_reason: typing_extensions.Annotated[
        typing.Optional[str], FieldMetadata(alias="cancelledReason")
    ] = pydantic.Field(default=None)
    """
    In case of Invoice cancellation a reason must be given (entered in error, superseded by corrected invoice etc.).
    """

    type: typing.Optional[CodeableConcept] = pydantic.Field(default=None)
    """
    Type of Invoice depending on domain, realm an usage (e.g. internal/external, dental, preliminary).
    """

    subject: typing.Optional[Reference] = pydantic.Field(default=None)
    """
    The individual or set of individuals receiving the goods and services billed in this invoice.
    """

    recipient: typing.Optional[Reference] = pydantic.Field(default=None)
    """
    The individual or Organization responsible for balancing of this invoice.
    """

    date: typing.Optional[DateTime] = pydantic.Field(default=None)
    """
    Date/time(s) of when this Invoice was posted.
    """

    participant: typing.Optional[typing.List[InvoiceParticipant]] = pydantic.Field(
        default=None
    )
    """
    Indicates who or what performed or participated in the charged service.
    """

    issuer: typing.Optional[Reference] = pydantic.Field(default=None)
    """
    The organizationissuing the Invoice.
    """

    account: typing.Optional[Reference] = pydantic.Field(default=None)
    """
    Account which is supposed to be balanced with this Invoice.
    """

    line_item: typing_extensions.Annotated[
        typing.Optional[typing.List[InvoiceLineItem]], FieldMetadata(alias="lineItem")
    ] = pydantic.Field(default=None)
    """
    Each line item represents one charge for goods and services rendered. Details such as date, code and amount are found in the referenced ChargeItem resource.
    """

    total_price_component: typing_extensions.Annotated[
        typing.Optional[typing.List[InvoicePriceComponent]],
        FieldMetadata(alias="totalPriceComponent"),
    ] = pydantic.Field(default=None)
    """
    The total amount for the Invoice may be calculated as the sum of the line items with surcharges/deductions that apply in certain conditions. The priceComponent element can be used to offer transparency to the recipient of the Invoice of how the total price was calculated.
    """

    total_net: typing_extensions.Annotated[
        typing.Optional[Money], FieldMetadata(alias="totalNet")
    ] = pydantic.Field(default=None)
    """
    Invoice total , taxes excluded.
    """

    total_gross: typing_extensions.Annotated[
        typing.Optional[Money], FieldMetadata(alias="totalGross")
    ] = pydantic.Field(default=None)
    """
    Invoice total, tax included.
    """

    payment_terms: typing_extensions.Annotated[
        typing.Optional[Markdown], FieldMetadata(alias="paymentTerms")
    ] = pydantic.Field(default=None)
    """
    Payment details such as banking details, period of payment, deductibles, methods of payment.
    """

    note: typing.Optional[typing.List[Annotation]] = pydantic.Field(default=None)
    """
    Comments made about the invoice by the issuer, subject, or other participants.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow", frozen=True
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
