# This file was auto-generated by Fern from our API Definition.

from .base_resource import BaseResource
from .address import Address
from .age import Age
from .annotation import Annotation
from .attachment import Attachment
from .codeable_concept import CodeableConcept
from .coding import Coding
from .contact_detail import ContactDetail
from .contact_point import ContactPoint
from .contributor import Contributor
from .count import Count
from .data_requirement import DataRequirement
from .data_requirement_code_filter import DataRequirementCodeFilter
from .data_requirement_date_filter import DataRequirementDateFilter
from .data_requirement_sort import DataRequirementSort
from .distance import Distance
from .dosage import Dosage
from .dosage_dose_and_rate import DosageDoseAndRate
from .duration import Duration
from .expression import Expression
from .extension import Extension
from .human_name import HumanName
from .identifier import Identifier
from .meta import Meta
from .money import Money
from .parameter_definition import ParameterDefinition
from .period import Period
from .quantity import Quantity
from .range import Range
from .ratio import Ratio
from .reference import Reference
from .related_artifact import RelatedArtifact
from .sampled_data import SampledData
from .signature import Signature
from .timing import Timing
from .timing_repeat import TimingRepeat
from .trigger_definition import TriggerDefinition
from .usage_context import UsageContext
import typing_extensions
import typing
from ...core.serialization import FieldMetadata
import pydantic
from .insurance_plan_status import InsurancePlanStatus
from .insurance_plan_contact import InsurancePlanContact
from .insurance_plan_coverage import InsurancePlanCoverage
from .insurance_plan_plan import InsurancePlanPlan
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class InsurancePlan(BaseResource):
    """
    Details of a Health Insurance product/plan provided by an organization.
    """

    resource_type: typing_extensions.Annotated[
        typing.Literal["InsurancePlan"], FieldMetadata(alias="resourceType")
    ] = "InsurancePlan"
    identifier: typing.Optional[typing.List[Identifier]] = pydantic.Field(default=None)
    """
    Business identifiers assigned to this health insurance product which remain constant as the resource is updated and propagates from server to server.
    """

    status: typing.Optional[InsurancePlanStatus] = pydantic.Field(default=None)
    """
    The current state of the health insurance product.
    """

    type: typing.Optional[typing.List[CodeableConcept]] = pydantic.Field(default=None)
    """
    The kind of health insurance product.
    """

    name: typing.Optional[str] = pydantic.Field(default=None)
    """
    Official name of the health insurance product as designated by the owner.
    """

    alias: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    A list of alternate names that the product is known as, or was known as in the past.
    """

    period: typing.Optional[Period] = pydantic.Field(default=None)
    """
    The period of time that the health insurance product is available.
    """

    owned_by: typing_extensions.Annotated[
        typing.Optional[Reference], FieldMetadata(alias="ownedBy")
    ] = pydantic.Field(default=None)
    """
    The entity that is providing the health insurance product and underwriting the risk. This is typically an insurance carriers, other third-party payers, or health plan sponsors comonly referred to as 'payers'.
    """

    administered_by: typing_extensions.Annotated[
        typing.Optional[Reference], FieldMetadata(alias="administeredBy")
    ] = pydantic.Field(default=None)
    """
    An organization which administer other services such as underwriting, customer service and/or claims processing on behalf of the health insurance product owner.
    """

    coverage_area: typing_extensions.Annotated[
        typing.Optional[typing.List[Reference]], FieldMetadata(alias="coverageArea")
    ] = pydantic.Field(default=None)
    """
    The geographic region in which a health insurance product's benefits apply.
    """

    contact: typing.Optional[typing.List[InsurancePlanContact]] = pydantic.Field(
        default=None
    )
    """
    The contact for the health insurance product for a certain purpose.
    """

    endpoint: typing.Optional[typing.List[Reference]] = pydantic.Field(default=None)
    """
    The technical endpoints providing access to services operated for the health insurance product.
    """

    network: typing.Optional[typing.List[Reference]] = pydantic.Field(default=None)
    """
    Reference to the network included in the health insurance product.
    """

    coverage: typing.Optional[typing.List[InsurancePlanCoverage]] = pydantic.Field(
        default=None
    )
    """
    Details about the coverage offered by the insurance product.
    """

    plan: typing.Optional[typing.List[InsurancePlanPlan]] = pydantic.Field(default=None)
    """
    Details about an insurance plan.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow", frozen=True
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
