# This file was auto-generated by Fern from our API Definition.

from .base_resource import BaseResource
from .address import Address
from .age import Age
from .annotation import Annotation
from .attachment import Attachment
from .codeable_concept import CodeableConcept
from .coding import Coding
from .contact_detail import ContactDetail
from .contact_point import ContactPoint
from .contributor import Contributor
from .count import Count
from .data_requirement import DataRequirement
from .data_requirement_code_filter import DataRequirementCodeFilter
from .data_requirement_date_filter import DataRequirementDateFilter
from .data_requirement_sort import DataRequirementSort
from .distance import Distance
from .dosage import Dosage
from .dosage_dose_and_rate import DosageDoseAndRate
from .duration import Duration
from .expression import Expression
from .extension import Extension
from .human_name import HumanName
from .identifier import Identifier
from .meta import Meta
from .money import Money
from .parameter_definition import ParameterDefinition
from .period import Period
from .quantity import Quantity
from .range import Range
from .ratio import Ratio
from .reference import Reference
from .related_artifact import RelatedArtifact
from .sampled_data import SampledData
from .signature import Signature
from .timing import Timing
from .timing_repeat import TimingRepeat
from .trigger_definition import TriggerDefinition
from .usage_context import UsageContext
from .implementation_guide_page import ImplementationGuidePage
import typing_extensions
import typing
from ...core.serialization import FieldMetadata
from .uri import Uri
import pydantic
from .implementation_guide_status import ImplementationGuideStatus
from .date_time import DateTime
from .markdown import Markdown
from .id import Id
from .implementation_guide_license import ImplementationGuideLicense
from .implementation_guide_fhir_version_item import ImplementationGuideFhirVersionItem
from .implementation_guide_depends_on import ImplementationGuideDependsOn
from .implementation_guide_global import ImplementationGuideGlobal
from .implementation_guide_definition import ImplementationGuideDefinition
from .implementation_guide_manifest import ImplementationGuideManifest
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class ImplementationGuide(BaseResource):
    """
    A set of rules of how a particular interoperability or standards problem is solved - typically through the use of FHIR resources. This resource is used to gather all the parts of an implementation guide into a logical whole and to publish a computable definition of all the parts.
    """

    resource_type: typing_extensions.Annotated[
        typing.Literal["ImplementationGuide"], FieldMetadata(alias="resourceType")
    ] = "ImplementationGuide"
    url: typing.Optional[Uri] = pydantic.Field(default=None)
    """
    An absolute URI that is used to identify this implementation guide when it is referenced in a specification, model, design or an instance; also called its canonical identifier. This SHOULD be globally unique and SHOULD be a literal address at which at which an authoritative instance of this implementation guide is (or will be) published. This URL can be the target of a canonical reference. It SHALL remain the same when the implementation guide is stored on different servers.
    """

    version: typing.Optional[str] = pydantic.Field(default=None)
    """
    The identifier that is used to identify this version of the implementation guide when it is referenced in a specification, model, design or instance. This is an arbitrary value managed by the implementation guide author and is not expected to be globally unique. For example, it might be a timestamp (e.g. yyyymmdd) if a managed version is not available. There is also no expectation that versions can be placed in a lexicographical sequence.
    """

    name: typing.Optional[str] = pydantic.Field(default=None)
    """
    A natural language name identifying the implementation guide. This name should be usable as an identifier for the module by machine processing applications such as code generation.
    """

    title: typing.Optional[str] = pydantic.Field(default=None)
    """
    A short, descriptive, user-friendly title for the implementation guide.
    """

    status: typing.Optional[ImplementationGuideStatus] = pydantic.Field(default=None)
    """
    The status of this implementation guide. Enables tracking the life-cycle of the content.
    """

    experimental: typing.Optional[bool] = pydantic.Field(default=None)
    """
    A Boolean value to indicate that this implementation guide is authored for testing purposes (or education/evaluation/marketing) and is not intended to be used for genuine usage.
    """

    date: typing.Optional[DateTime] = pydantic.Field(default=None)
    """
    The date (and optionally time) when the implementation guide was published. The date must change when the business version changes and it must change if the status code changes. In addition, it should change when the substantive content of the implementation guide changes.
    """

    publisher: typing.Optional[str] = pydantic.Field(default=None)
    """
    The name of the organization or individual that published the implementation guide.
    """

    contact: typing.Optional[typing.List[ContactDetail]] = pydantic.Field(default=None)
    """
    Contact details to assist a user in finding and communicating with the publisher.
    """

    description: typing.Optional[Markdown] = pydantic.Field(default=None)
    """
    A free text natural language description of the implementation guide from a consumer's perspective.
    """

    use_context: typing_extensions.Annotated[
        typing.Optional[typing.List[UsageContext]], FieldMetadata(alias="useContext")
    ] = pydantic.Field(default=None)
    """
    The content was developed with a focus and intent of supporting the contexts that are listed. These contexts may be general categories (gender, age, ...) or may be references to specific programs (insurance plans, studies, ...) and may be used to assist with indexing and searching for appropriate implementation guide instances.
    """

    jurisdiction: typing.Optional[typing.List[CodeableConcept]] = pydantic.Field(
        default=None
    )
    """
    A legal or geographic region in which the implementation guide is intended to be used.
    """

    copyright: typing.Optional[Markdown] = pydantic.Field(default=None)
    """
    A copyright statement relating to the implementation guide and/or its contents. Copyright statements are generally legal restrictions on the use and publishing of the implementation guide.
    """

    package_id: typing_extensions.Annotated[
        typing.Optional[Id], FieldMetadata(alias="packageId")
    ] = pydantic.Field(default=None)
    """
    The NPM package name for this Implementation Guide, used in the NPM package distribution, which is the primary mechanism by which FHIR based tooling manages IG dependencies. This value must be globally unique, and should be assigned with care.
    """

    license: typing.Optional[ImplementationGuideLicense] = pydantic.Field(default=None)
    """
    The license that applies to this Implementation Guide, using an SPDX license code, or 'not-open-source'.
    """

    fhir_version: typing_extensions.Annotated[
        typing.Optional[typing.List[ImplementationGuideFhirVersionItem]],
        FieldMetadata(alias="fhirVersion"),
    ] = pydantic.Field(default=None)
    """
    The version(s) of the FHIR specification that this ImplementationGuide targets - e.g. describes how to use. The value of this element is the formal version of the specification, without the revision number, e.g. [publication].[major].[minor], which is 4.0.1. for this version.
    """

    depends_on: typing_extensions.Annotated[
        typing.Optional[typing.List[ImplementationGuideDependsOn]],
        FieldMetadata(alias="dependsOn"),
    ] = pydantic.Field(default=None)
    """
    Another implementation guide that this implementation depends on. Typically, an implementation guide uses value sets, profiles etc.defined in other implementation guides.
    """

    global_: typing_extensions.Annotated[
        typing.Optional[typing.List[ImplementationGuideGlobal]],
        FieldMetadata(alias="global"),
    ] = pydantic.Field(default=None)
    """
    A set of profiles that all resources covered by this implementation guide must conform to.
    """

    definition: typing.Optional[ImplementationGuideDefinition] = pydantic.Field(
        default=None
    )
    """
    The information needed by an IG publisher tool to publish the whole implementation guide.
    """

    manifest: typing.Optional[ImplementationGuideManifest] = pydantic.Field(
        default=None
    )
    """
    Information about an assembled implementation guide, created by the publication tooling.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow", frozen=True
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
