# This file was auto-generated by Fern from our API Definition.

from ...core.pydantic_utilities import UniversalBaseModel
from .address import Address
from .age import Age
from .annotation import Annotation
from .attachment import Attachment
from .codeable_concept import CodeableConcept
from .coding import Coding
from .contact_detail import ContactDetail
from .contact_point import ContactPoint
from .contributor import Contributor
from .count import Count
from .data_requirement import DataRequirement
from .data_requirement_code_filter import DataRequirementCodeFilter
from .data_requirement_date_filter import DataRequirementDateFilter
from .data_requirement_sort import DataRequirementSort
from .distance import Distance
from .dosage import Dosage
from .dosage_dose_and_rate import DosageDoseAndRate
from .duration import Duration
from .expression import Expression
from .extension import Extension
from .human_name import HumanName
from .identifier import Identifier
from .meta import Meta
from .money import Money
from .parameter_definition import ParameterDefinition
from .period import Period
from .quantity import Quantity
from .range import Range
from .ratio import Ratio
from .reference import Reference
from .related_artifact import RelatedArtifact
from .sampled_data import SampledData
from .signature import Signature
from .timing import Timing
from .timing_repeat import TimingRepeat
from .trigger_definition import TriggerDefinition
from .usage_context import UsageContext
import typing
import pydantic
import typing_extensions
from ...core.serialization import FieldMetadata
from .immunization_recommendation_date_criterion import (
    ImmunizationRecommendationDateCriterion,
)
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class ImmunizationRecommendationRecommendation(UniversalBaseModel):
    """
    A patient's point-in-time set of recommendations (i.e. forecasting) according to a published schedule with optional supporting justification.
    """

    id: typing.Optional[str] = pydantic.Field(default=None)
    """
    Unique id for the element within a resource (for internal references). This may be any string value that does not contain spaces.
    """

    extension: typing.Optional[typing.List[Extension]] = pydantic.Field(default=None)
    """
    May be used to represent additional information that is not part of the basic definition of the element. To make the use of extensions safe and manageable, there is a strict set of governance applied to the definition and use of extensions. Though any implementer can define an extension, there is a set of requirements that SHALL be met as part of the definition of the extension.
    """

    modifier_extension: typing_extensions.Annotated[
        typing.Optional[typing.List[Extension]],
        FieldMetadata(alias="modifierExtension"),
    ] = pydantic.Field(default=None)
    """
    May be used to represent additional information that is not part of the basic definition of the element and that modifies the understanding of the element in which it is contained and/or the understanding of the containing element's descendants. Usually modifier elements provide negation or qualification. To make the use of extensions safe and manageable, there is a strict set of governance applied to the definition and use of extensions. Though any implementer can define an extension, there is a set of requirements that SHALL be met as part of the definition of the extension. Applications processing a resource are required to check for modifier extensions. Modifier extensions SHALL NOT change the meaning of any elements on Resource or DomainResource (including cannot change the meaning of modifierExtension itself).
    """

    vaccine_code: typing_extensions.Annotated[
        typing.Optional[typing.List[CodeableConcept]],
        FieldMetadata(alias="vaccineCode"),
    ] = pydantic.Field(default=None)
    """
    Vaccine(s) or vaccine group that pertain to the recommendation.
    """

    target_disease: typing_extensions.Annotated[
        typing.Optional[CodeableConcept], FieldMetadata(alias="targetDisease")
    ] = pydantic.Field(default=None)
    """
    The targeted disease for the recommendation.
    """

    contraindicated_vaccine_code: typing_extensions.Annotated[
        typing.Optional[typing.List[CodeableConcept]],
        FieldMetadata(alias="contraindicatedVaccineCode"),
    ] = pydantic.Field(default=None)
    """
    Vaccine(s) which should not be used to fulfill the recommendation.
    """

    forecast_status: typing_extensions.Annotated[
        CodeableConcept, FieldMetadata(alias="forecastStatus")
    ] = pydantic.Field()
    """
    Indicates the patient status with respect to the path to immunity for the target disease.
    """

    forecast_reason: typing_extensions.Annotated[
        typing.Optional[typing.List[CodeableConcept]],
        FieldMetadata(alias="forecastReason"),
    ] = pydantic.Field(default=None)
    """
    The reason for the assigned forecast status.
    """

    date_criterion: typing_extensions.Annotated[
        typing.Optional[typing.List[ImmunizationRecommendationDateCriterion]],
        FieldMetadata(alias="dateCriterion"),
    ] = pydantic.Field(default=None)
    """
    Vaccine date recommendations. For example, earliest date to administer, latest date to administer, etc.
    """

    description: typing.Optional[str] = pydantic.Field(default=None)
    """
    Contains the description about the protocol under which the vaccine was administered.
    """

    series: typing.Optional[str] = pydantic.Field(default=None)
    """
    One possible path to achieve presumed immunity against a disease - within the context of an authority.
    """

    dose_number_positive_int: typing_extensions.Annotated[
        typing.Optional[float], FieldMetadata(alias="doseNumberPositiveInt")
    ] = pydantic.Field(default=None)
    """
    Nominal position of the recommended dose in a series (e.g. dose 2 is the next recommended dose).
    """

    dose_number_string: typing_extensions.Annotated[
        typing.Optional[str], FieldMetadata(alias="doseNumberString")
    ] = pydantic.Field(default=None)
    """
    Nominal position of the recommended dose in a series (e.g. dose 2 is the next recommended dose).
    """

    series_doses_positive_int: typing_extensions.Annotated[
        typing.Optional[float], FieldMetadata(alias="seriesDosesPositiveInt")
    ] = pydantic.Field(default=None)
    """
    The recommended number of doses to achieve immunity.
    """

    series_doses_string: typing_extensions.Annotated[
        typing.Optional[str], FieldMetadata(alias="seriesDosesString")
    ] = pydantic.Field(default=None)
    """
    The recommended number of doses to achieve immunity.
    """

    supporting_immunization: typing_extensions.Annotated[
        typing.Optional[typing.List[Reference]],
        FieldMetadata(alias="supportingImmunization"),
    ] = pydantic.Field(default=None)
    """
    Immunization event history and/or evaluation that supports the status and recommendation.
    """

    supporting_patient_information: typing_extensions.Annotated[
        typing.Optional[typing.List[Reference]],
        FieldMetadata(alias="supportingPatientInformation"),
    ] = pydantic.Field(default=None)
    """
    Patient Information that supports the status and recommendation. This includes patient observations, adverse reactions and allergy/intolerance information.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow", frozen=True
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
