# This file was auto-generated by Fern from our API Definition.

from .base_resource import BaseResource
from .address import Address
from .age import Age
from .annotation import Annotation
from .attachment import Attachment
from .codeable_concept import CodeableConcept
from .coding import Coding
from .contact_detail import ContactDetail
from .contact_point import ContactPoint
from .contributor import Contributor
from .count import Count
from .data_requirement import DataRequirement
from .data_requirement_code_filter import DataRequirementCodeFilter
from .data_requirement_date_filter import DataRequirementDateFilter
from .data_requirement_sort import DataRequirementSort
from .distance import Distance
from .dosage import Dosage
from .dosage_dose_and_rate import DosageDoseAndRate
from .duration import Duration
from .expression import Expression
from .extension import Extension
from .human_name import HumanName
from .identifier import Identifier
from .meta import Meta
from .money import Money
from .parameter_definition import ParameterDefinition
from .period import Period
from .quantity import Quantity
from .range import Range
from .ratio import Ratio
from .reference import Reference
from .related_artifact import RelatedArtifact
from .sampled_data import SampledData
from .signature import Signature
from .timing import Timing
from .timing_repeat import TimingRepeat
from .trigger_definition import TriggerDefinition
from .usage_context import UsageContext
import typing_extensions
import typing
from ...core.serialization import FieldMetadata
import pydantic
from .date_time import DateTime
from .immunization_recommendation_recommendation import (
    ImmunizationRecommendationRecommendation,
)
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class ImmunizationRecommendation(BaseResource):
    """
    A patient's point-in-time set of recommendations (i.e. forecasting) according to a published schedule with optional supporting justification.
    """

    resource_type: typing_extensions.Annotated[
        typing.Literal["ImmunizationRecommendation"],
        FieldMetadata(alias="resourceType"),
    ] = "ImmunizationRecommendation"
    identifier: typing.Optional[typing.List[Identifier]] = pydantic.Field(default=None)
    """
    A unique identifier assigned to this particular recommendation record.
    """

    patient: Reference = pydantic.Field()
    """
    The patient the recommendation(s) are for.
    """

    date: typing.Optional[DateTime] = pydantic.Field(default=None)
    """
    The date the immunization recommendation(s) were created.
    """

    authority: typing.Optional[Reference] = pydantic.Field(default=None)
    """
    Indicates the authority who published the protocol (e.g. ACIP).
    """

    recommendation: typing.List[ImmunizationRecommendationRecommendation] = (
        pydantic.Field()
    )
    """
    Vaccine administration recommendations.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow", frozen=True
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
