# This file was auto-generated by Fern from our API Definition.

from .base_resource import BaseResource
from .address import Address
from .age import Age
from .annotation import Annotation
from .attachment import Attachment
from .codeable_concept import CodeableConcept
from .coding import Coding
from .contact_detail import ContactDetail
from .contact_point import ContactPoint
from .contributor import Contributor
from .count import Count
from .data_requirement import DataRequirement
from .data_requirement_code_filter import DataRequirementCodeFilter
from .data_requirement_date_filter import DataRequirementDateFilter
from .data_requirement_sort import DataRequirementSort
from .distance import Distance
from .dosage import Dosage
from .dosage_dose_and_rate import DosageDoseAndRate
from .duration import Duration
from .expression import Expression
from .extension import Extension
from .human_name import HumanName
from .identifier import Identifier
from .meta import Meta
from .money import Money
from .parameter_definition import ParameterDefinition
from .period import Period
from .quantity import Quantity
from .range import Range
from .ratio import Ratio
from .reference import Reference
from .related_artifact import RelatedArtifact
from .sampled_data import SampledData
from .signature import Signature
from .timing import Timing
from .timing_repeat import TimingRepeat
from .trigger_definition import TriggerDefinition
from .usage_context import UsageContext
import typing_extensions
import typing
from ...core.serialization import FieldMetadata
import pydantic
from .code import Code
from .date_time import DateTime
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class ImmunizationEvaluation(BaseResource):
    """
    Describes a comparison of an immunization event against published recommendations to determine if the administration is "valid" in relation to those recommendations.
    """

    resource_type: typing_extensions.Annotated[
        typing.Literal["ImmunizationEvaluation"], FieldMetadata(alias="resourceType")
    ] = "ImmunizationEvaluation"
    identifier: typing.Optional[typing.List[Identifier]] = pydantic.Field(default=None)
    """
    A unique identifier assigned to this immunization evaluation record.
    """

    status: typing.Optional[Code] = pydantic.Field(default=None)
    """
    Indicates the current status of the evaluation of the vaccination administration event.
    """

    patient: Reference = pydantic.Field()
    """
    The individual for whom the evaluation is being done.
    """

    date: typing.Optional[DateTime] = pydantic.Field(default=None)
    """
    The date the evaluation of the vaccine administration event was performed.
    """

    authority: typing.Optional[Reference] = pydantic.Field(default=None)
    """
    Indicates the authority who published the protocol (e.g. ACIP).
    """

    target_disease: typing_extensions.Annotated[
        CodeableConcept, FieldMetadata(alias="targetDisease")
    ] = pydantic.Field()
    """
    The vaccine preventable disease the dose is being evaluated against.
    """

    immunization_event: typing_extensions.Annotated[
        Reference, FieldMetadata(alias="immunizationEvent")
    ] = pydantic.Field()
    """
    The vaccine administration event being evaluated.
    """

    dose_status: typing_extensions.Annotated[
        CodeableConcept, FieldMetadata(alias="doseStatus")
    ] = pydantic.Field()
    """
    Indicates if the dose is valid or not valid with respect to the published recommendations.
    """

    dose_status_reason: typing_extensions.Annotated[
        typing.Optional[typing.List[CodeableConcept]],
        FieldMetadata(alias="doseStatusReason"),
    ] = pydantic.Field(default=None)
    """
    Provides an explanation as to why the vaccine administration event is valid or not relative to the published recommendations.
    """

    description: typing.Optional[str] = pydantic.Field(default=None)
    """
    Additional information about the evaluation.
    """

    series: typing.Optional[str] = pydantic.Field(default=None)
    """
    One possible path to achieve presumed immunity against a disease - within the context of an authority.
    """

    dose_number_positive_int: typing_extensions.Annotated[
        typing.Optional[float], FieldMetadata(alias="doseNumberPositiveInt")
    ] = pydantic.Field(default=None)
    """
    Nominal position in a series.
    """

    dose_number_string: typing_extensions.Annotated[
        typing.Optional[str], FieldMetadata(alias="doseNumberString")
    ] = pydantic.Field(default=None)
    """
    Nominal position in a series.
    """

    series_doses_positive_int: typing_extensions.Annotated[
        typing.Optional[float], FieldMetadata(alias="seriesDosesPositiveInt")
    ] = pydantic.Field(default=None)
    """
    The recommended number of doses to achieve immunity.
    """

    series_doses_string: typing_extensions.Annotated[
        typing.Optional[str], FieldMetadata(alias="seriesDosesString")
    ] = pydantic.Field(default=None)
    """
    The recommended number of doses to achieve immunity.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow", frozen=True
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
