# This file was auto-generated by Fern from our API Definition.

from .base_resource import BaseResource
from .address import Address
from .age import Age
from .annotation import Annotation
from .attachment import Attachment
from .codeable_concept import CodeableConcept
from .coding import Coding
from .contact_detail import ContactDetail
from .contact_point import ContactPoint
from .contributor import Contributor
from .count import Count
from .data_requirement import DataRequirement
from .data_requirement_code_filter import DataRequirementCodeFilter
from .data_requirement_date_filter import DataRequirementDateFilter
from .data_requirement_sort import DataRequirementSort
from .distance import Distance
from .dosage import Dosage
from .dosage_dose_and_rate import DosageDoseAndRate
from .duration import Duration
from .expression import Expression
from .extension import Extension
from .human_name import HumanName
from .identifier import Identifier
from .meta import Meta
from .money import Money
from .parameter_definition import ParameterDefinition
from .period import Period
from .quantity import Quantity
from .range import Range
from .ratio import Ratio
from .reference import Reference
from .related_artifact import RelatedArtifact
from .sampled_data import SampledData
from .signature import Signature
from .timing import Timing
from .timing_repeat import TimingRepeat
from .trigger_definition import TriggerDefinition
from .usage_context import UsageContext
import typing_extensions
import typing
from ...core.serialization import FieldMetadata
import pydantic
from .code import Code
from .date_time import DateTime
import datetime as dt
from .immunization_performer import ImmunizationPerformer
from .immunization_education import ImmunizationEducation
from .immunization_reaction import ImmunizationReaction
from .immunization_protocol_applied import ImmunizationProtocolApplied
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class Immunization(BaseResource):
    """
    Describes the event of a patient being administered a vaccine or a record of an immunization as reported by a patient, a clinician or another party.
    """

    resource_type: typing_extensions.Annotated[
        typing.Literal["Immunization"], FieldMetadata(alias="resourceType")
    ] = "Immunization"
    identifier: typing.Optional[typing.List[Identifier]] = pydantic.Field(default=None)
    """
    A unique identifier assigned to this immunization record.
    """

    status: typing.Optional[Code] = pydantic.Field(default=None)
    """
    Indicates the current status of the immunization event.
    """

    status_reason: typing_extensions.Annotated[
        typing.Optional[CodeableConcept], FieldMetadata(alias="statusReason")
    ] = pydantic.Field(default=None)
    """
    Indicates the reason the immunization event was not performed.
    """

    vaccine_code: typing_extensions.Annotated[
        CodeableConcept, FieldMetadata(alias="vaccineCode")
    ] = pydantic.Field()
    """
    Vaccine that was administered or was to be administered.
    """

    patient: Reference = pydantic.Field()
    """
    The patient who either received or did not receive the immunization.
    """

    encounter: typing.Optional[Reference] = pydantic.Field(default=None)
    """
    The visit or admission or other contact between patient and health care provider the immunization was performed as part of.
    """

    occurrence_date_time: typing_extensions.Annotated[
        typing.Optional[str], FieldMetadata(alias="occurrenceDateTime")
    ] = pydantic.Field(default=None)
    """
    Date vaccine administered or was to be administered.
    """

    occurrence_string: typing_extensions.Annotated[
        typing.Optional[str], FieldMetadata(alias="occurrenceString")
    ] = pydantic.Field(default=None)
    """
    Date vaccine administered or was to be administered.
    """

    recorded: typing.Optional[DateTime] = pydantic.Field(default=None)
    """
    The date the occurrence of the immunization was first captured in the record - potentially significantly after the occurrence of the event.
    """

    primary_source: typing_extensions.Annotated[
        typing.Optional[bool], FieldMetadata(alias="primarySource")
    ] = pydantic.Field(default=None)
    """
    An indication that the content of the record is based on information from the person who administered the vaccine. This reflects the context under which the data was originally recorded.
    """

    report_origin: typing_extensions.Annotated[
        typing.Optional[CodeableConcept], FieldMetadata(alias="reportOrigin")
    ] = pydantic.Field(default=None)
    """
    The source of the data when the report of the immunization event is not based on information from the person who administered the vaccine.
    """

    location: typing.Optional[Reference] = pydantic.Field(default=None)
    """
    The service delivery location where the vaccine administration occurred.
    """

    manufacturer: typing.Optional[Reference] = pydantic.Field(default=None)
    """
    Name of vaccine manufacturer.
    """

    lot_number: typing_extensions.Annotated[
        typing.Optional[str], FieldMetadata(alias="lotNumber")
    ] = pydantic.Field(default=None)
    """
    Lot number of the vaccine product.
    """

    expiration_date: typing_extensions.Annotated[
        typing.Optional[dt.date], FieldMetadata(alias="expirationDate")
    ] = pydantic.Field(default=None)
    """
    Date vaccine batch expires.
    """

    site: typing.Optional[CodeableConcept] = pydantic.Field(default=None)
    """
    Body site where vaccine was administered.
    """

    route: typing.Optional[CodeableConcept] = pydantic.Field(default=None)
    """
    The path by which the vaccine product is taken into the body.
    """

    dose_quantity: typing_extensions.Annotated[
        typing.Optional[Quantity], FieldMetadata(alias="doseQuantity")
    ] = pydantic.Field(default=None)
    """
    The quantity of vaccine product that was administered.
    """

    performer: typing.Optional[typing.List[ImmunizationPerformer]] = pydantic.Field(
        default=None
    )
    """
    Indicates who performed the immunization event.
    """

    note: typing.Optional[typing.List[Annotation]] = pydantic.Field(default=None)
    """
    Extra information about the immunization that is not conveyed by the other attributes.
    """

    reason_code: typing_extensions.Annotated[
        typing.Optional[typing.List[CodeableConcept]], FieldMetadata(alias="reasonCode")
    ] = pydantic.Field(default=None)
    """
    Reasons why the vaccine was administered.
    """

    reason_reference: typing_extensions.Annotated[
        typing.Optional[typing.List[Reference]], FieldMetadata(alias="reasonReference")
    ] = pydantic.Field(default=None)
    """
    Condition, Observation or DiagnosticReport that supports why the immunization was administered.
    """

    is_subpotent: typing_extensions.Annotated[
        typing.Optional[bool], FieldMetadata(alias="isSubpotent")
    ] = pydantic.Field(default=None)
    """
    Indication if a dose is considered to be subpotent. By default, a dose should be considered to be potent.
    """

    subpotent_reason: typing_extensions.Annotated[
        typing.Optional[typing.List[CodeableConcept]],
        FieldMetadata(alias="subpotentReason"),
    ] = pydantic.Field(default=None)
    """
    Reason why a dose is considered to be subpotent.
    """

    education: typing.Optional[typing.List[ImmunizationEducation]] = pydantic.Field(
        default=None
    )
    """
    Educational material presented to the patient (or guardian) at the time of vaccine administration.
    """

    program_eligibility: typing_extensions.Annotated[
        typing.Optional[typing.List[CodeableConcept]],
        FieldMetadata(alias="programEligibility"),
    ] = pydantic.Field(default=None)
    """
    Indicates a patient's eligibility for a funding program.
    """

    funding_source: typing_extensions.Annotated[
        typing.Optional[CodeableConcept], FieldMetadata(alias="fundingSource")
    ] = pydantic.Field(default=None)
    """
    Indicates the source of the vaccine actually administered. This may be different than the patient eligibility (e.g. the patient may be eligible for a publically purchased vaccine but due to inventory issues, vaccine purchased with private funds was actually administered).
    """

    reaction: typing.Optional[typing.List[ImmunizationReaction]] = pydantic.Field(
        default=None
    )
    """
    Categorical data indicating that an adverse event is associated in time to an immunization.
    """

    protocol_applied: typing_extensions.Annotated[
        typing.Optional[typing.List[ImmunizationProtocolApplied]],
        FieldMetadata(alias="protocolApplied"),
    ] = pydantic.Field(default=None)
    """
    The protocol (set of recommendations) being followed by the provider who administered the dose.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow", frozen=True
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
