# This file was auto-generated by Fern from our API Definition.

from ...core.pydantic_utilities import UniversalBaseModel
from .address import Address
from .age import Age
from .annotation import Annotation
from .attachment import Attachment
from .codeable_concept import CodeableConcept
from .coding import Coding
from .contact_detail import ContactDetail
from .contact_point import ContactPoint
from .contributor import Contributor
from .count import Count
from .data_requirement import DataRequirement
from .data_requirement_code_filter import DataRequirementCodeFilter
from .data_requirement_date_filter import DataRequirementDateFilter
from .data_requirement_sort import DataRequirementSort
from .distance import Distance
from .dosage import Dosage
from .dosage_dose_and_rate import DosageDoseAndRate
from .duration import Duration
from .expression import Expression
from .extension import Extension
from .human_name import HumanName
from .identifier import Identifier
from .meta import Meta
from .money import Money
from .parameter_definition import ParameterDefinition
from .period import Period
from .quantity import Quantity
from .range import Range
from .ratio import Ratio
from .reference import Reference
from .related_artifact import RelatedArtifact
from .sampled_data import SampledData
from .signature import Signature
from .timing import Timing
from .timing_repeat import TimingRepeat
from .trigger_definition import TriggerDefinition
from .usage_context import UsageContext
import typing
import pydantic
import typing_extensions
from ...core.serialization import FieldMetadata
from .id import Id
from .unsigned_int import UnsignedInt
from .date_time import DateTime
from .imaging_study_performer import ImagingStudyPerformer
from .imaging_study_instance import ImagingStudyInstance
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class ImagingStudySeries(UniversalBaseModel):
    """
    Representation of the content produced in a DICOM imaging study. A study comprises a set of series, each of which includes a set of Service-Object Pair Instances (SOP Instances - images or other data) acquired or produced in a common context. A series is of only one modality (e.g. X-ray, CT, MR, ultrasound), but a study may have multiple series of different modalities.
    """

    id: typing.Optional[str] = pydantic.Field(default=None)
    """
    Unique id for the element within a resource (for internal references). This may be any string value that does not contain spaces.
    """

    extension: typing.Optional[typing.List[Extension]] = pydantic.Field(default=None)
    """
    May be used to represent additional information that is not part of the basic definition of the element. To make the use of extensions safe and manageable, there is a strict set of governance applied to the definition and use of extensions. Though any implementer can define an extension, there is a set of requirements that SHALL be met as part of the definition of the extension.
    """

    modifier_extension: typing_extensions.Annotated[
        typing.Optional[typing.List[Extension]],
        FieldMetadata(alias="modifierExtension"),
    ] = pydantic.Field(default=None)
    """
    May be used to represent additional information that is not part of the basic definition of the element and that modifies the understanding of the element in which it is contained and/or the understanding of the containing element's descendants. Usually modifier elements provide negation or qualification. To make the use of extensions safe and manageable, there is a strict set of governance applied to the definition and use of extensions. Though any implementer can define an extension, there is a set of requirements that SHALL be met as part of the definition of the extension. Applications processing a resource are required to check for modifier extensions. Modifier extensions SHALL NOT change the meaning of any elements on Resource or DomainResource (including cannot change the meaning of modifierExtension itself).
    """

    uid: typing.Optional[Id] = pydantic.Field(default=None)
    """
    The DICOM Series Instance UID for the series.
    """

    number: typing.Optional[UnsignedInt] = pydantic.Field(default=None)
    """
    The numeric identifier of this series in the study.
    """

    modality: Coding = pydantic.Field()
    """
    The modality of this series sequence.
    """

    description: typing.Optional[str] = pydantic.Field(default=None)
    """
    A description of the series.
    """

    number_of_instances: typing_extensions.Annotated[
        typing.Optional[UnsignedInt], FieldMetadata(alias="numberOfInstances")
    ] = pydantic.Field(default=None)
    """
    Number of SOP Instances in the Study. The value given may be larger than the number of instance elements this resource contains due to resource availability, security, or other factors. This element should be present if any instance elements are present.
    """

    endpoint: typing.Optional[typing.List[Reference]] = pydantic.Field(default=None)
    """
    The network service providing access (e.g., query, view, or retrieval) for this series. See implementation notes for information about using DICOM endpoints. A series-level endpoint, if present, has precedence over a study-level endpoint with the same Endpoint.connectionType.
    """

    body_site: typing_extensions.Annotated[
        typing.Optional[Coding], FieldMetadata(alias="bodySite")
    ] = pydantic.Field(default=None)
    """
    The anatomic structures examined. See DICOM Part 16 Annex L (http://dicom.nema.org/medical/dicom/current/output/chtml/part16/chapter_L.html) for DICOM to SNOMED-CT mappings. The bodySite may indicate the laterality of body part imaged; if so, it shall be consistent with any content of ImagingStudy.series.laterality.
    """

    laterality: typing.Optional[Coding] = pydantic.Field(default=None)
    """
    The laterality of the (possibly paired) anatomic structures examined. E.g., the left knee, both lungs, or unpaired abdomen. If present, shall be consistent with any laterality information indicated in ImagingStudy.series.bodySite.
    """

    specimen: typing.Optional[typing.List[Reference]] = pydantic.Field(default=None)
    """
    The specimen imaged, e.g., for whole slide imaging of a biopsy.
    """

    started: typing.Optional[DateTime] = pydantic.Field(default=None)
    """
    The date and time the series was started.
    """

    performer: typing.Optional[typing.List[ImagingStudyPerformer]] = pydantic.Field(
        default=None
    )
    """
    Indicates who or what performed the series and how they were involved.
    """

    instance: typing.Optional[typing.List[ImagingStudyInstance]] = pydantic.Field(
        default=None
    )
    """
    A single SOP instance within the series, e.g. an image, or presentation state.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow", frozen=True
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
